/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.AlleleDropOffLog;
import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.Discrepancy;
import fileOperation.MatchParameters;
import fileOperation.MatchStatistics;
import fileOperation.OneMatch;
import fileOperation.SummarizeTypingResult;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import misc.FileManager;
import misc.StringUtils;
import misc.SystemCommand;

public class ParseFastaByHapType9 {
    private static final String EXON23 = "exon23";
    private static final int PRIMER_SIZE = 18;
    private static final int MIN_HIT = 10;
    static String LABEL = "000000";
    static String EXON_SEPERATOR = "XXXXXXXXXX";
    static String HAP_AMB_TXT = "-hap-amb.txt";
    static String HASH_TXT = "-hash.txt";
    static int COVERAGE_CUTOFF = 10;
    static int IMAGE_TO_DRAW = 10;
    private static final int IMAGE_HEIGHT = 1000;
    private static final int IMAGE_SEQUENCE_POSITION = 450;
    private static final int IMAGE_WIDTH = 1000;
    private static final int IMAGE_SEQUENCE_BAR_HEIGHT = 10;
    private static final int INDEX_SPACE = 16;
    private static final int INDEX_POSITION = 424;
    private static final int LETTER_WIDTH = 8;
    private static final int DEEPTH_HEIGHT = 400;
    private static final int LABEL_POSITION = 650;
    private static final int AMPLICON_TO_DRAW = 100;
    private static final int AMPLICON_HEIGHT = 400;
    private static String DRB1_07_SPECIFIC = "TTCCTGTGGCAGGG";
    private static String DPB1_DROP_SPECIFIC = "GTG.ACCAGTT";
    private static String DPB1_DROP_CASE1 = "GTGTACCAGTT";
    private static String DPB1_DROP_CASE2 = "GTGCACCAGTT";
    private static String DPB1_DROP_CASE3 = "GTGGACCAGTT";
    private static String DPB1_DROP_STABLE = "CCAGTT";
    private static String DPB1_DROP_GROUP1 = "CGTGTACCAGTT";
    private static String DPB1_DROP_GROUP2 = "CGTGCACCAGTT";
    private static String DPB1_DROP_SPECIAL1 = "AGTGTACCAGTT";
    private static String DPB1_DROP_SPECIAL2 = "CGTGGACCAGTT";
    private static final int COUNT_CUTOFF = 25;
    private static final int DRB1_07_STABLE_SIZE = 22;
    private static String DRB1_07_SPECIFIC2 = "AAGTATAAGTGTCATTT";
    private static String DRB1_07_SPECIFIC3 = "TTCAACGGG";
    private static final int DRB1_07_STABLE_SIZE_EXTENSION = 47;
    private static final String[] DRB1_07_SPECIFIC23_EXCLUDING = new String[]{"DRB1*07:22", "DRB1*07:01:02", "DRB1*07:21"};
    private static final int RESULT_NUM_OUTPUT = 20;
    private static final int MIN_PAIRS_COMPLETE_COVERAGE_COUNT = 5;
    private static final boolean INCLUDE_BRIDGE_READS = true;
    private static final int EXON_BOUNDARY = 270;
    private static final int PARTITION_SIZE = 10000;
    private static final boolean INGNORE_MISMATCH_AT_PRIMER_SITE = true;
    private static final int SINGLE_EXON_ENOUGH_COUNT = 500;
    private static final int FAST_MODE_COUNT = 50;
    static int FILTER_LEVEL = 4;
    static int CUT_OFF = 50;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File hapTypeRoot = new File(args[1]);
        File outputFile = new File(args[2]);
        File outputImageDir = new File(args[3]);
        String name = new String(args[4]);
        double mismatchAllowed = new Double(args[5]);
        int misPenalty = new Integer(args[6]);
        int matchMinScore = new Integer(args[7]);
        int readSize = new Integer(args[8]);
        boolean alignType = new Boolean(args[9]);
        boolean isPrimerMaskOff = new Boolean(args[10]);
        boolean drawImage = new Boolean(args[11]);
        boolean useFastMode = new Boolean(args[12]);
        MatchParameters mp = new MatchParameters();
        mp.setMismatchAllowed(mismatchAllowed);
        mp.setMatchMinScore(matchMinScore);
        mp.setMisPenalty(misPenalty);
        mp.setReadSize(readSize);
        mp.setAlignType(alignType);
        mp.setPrimerMaskOff(isPrimerMaskOff);
        mp.setDrawImage(drawImage);
        mp.setUseFastMode(useFastMode);
        StringBuilder result = new StringBuilder();
        ParseFastaByHapType9.startType(fastaFile, hapTypeRoot, outputFile, outputImageDir, name, result, mp);
        System.out.println(result.toString());
    }

    public static void startType(File fastaFile, File hapTypeRoot, File outputFile, File outputImageDir, String name, StringBuilder resultSummary, MatchParameters mp) throws Exception {
        File[] hapFiles;
        System.out.println("memory usage 000: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
        HashMap<String, String> inputSequences = new HashMap<String, String>();
        File newFasta = ParseFastaByHapType9.getSequenceFromFastaAndMaskPrimer(fastaFile, inputSequences, mp.isPrimerMaskOff());
        mp.setTotalReads(inputSequences.size());
        StringBuilder builder = new StringBuilder();
        File[] fileArray = hapFiles = hapTypeRoot.listFiles();
        int n = hapFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File hapFile = fileArray[n2];
            if (hapFile.getName().endsWith("fa")) {
                long startTime = System.currentTimeMillis();
                System.out.println("memory usage start haptype: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
                AlleleDropOffLog alleleDropOffLog = new AlleleDropOffLog();
                if (hapFile.getName().startsWith("DPB1-exon2") || hapFile.getName().startsWith("DRB1345-exon2")) {
                    ParseFastaByHapType9.populateAlleleDropOffLog(inputSequences, alleleDropOffLog, hapFile.getName());
                }
                File hapAmbFile = new File(hapTypeRoot, String.valueOf(hapFile.getName().substring(0, hapFile.getName().length() - 3)) + HAP_AMB_TXT);
                File hashFile = new File(hapTypeRoot, String.valueOf(hapFile.getName().substring(0, hapFile.getName().length() - 3)) + HASH_TXT);
                ArrayList<String> filteredRulesSet = new ArrayList<String>();
                if (mp.isUseHash() && hashFile != null && hashFile.exists()) {
                    ParseFastaByHapType9.filterRuleSet(filteredRulesSet, hashFile, newFasta);
                }
                HashMap<String, String> hapNames = new HashMap<String, String>();
                if (hapAmbFile.exists()) {
                    System.out.println("parse hap amb file " + hapAmbFile.getName());
                    ParseFastaByHapType9.populateHapAmbNames(hapNames, hapAmbFile);
                }
                builder.append("\n---------").append(hapFile.getName());
                resultSummary.append("\n");
                File tmpFile = ParseFastaByHapType9.organizeFastaByHap(hapNames, hapFile, filteredRulesSet);
                Map<String, String> sequences = SummarizeTypingResult.organizeSequenceFromFasta(hapNames, hapFile);
                ArrayList<String> DPBdropTypes = new ArrayList<String>();
                ArrayList<String> DPBdropGroup1Types = new ArrayList<String>();
                ArrayList<String> DPBdropGroup2Types = new ArrayList<String>();
                if (alleleDropOffLog.isDPBdropPresent()) {
                    ParseFastaByHapType9.gatherDPB1DropTypes(sequences, DPBdropTypes, DPBdropGroup1Types, DPBdropGroup2Types);
                }
                int exonSize = FileManager.readTextFile(tmpFile).split("\n")[1].trim().length();
                if (hapFile.getName().indexOf(EXON23) > 0) {
                    exonSize -= EXON_SEPERATOR.length();
                }
                builder.append(" exon size=").append(exonSize).append("\n");
                builder.append("Hap Type\t").append("#Pairs Support Match\t").append("#Pairs Perfect Match\t").append("Average Amplicon Size\t").append("#Positions w >=8x Coverage\t").append("Positions w >30% mismatch\t").append("#Pairs Unique for this Type\t").append("index\n");
                File outputImage = new File(outputImageDir, String.valueOf(name) + "-" + hapFile.getName().split("\\.")[0] + ".jpg");
                System.out.println("memory usage 1 before cross_match: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
                Map<String, Map<String, OneMatch>> result = ParseFastaByHapType9.getCrossMatchRecords(newFasta, tmpFile, mp, alleleDropOffLog, DPBdropTypes, DPBdropGroup1Types, DPBdropGroup2Types, inputSequences, hapFile.getName(), mp.isUseFastMode(), sequences);
                if (hapFile.getName().indexOf(EXON23) > 0) {
                    ParseFastaByHapType9.cleanSequences(sequences);
                }
                System.out.println("memory usage 2 after cross_match: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
                boolean needMoreTyping = ParseFastaByHapType9.output(result, hapFile, 0, builder, exonSize, outputImage, resultSummary, hapFile.getName(), name, inputSequences, sequences, mp, alleleDropOffLog);
                if (needMoreTyping) {
                    builder.append("******* further typing based on single direction match \n");
                    ParseFastaByHapType9.output(result, hapFile, 1, builder, exonSize, outputImage, resultSummary, hapFile.getName(), name, inputSequences, sequences, mp, alleleDropOffLog);
                }
                ParseFastaByHapType9.logMethodTime("Done this type ...", System.currentTimeMillis() - startTime);
                System.out.println("memory usage end haptype: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
                ParseFastaByHapType9.cleanup(tmpFile);
            }
            ++n2;
        }
        FileManager.writeTextFile(outputFile, builder.toString(), true);
        ParseFastaByHapType9.cleanup(newFasta);
    }

    private static void cleanSequences(Map<String, String> sequences) {
        for (String type : sequences.keySet()) {
            String seq = sequences.get(type).replaceAll("X", "");
            sequences.put(type, seq);
        }
    }

    private static void cleanup(File fn) {
        fn.delete();
        File log = new File(String.valueOf(fn.getAbsolutePath()) + ".log");
        if (log.exists() && log.isFile()) {
            log.delete();
        }
    }

    private static void filterRuleSet(List<String> filteredRulesSet, File hashFile, File newFasta) {
        String data = FileManager.readTextFile(newFasta);
        int i = 0;
        while (i < FILTER_LEVEL) {
            HashMap<String, List<String>> fhashSeq2 = new HashMap<String, List<String>>();
            HashMap<String, List<String>> rhashSeq2 = new HashMap<String, List<String>>();
            HashMap<String, List<String>> fhashSeq3 = new HashMap<String, List<String>>();
            HashMap<String, List<String>> rhashSeq3 = new HashMap<String, List<String>>();
            ArrayList<String> ftypesExon2 = new ArrayList<String>();
            ArrayList<String> rtypesExon2 = new ArrayList<String>();
            ArrayList<String> ftypesExon3 = new ArrayList<String>();
            ArrayList<String> rtypesExon3 = new ArrayList<String>();
            ParseFastaByHapType9.getHashSeq(hashFile, fhashSeq2, rhashSeq2, i, 2);
            ParseFastaByHapType9.getHashSeq(hashFile, fhashSeq3, rhashSeq3, i, 3);
            ParseFastaByHapType9.testAndFilter(data, fhashSeq2, ftypesExon2);
            ParseFastaByHapType9.testAndFilter(data, rhashSeq2, rtypesExon2);
            ParseFastaByHapType9.testAndFilter(data, fhashSeq3, ftypesExon3);
            ParseFastaByHapType9.testAndFilter(data, rhashSeq3, rtypesExon3);
            ArrayList<String> passTypes = new ArrayList<String>();
            for (String type : ftypesExon2) {
                if (!rtypesExon2.contains(type) || !ftypesExon3.contains(type) || !rtypesExon3.contains(type)) continue;
                passTypes.add(type);
            }
            if (i == 0) {
                filteredRulesSet.addAll(passTypes);
            } else {
                Iterator<String> it = filteredRulesSet.iterator();
                while (it.hasNext()) {
                    String t = it.next();
                    if (passTypes.contains(t)) continue;
                    it.remove();
                }
            }
            System.out.println("round " + i + " " + filteredRulesSet.size());
            ++i;
        }
        System.out.println("after hash filtering, ruleset size=" + filteredRulesSet.size());
    }

    private static void testAndFilter(String data, Map<String, List<String>> hashSeq, List<String> ftypesExon2) {
        for (String seq : hashSeq.keySet()) {
            int c = ParseFastaByHapType9.count(data, seq);
            if (c <= CUT_OFF) continue;
            ftypesExon2.addAll((Collection<String>)hashSeq.get(seq));
        }
    }

    public static int count(String string, String substring) {
        int count = 0;
        int idx = 0;
        while ((idx = string.indexOf(substring, idx)) != -1) {
            ++idx;
            if (++count > CUT_OFF) break;
        }
        return count;
    }

    private static void getHashSeq(File hashFile, Map<String, List<String>> fhashSeq, Map<String, List<String>> rhashSeq, int i, int exon) {
        String[] lines;
        String[] stringArray = lines = FileManager.readTextFile(hashFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.split("\\s+");
            int index = Integer.valueOf(items[2].trim());
            int ex = Integer.valueOf(items[3].trim());
            if (index == i + 1 && exon == ex) {
                boolean isRevComp = Boolean.valueOf(items[4].trim());
                if (isRevComp) {
                    rhashSeq.put(items[0].trim(), ParseFastaByHapType9.toList(items[1].trim()));
                } else {
                    fhashSeq.put(items[0].trim(), ParseFastaByHapType9.toList(items[1].trim()));
                }
            }
            ++n2;
        }
    }

    private static List<String> toList(String info) {
        String[] items;
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = items = info.split(",");
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.trim().length() > 0) {
                names.add(name);
            }
            ++n2;
        }
        return names;
    }

    private static void populateAlleleDropOffLog(Map<String, String> sequences, AlleleDropOffLog alleleDropOffLog, String hapName) {
        String sequence = null;
        for (String read : sequences.keySet()) {
            String name;
            String thisRead;
            sequence = sequences.get(read);
            if (hapName.startsWith("DPB1-exon2")) {
                if (sequence.indexOf(DPB1_DROP_CASE1) <= -1 && sequence.indexOf(DPB1_DROP_CASE2) <= -1 && sequence.indexOf(DPB1_DROP_CASE3) <= -1) continue;
                thisRead = ConvertFastaQdataMiSeq.generateName(read);
                name = thisRead.substring(0, thisRead.length() - 2);
                alleleDropOffLog.addNamesDPBdrop(name);
                if (sequence.indexOf(DPB1_DROP_GROUP1) > -1) {
                    alleleDropOffLog.addNamesDPBdropGroup1(name);
                }
                if (sequence.indexOf(DPB1_DROP_GROUP2) > -1) {
                    alleleDropOffLog.addNamesDPBdropGroup2(name);
                }
                if (sequence.indexOf(DPB1_DROP_GROUP1) > -1) {
                    alleleDropOffLog.addNamesDPBdropSpecial1(name);
                }
                if (sequence.indexOf(DPB1_DROP_GROUP1) <= -1) continue;
                alleleDropOffLog.addNamesDPBdropSpecial2(name);
                continue;
            }
            if (!hapName.startsWith("DRB1345-exon2") || sequence.indexOf(DRB1_07_SPECIFIC) <= -1) continue;
            thisRead = ConvertFastaQdataMiSeq.generateName(read);
            name = thisRead.substring(0, thisRead.length() - 2);
            alleleDropOffLog.addNamesDRB07(name);
            if (sequence.indexOf(DRB1_07_SPECIFIC2) <= -1 || sequence.indexOf(DRB1_07_SPECIFIC3) <= -1) continue;
            alleleDropOffLog.addNameDRB07MoreCoverage(name);
        }
        if (alleleDropOffLog.getNamesDPBdrop().size() > 25) {
            alleleDropOffLog.setDPBdropPresent(true);
            System.out.println("find DPB1 DROP off " + alleleDropOffLog.getNamesDPBdrop().size());
            System.out.println("DPB short reads group 1=" + alleleDropOffLog.getNamesDPBdropGroup1().size());
            System.out.println("DPB short reads group 2=" + alleleDropOffLog.getNamesDPBdropGroup2().size());
            System.out.println("DPB short reads special 1=" + alleleDropOffLog.getNamesDPBdropSpecial1().size());
            System.out.println("DPB short reads special 2=" + alleleDropOffLog.getNamesDPBdropSpecial2().size());
        }
        if (alleleDropOffLog.getNamesDRB07().size() > 25) {
            alleleDropOffLog.setDRB107Present(true);
            System.out.println("find DRB1 07 DROP off " + alleleDropOffLog.getNamesDRB07().size());
        }
    }

    private static File getSequenceFromFastaAndMaskPrimer(File fastaFile, Map<String, String> inputSequences, boolean isPrimerMaskOff) throws Exception {
        File tmpFile = File.createTempFile("seq", "fa");
        tmpFile.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length - 1) {
            String line = lines[i].trim();
            if (lines[i].startsWith(">")) {
                builder.append(line);
                builder.append("\n");
                builder.append(isPrimerMaskOff ? ParseFastaByHapType9.maskOffPrimerSite(18, lines[i + 1].trim()) : lines[i + 1].trim());
                builder.append("\n");
                inputSequences.put(lines[i].trim().substring(1), isPrimerMaskOff ? ParseFastaByHapType9.maskOffPrimerSite(18, lines[i + 1].trim()) : lines[i + 1].trim());
            }
            ++i;
        }
        System.out.println("input size=" + inputSequences.size());
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        return tmpFile;
    }

    private static Map<String, Map<String, OneMatch>> getCrossMatchRecords(File fastaFile, File hapFile, MatchParameters mp, AlleleDropOffLog alleleDropOffLog, List<String> DPBdropTypes, List<String> DPBdropGroup1Types, List<String> DPBdropGroup2Types, Map<String, String> inputSequences, String name, boolean isUseFastMode, Map<String, String> hapSequences) throws Exception {
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        List<File> splitedFiles = ParseFastaByHapType9.splitFile(fastaFile);
        System.out.println("split into " + splitedFiles.size());
        long startTime = System.currentTimeMillis();
        int i = 0;
        boolean fastModeReached = false;
        for (File smallFile : splitedFiles) {
            ++i;
            File matchResult = ParseFastaByHapType9.runCrossMatch(smallFile, hapFile, mp);
            Map<String, List<String>> filteredResult = ParseFastaByHapType9.filterResult(matchResult, mp, name, alleleDropOffLog, DPBdropTypes);
            System.out.println("done filteredResult... " + filteredResult.size());
            ParseFastaByHapType9.ParseResult(result, matchResult, filteredResult, alleleDropOffLog, DPBdropTypes, DPBdropGroup1Types, DPBdropGroup2Types, smallFile, inputSequences, name, hapSequences);
            matchResult.delete();
            System.out.println("done ParseResult...");
            if (isUseFastMode && !fastModeReached && ParseFastaByHapType9.enoughRecordForFastMode(result, name)) {
                fastModeReached = true;
                hapFile = ParseFastaByHapType9.createNewHapFile(result, hapFile);
            }
            if (!ParseFastaByHapType9.enoughRecord(result, name)) continue;
            mp.setReadsUsed(i * 10000 / 2);
            System.out.println("*********enough reads " + mp.getReadsUsed() + "/" + mp.getTotalReads());
            break;
        }
        if (!ParseFastaByHapType9.enoughRecord(result, name)) {
            mp.setReadsUsed(mp.getTotalReads());
        }
        for (File smallFile : splitedFiles) {
            ParseFastaByHapType9.cleanup(smallFile);
        }
        ParseFastaByHapType9.logMethodTime("Done crossmatch and parsing ...", System.currentTimeMillis() - startTime);
        return result;
    }

    private static File createNewHapFile(Map<String, Map<String, OneMatch>> result, File hapFile) throws Exception {
        File tmpFn = File.createTempFile("seq", "fasta");
        tmpFn.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        String[] lines = FileManager.readTextFile(hapFile).split("\n");
        int count = 0;
        int orgCount = 0;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                ++orgCount;
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (result.containsKey(name) && result.get(name).size() >= 5) {
                    builder.append(lines[i].trim()).append("\n");
                    builder.append(sequence).append("\n");
                    ++count;
                }
            }
            ++i;
        }
        System.out.println("trim file from " + orgCount + " to " + count);
        FileManager.writeTextFile(tmpFn, builder.toString(), true);
        return tmpFn;
    }

    private static boolean enoughRecordForFastMode(Map<String, Map<String, OneMatch>> result, String name) {
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            if (ParseFastaByHapType9.isByProduct(type)) continue;
            int count = 0;
            for (OneMatch match : matches.values()) {
                if (!match.isForwardExist() || !match.isReverseExist() || ParseFastaByHapType9.isBridgingReads(match)) continue;
                ++count;
            }
            if (count <= ParseFastaByHapType9.getFastaModeReadsRequired(name)) continue;
            return true;
        }
        return false;
    }

    private static int getFastaModeReadsRequired(String name) {
        return 50;
    }

    private static boolean enoughRecord(Map<String, Map<String, OneMatch>> result, String name) {
        if (name.indexOf(EXON23) > -1) {
            boolean exon2Enough = false;
            boolean exon3Enough = false;
            for (String type : result.keySet()) {
                Map<String, OneMatch> matches = result.get(type);
                if (ParseFastaByHapType9.isByProduct(type)) continue;
                int count2 = 0;
                int count3 = 0;
                for (OneMatch match : matches.values()) {
                    if (!match.isForwardExist() || !match.isReverseExist() || ParseFastaByHapType9.isBridgingReads(match)) continue;
                    if (ParseFastaByHapType9.isExon2Reads(match)) {
                        ++count2;
                        continue;
                    }
                    ++count3;
                }
                if (count2 > 500) {
                    exon2Enough = true;
                }
                if (count3 > 500) {
                    exon3Enough = true;
                }
                if (!exon2Enough || !exon3Enough) continue;
                return true;
            }
        } else {
            for (String type : result.keySet()) {
                Map<String, OneMatch> matches = result.get(type);
                if (ParseFastaByHapType9.isByProduct(type)) continue;
                int count = 0;
                for (OneMatch match : matches.values()) {
                    if (!match.isForwardExist() || !match.isReverseExist() || ParseFastaByHapType9.isBridgingReads(match)) continue;
                    ++count;
                }
                if (count <= ParseFastaByHapType9.getGoodReadsRequired(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static int getGoodReadsRequired(String name) {
        if (name.indexOf(EXON23) > -1) {
            return 1000;
        }
        return 500;
    }

    private static boolean isByProduct(String type) {
        if (type.indexOf("sudo") > -1) {
            return true;
        }
        return type.startsWith("H");
    }

    private static List<File> splitFile(File fastaFile) {
        ArrayList<File> splitedFiles = new ArrayList<File>();
        String namePrefix = String.valueOf(fastaFile.getName()) + "sp";
        String cmd = "split -l 10000 " + fastaFile.getAbsolutePath() + " " + namePrefix;
        String[] commandArray2 = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray2, fastaFile.getParentFile(), true);
        command.makeItSo();
        Object[] files = fastaFile.getParentFile().listFiles();
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).getName().startsWith(String.valueOf(namePrefix) + "a")) {
                splitedFiles.add((File)file);
            }
            ++n2;
        }
        return splitedFiles;
    }

    private static String maskOffPrimerSite(int primerSize, String originalSeq) {
        String nString = "";
        int i = 0;
        while (i < primerSize) {
            nString = String.valueOf(nString) + "N";
            ++i;
        }
        return String.valueOf(nString) + originalSeq.substring(primerSize);
    }

    protected static void logMethodTime(String message, long time) {
        Calendar deltaCalendar = Calendar.getInstance();
        deltaCalendar.setTimeInMillis(time);
        deltaCalendar.add(10, -4);
        System.out.println(String.valueOf(message) + deltaCalendar.get(10) + ":" + deltaCalendar.get(12) + ":" + deltaCalendar.get(13));
    }

    private static void gatherDPB1DropTypes(Map<String, String> sequences, List<String> DPBdropTypes, List<String> DPBdropGroup1Types, List<String> DPBdropGroup2Types) {
        for (String name : sequences.keySet()) {
            String seq = sequences.get(name);
            if (seq.indexOf(DPB1_DROP_CASE1) > -1 || seq.indexOf(DPB1_DROP_CASE2) > -1 || seq.indexOf(DPB1_DROP_CASE3) > -1) {
                DPBdropTypes.add(name);
            }
            if (seq.indexOf(DPB1_DROP_GROUP1) > -1) {
                DPBdropGroup1Types.add(name);
                continue;
            }
            if (seq.indexOf(DPB1_DROP_GROUP2) <= -1) continue;
            DPBdropGroup2Types.add(name);
        }
    }

    private static Map<String, List<String>> filterResult(File matchResult, MatchParameters mp, String name, AlleleDropOffLog alleleDropOffLog, List<String> DPBdropTypes) throws Exception {
        HashMap<String, Map<String, Integer>> readsMap = new HashMap<String, Map<String, Integer>>();
        HashMap<String, Map<String, String>> readsStrandMap = new HashMap<String, Map<String, String>>();
        BufferedReader indexReader = new BufferedReader(new FileReader(matchResult));
        try {
            String line;
            int lineCount = 0;
            while ((line = indexReader.readLine()) != null) {
                String[] items;
                ++lineCount;
                if (line.indexOf(LABEL) <= 0 || line.trim().split("\\s+").length < 12 || !ParseFastaByHapType9.misMatchBelowThreshHold(Double.valueOf((items = line.trim().split("\\s+"))[1]), Double.valueOf(items[2]), Double.valueOf(items[3]), mp.getMismatchAllowed(), name)) continue;
                ParseFastaByHapType9.updateReadMap(readsMap, items, readsStrandMap, name);
            }
        }
        finally {
            indexReader.close();
        }
        HashMap<String, List<String>> readsMatches = new HashMap<String, List<String>>();
        for (String readName : readsMap.keySet()) {
            readsMatches.put(readName, ParseFastaByHapType9.getBestMatchingTypes(readName, (Map)readsMap.get(readName), (Map)readsStrandMap.get(readName), alleleDropOffLog, DPBdropTypes));
        }
        return readsMatches;
    }

    private static List<String> getBestMatchingTypes(String name, Map<String, Integer> allMap, Map<String, String> strandMap, AlleleDropOffLog alleleDropOffLog, List<String> DPBdropTypes) {
        HashMap mapByScore = new HashMap();
        for (String type : allMap.keySet()) {
            if (!mapByScore.containsKey(allMap.get(type))) {
                mapByScore.put(allMap.get(type), new ArrayList());
            }
            ((List)mapByScore.get(allMap.get(type))).add(type);
        }
        ArrayList<String> results = new ArrayList<String>();
        Object[] num = mapByScore.keySet().toArray();
        Arrays.sort(num);
        List types = (List)mapByScore.get(num[num.length - 1]);
        for (String type : types) {
            if (strandMap.get(type).equals("A")) {
                results.add(type);
                continue;
            }
            if (alleleDropOffLog.isDPBdropPresent() && DPBdropTypes.contains(type)) {
                results.add(type);
                continue;
            }
            if (!alleleDropOffLog.isDRB107Present() || type.indexOf("DRB1*07") <= -1) continue;
            results.add(type);
        }
        return results;
    }

    public static String generateName(String line) {
        String[] items1 = line.split(":");
        String name = String.valueOf(items1[0]) + "-" + items1[items1.length - 2] + "-" + items1[items1.length - 1];
        return name;
    }

    private static void updateReadMap(Map<String, Map<String, Integer>> readsMap, String[] items, Map<String, Map<String, String>> readsStrandMap, String locus) {
        String name = items[4].trim().substring(0, items[4].trim().length() - 2);
        boolean isRevComp = items[8].trim().equals("C");
        String type = isRevComp ? items[9].trim() : items[8].trim();
        Integer score = Integer.valueOf(items[0].trim());
        if (!readsMap.containsKey(name)) {
            readsMap.put(name, new HashMap());
            readsStrandMap.put(name, new HashMap());
        }
        if (!readsMap.get(name).containsKey(type)) {
            readsMap.get(name).put(type, 0);
        }
        int newScore = readsMap.get(name).get(type) + score;
        String newStrandCount = null;
        if (readsStrandMap.get(name).get(type) == null) {
            newStrandCount = isRevComp ? "R" : "F";
        } else if (readsStrandMap.get(name).get(type).equals("F") && isRevComp) {
            newStrandCount = "A";
        } else if (readsStrandMap.get(name).get(type).equals("R") && !isRevComp) {
            newStrandCount = "A";
        } else {
            newStrandCount = readsStrandMap.get(name).get(type);
            if (score > readsMap.get(name).get(type)) {
                newScore = score;
            }
        }
        readsMap.get(name).put(type, newScore);
        readsStrandMap.get(name).put(type, newStrandCount);
    }

    public static File organizeFastaByHap(Map<String, String> hapAmbNames, File fastaFile, List<String> filteredRulesSet) throws Exception {
        File tmpFn = File.createTempFile("seq", "fasta");
        tmpFn.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        ArrayList<String> existAmbTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (!hapAmbNames.containsKey(name)) {
                    if (filteredRulesSet.size() <= 0 || filteredRulesSet.contains(name)) {
                        builder.append(lines[i].trim()).append("\n");
                        builder.append(sequence).append("\n");
                    }
                } else {
                    String gname = hapAmbNames.get(name);
                    if ((filteredRulesSet.size() <= 0 || filteredRulesSet.contains(gname)) && !existAmbTypes.contains(gname)) {
                        builder.append(">").append(gname).append("\n");
                        builder.append(sequence).append("\n");
                        existAmbTypes.add(gname);
                    }
                }
            }
            ++i;
        }
        FileManager.writeTextFile(tmpFn, builder.toString(), true);
        return tmpFn;
    }

    public static void populateHapAmbNames(Map<String, String> hapNames, File hapAmbFile) {
        String[] lines;
        String[] stringArray = lines = FileManager.readTextFile(hapAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    hapNames.put(items[i].trim(), gname);
                    ++i;
                }
            }
            ++n2;
        }
    }

    private static boolean output(Map<String, Map<String, OneMatch>> result, File hapFile, int roundNum, StringBuilder builder, int exonSize, File outputImage, StringBuilder resultSummary, String locus, String sample, Map<String, String> inputSequences, Map<String, String> sequences, MatchParameters mp, AlleleDropOffLog alleleDropOffLog) throws Exception {
        HashMap orgnizedTypes = new HashMap();
        HashMap<String, ArrayList<OneMatch>> effectiveMatchesByType = new HashMap<String, ArrayList<OneMatch>>();
        HashMap<String, MatchStatistics> matchStatisticsList = new HashMap<String, MatchStatistics>();
        for (String type : result.keySet()) {
            int firmPosCount;
            System.out.println("------Type=" + type);
            Map<String, OneMatch> matches = result.get(type);
            ArrayList<OneMatch> effectiveMatches = new ArrayList<OneMatch>();
            int count = 0;
            int count2 = 0;
            int count3 = 0;
            int perfectCount = 0;
            int bridgeCount = 0;
            int uniqueCount = 0;
            int uniqueCount2 = 0;
            int uniqueCount3 = 0;
            for (OneMatch match : matches.values()) {
                if (roundNum == 0 && match.isForwardExist() && match.isReverseExist()) {
                    effectiveMatches.add(match);
                    ++count;
                    if (!match.isSharedMatch()) {
                        ++uniqueCount;
                    }
                    if (match.getForDiscrepencies().size() == 0 && match.getRevDiscrepencies().size() == 0) {
                        ++perfectCount;
                    }
                    if (locus.indexOf(EXON23) <= 0) continue;
                    if (ParseFastaByHapType9.isBridgingReads(match)) {
                        System.out.println("          " + match.getForwardFullName() + " " + match.getForwardTargetStart() + " " + match.getForwardTargetEnd() + " " + match.getReverseTargetStart() + " " + match.getReverseTargetEnd());
                        ++bridgeCount;
                        continue;
                    }
                    if (ParseFastaByHapType9.isExon2Reads(match)) {
                        ++count2;
                        if (match.isSharedMatch()) continue;
                        ++uniqueCount2;
                        continue;
                    }
                    ++count3;
                    if (match.isSharedMatch()) continue;
                    ++uniqueCount3;
                    continue;
                }
                if (roundNum <= 0 || !match.isForwardExist() && !match.isReverseExist()) continue;
                effectiveMatches.add(match);
                ++count;
            }
            if (count <= 0) continue;
            effectiveMatchesByType.put(type, effectiveMatches);
            matchStatisticsList.put(type, ParseFastaByHapType9.fillMatchStatistics(effectiveMatches, sequences.get(type).length(), roundNum, type, locus));
            ((MatchStatistics)matchStatisticsList.get(type)).setNumPairsSupport(count);
            ((MatchStatistics)matchStatisticsList.get(type)).setNumPairsPerfect(perfectCount);
            ((MatchStatistics)matchStatisticsList.get(type)).setNumPairsUnique(uniqueCount);
            if (locus.indexOf(EXON23) > 0) {
                ((MatchStatistics)matchStatisticsList.get(type)).setBridgeCount(bridgeCount);
                ((MatchStatistics)matchStatisticsList.get(type)).setNumPairsSupportExonA(count2);
                ((MatchStatistics)matchStatisticsList.get(type)).setNumPairsSupportExonB(count3);
                ((MatchStatistics)matchStatisticsList.get(type)).setNumPairsUniqueExonA(uniqueCount2);
                ((MatchStatistics)matchStatisticsList.get(type)).setNumPairsUniqueExonB(uniqueCount3);
            }
            if (!orgnizedTypes.containsKey(firmPosCount = ((MatchStatistics)matchStatisticsList.get(type)).getNumPosGoodCoverage())) {
                orgnizedTypes.put(firmPosCount, new ArrayList());
            }
            ((List)orgnizedTypes.get(firmPosCount)).add(type);
        }
        List<String> outputTypes = ParseFastaByHapType9.summaryResult(resultSummary, matchStatisticsList, exonSize, locus, sample, alleleDropOffLog, mp);
        resultSummary.append("usedTotaldata:" + Math.min(mp.getReadsUsed(), mp.getTotalReads()) + "/" + mp.getTotalReads() + "=" + mp.getReadsUsed() * 100 / mp.getTotalReads() + "%").append("\n");
        if (mp.isAlignType() && outputTypes.size() > 0) {
            ParseFastaByHapType9.outputAlignments(outputTypes, sequences, matchStatisticsList, locus, resultSummary);
        }
        if (mp.isDrawImage()) {
            int imageCount = 0;
            BufferedImage bufferedImage = ParseFastaByHapType9.initializeBufferedImage(exonSize);
            Graphics2D graphics2D = ParseFastaByHapType9.initializeGraphics2D(bufferedImage);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString("Sample : " + sample, 5, 15);
            for (String t : outputTypes) {
                if (imageCount > IMAGE_TO_DRAW) break;
                ParseFastaByHapType9.drawImage(t, (MatchStatistics)matchStatisticsList.get(t), (List)effectiveMatchesByType.get(t), 0, sequences.get(t).length(), bufferedImage, graphics2D, imageCount, inputSequences, sequences, mp);
                ++imageCount;
            }
            ParseFastaByHapType9.writeImageToFile(bufferedImage, outputImage);
        }
        Object[] num = orgnizedTypes.keySet().toArray();
        Arrays.sort(num);
        int outputCount = 0;
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            if (outputCount >= 20 || ((List)orgnizedTypes.get(c)).size() > 20) break;
            for (String t : (List)orgnizedTypes.get(c)) {
                String info;
                if (((MatchStatistics)matchStatisticsList.get(t)).getNumPairsSupport() < 10) continue;
                if (roundNum == 0) {
                    info = String.valueOf(t) + "\t" + ((MatchStatistics)matchStatisticsList.get(t)).getNumPairsSupport() + "\t" + ((MatchStatistics)matchStatisticsList.get(t)).getNumPairsPerfect();
                    builder.append(info);
                    builder.append(ParseFastaByHapType9.getStatistics((MatchStatistics)matchStatisticsList.get(t)));
                    builder.append("\t").append(outputCount + 1);
                    builder.append("\n");
                    ++outputCount;
                    continue;
                }
                info = String.valueOf(t) + "\t" + c;
                builder.append(info);
                builder.append(ParseFastaByHapType9.getStatistics((MatchStatistics)matchStatisticsList.get(t)));
                builder.append("\t").append(outputCount + 1);
                builder.append("\n");
                ++outputCount;
            }
            --i;
        }
        return false;
    }

    private static boolean isBridgingReads(OneMatch match) {
        return match.isForwardExist() && match.isReverseExist() && (match.getForwardTargetStart() + match.getForwardTargetEnd()) / 2 < 270 && (match.getReverseTargetStart() + match.getReverseTargetEnd()) / 2 > 270;
    }

    private static boolean isExon2Reads(OneMatch match) {
        return match.isForwardExist() && match.isReverseExist() && (match.getForwardTargetStart() + match.getForwardTargetEnd()) / 2 < 270 && (match.getReverseTargetStart() + match.getReverseTargetEnd()) / 2 < 270;
    }

    private static void drawImage(String hap, MatchStatistics matchStatistics, List<OneMatch> list, int rountNum, int exonSize, BufferedImage bufferedImage, Graphics2D graphics2D, int imageCount, Map<String, String> inputSequences, Map<String, String> sequences, MatchParameters mp) {
        String label = " Support Reads Pairs =" + matchStatistics.getNumPairsSupport();
        label = String.valueOf(label) + ", #pos with >= 8x coverage =" + matchStatistics.getNumPosGoodCoverage() + " ";
        label = String.valueOf(label) + ", pos with >50% mismatch =" + matchStatistics.formatQuestionPostion(matchStatistics.getQuestionPos()) + " ";
        label = String.valueOf(label) + ", number of pairs unique for this type =" + matchStatistics.getNumPairsUnique();
        ParseFastaByHapType9.drawSequence(matchStatistics.getPosCount(), exonSize, imageCount, bufferedImage, graphics2D, hap);
        ParseFastaByHapType9.drawDeepth(matchStatistics.getPosCount(), exonSize, imageCount, bufferedImage, graphics2D, label);
        ParseFastaByHapType9.drawAmplicons(list, exonSize, imageCount, bufferedImage, graphics2D, inputSequences, sequences.get(hap), mp);
    }

    private static void outputAlignments(List<String> outputTypes, Map<String, String> sequences, Map<String, MatchStatistics> matchStatisticsList, String locus, StringBuilder resultSummary) throws Exception {
        resultSummary.append("\n");
        String anchorName = null;
        String anchor = null;
        Iterator<String> iterator = sequences.keySet().iterator();
        if (iterator.hasNext()) {
            String name;
            anchorName = name = iterator.next();
            anchor = sequences.get(name);
        }
        if (ParseFastaByHapType9.isAllSameSize(anchor, sequences, outputTypes)) {
            ParseFastaByHapType9.outputForSameLength(outputTypes, sequences, matchStatisticsList, locus, resultSummary);
        } else {
            ParseFastaByHapType9.outputForDiffLength(outputTypes, sequences, matchStatisticsList, locus, resultSummary);
        }
    }

    private static void outputForDiffLength(List<String> outputTypes, Map<String, String> sequences, Map<String, MatchStatistics> matchStatisticsList, String locus, StringBuilder resultSummary) throws Exception {
        String matchRecord = ParseFastaByHapType9.getCrossMatchResult(outputTypes, sequences);
        String anchorName = null;
        String anchor = null;
        Iterator<String> iterator = sequences.keySet().iterator();
        if (iterator.hasNext()) {
            String name;
            anchorName = name = iterator.next();
            anchor = sequences.get(name);
        }
        Map<String, OneMatch> matches = ParseFastaByHapType9.parseMatchRecord(anchorName, matchRecord);
        LinkedHashMap<Integer, Integer> insertionMap = new LinkedHashMap<Integer, Integer>();
        for (String type : matches.keySet()) {
            List<Discrepancy> discrepancis = matches.get(type).getForDiscrepencies();
            for (Discrepancy dis : discrepancis) {
                if (dis.getType() != 'I') continue;
                insertionMap.put(dis.getTargetPosition(), dis.getCount());
            }
            if (matches.get(type).getForwardTargetStart() >= matches.get(type).getForwardStart()) continue;
            insertionMap.put(matches.get(type).getForwardTargetStart(), matches.get(type).getForwardStart() - matches.get(type).getForwardTargetStart());
        }
        String paddedAnchor = ParseFastaByHapType9.padAnchorSeq(anchor, insertionMap);
        resultSummary.append(anchorName).append("\t").append(paddedAnchor).append("\n");
        LinkedHashMap<String, String> padSeqMap = new LinkedHashMap<String, String>();
        for (String type : outputTypes) {
            String seq = sequences.get(type);
            String alignedSeq = ParseFastaByHapType9.padTypeSeq(anchor, seq, insertionMap, matches.get(type));
            resultSummary.append(type).append("\t");
            resultSummary.append(alignedSeq);
            resultSummary.append("\n");
            padSeqMap.put(type, alignedSeq);
        }
        for (String type : outputTypes) {
            int padCount = 0;
            MatchStatistics stats = matchStatisticsList.get(type);
            resultSummary.append(type).append("\t");
            int i = 0;
            while (i < ((String)padSeqMap.get(type)).length()) {
                if (i - padCount >= stats.getPosCount().size()) break;
                if (((String)padSeqMap.get(type)).charAt(i) == '.') {
                    resultSummary.append(".");
                    ++padCount;
                } else if (stats.getPosCount().get(i + 1 - padCount) >= COVERAGE_CUTOFF) {
                    int coverage = stats.getPosCount().get(i + 1 - padCount) / COVERAGE_CUTOFF;
                    resultSummary.append(Math.min(coverage, 9));
                } else {
                    resultSummary.append("0");
                }
                ++i;
            }
            resultSummary.append("\n");
        }
    }

    private static String padTypeSeq(String anchor, String typeSeq, Map<Integer, Integer> insertionMap, OneMatch match) {
        List<Discrepancy> discrepancis = match.getForDiscrepencies();
        StringBuilder seq = new StringBuilder();
        int deletionCount = 0;
        int insertionCount = 0;
        int i = 0;
        while (i < anchor.length()) {
            int j;
            if (insertionMap.containsKey(i + 1)) {
                if (ParseFastaByHapType9.isInDiscrepancyList(discrepancis, i + 1, match)) {
                    int j2 = 0;
                    while (j2 < insertionMap.get(i + 1)) {
                        if (i + j2 - deletionCount + insertionCount < typeSeq.length()) {
                            seq.append(typeSeq.charAt(i + j2 - deletionCount + insertionCount));
                        }
                        insertionCount += insertionMap.get(i + 1).intValue();
                        ++j2;
                    }
                    if (i - deletionCount + insertionCount < typeSeq.length()) {
                        if (typeSeq.charAt(i - deletionCount + insertionCount) == anchor.charAt(i)) {
                            seq.append("-");
                        } else {
                            seq.append(typeSeq.charAt(i - deletionCount + insertionCount));
                        }
                    }
                } else {
                    Discrepancy dis = ParseFastaByHapType9.getThisDeletion(discrepancis, i + 1);
                    j = 0;
                    while (j < insertionMap.get(i + 1)) {
                        seq.append(".");
                        ++j;
                    }
                    if (dis != null) {
                        j = 0;
                        while (j < dis.getCount()) {
                            seq.append(".");
                            ++j;
                        }
                        i += dis.getCount() - 1;
                        deletionCount += dis.getCount();
                    } else if (i - deletionCount + insertionCount < typeSeq.length()) {
                        if (typeSeq.charAt(i - deletionCount + insertionCount) == anchor.charAt(i)) {
                            seq.append("-");
                        } else {
                            seq.append(typeSeq.charAt(i - deletionCount + insertionCount));
                        }
                    }
                }
            } else {
                Discrepancy dis = ParseFastaByHapType9.getThisDeletion(discrepancis, i + 1);
                if (dis == null) {
                    if (i - deletionCount + insertionCount >= typeSeq.length()) {
                        seq.append(".");
                    } else if (typeSeq.charAt(i - deletionCount + insertionCount) == anchor.charAt(i)) {
                        seq.append("-");
                    } else {
                        seq.append(typeSeq.charAt(i - deletionCount + insertionCount));
                    }
                } else {
                    j = 0;
                    while (j < dis.getCount()) {
                        seq.append(".");
                        ++j;
                    }
                    i += dis.getCount() - 1;
                    deletionCount += dis.getCount();
                }
            }
            ++i;
        }
        return seq.toString();
    }

    private static boolean isDeletion(List<Discrepancy> discrepancis, int i) {
        for (Discrepancy discrepancy : discrepancis) {
            if (discrepancy.getTargetPosition() != i || discrepancy.getType() != 'D') continue;
            return true;
        }
        return false;
    }

    private static Discrepancy getThisDeletion(List<Discrepancy> discrepancis, int i) {
        for (Discrepancy discrepancy : discrepancis) {
            if (discrepancy.getTargetPosition() != i || discrepancy.getType() != 'D') continue;
            return discrepancy;
        }
        return null;
    }

    private static boolean isInDiscrepancyList(List<Discrepancy> discrepancis, int i, OneMatch match) {
        if (match.getForwardTargetStart() < match.getForwardStart() && match.getForwardTargetStart() == i) {
            return true;
        }
        for (Discrepancy discrepancy : discrepancis) {
            if (discrepancy.getTargetPosition() != i || discrepancy.getType() != 'I') continue;
            return true;
        }
        return false;
    }

    private static String padAnchorSeq(String anchor, Map<Integer, Integer> insertionMap) {
        StringBuilder seq = new StringBuilder();
        int i = 0;
        while (i < anchor.length()) {
            if (insertionMap.containsKey(i + 1)) {
                int j = 0;
                while (j < insertionMap.get(i + 1)) {
                    seq.append(".");
                    ++j;
                }
            }
            seq.append(anchor.charAt(i));
            ++i;
        }
        return seq.toString();
    }

    private static String getCrossMatchResult(List<String> outputTypes, Map<String, String> sequences) throws Exception {
        String anchorName = null;
        String anchor = null;
        Iterator<String> iterator = sequences.keySet().iterator();
        if (iterator.hasNext()) {
            String name;
            anchorName = name = iterator.next();
            anchor = sequences.get(name);
        }
        StringBuilder seqBuilder = new StringBuilder();
        seqBuilder.append(">").append(anchorName).append("\n");
        seqBuilder.append(anchor);
        File targetSeq = File.createTempFile("seq", "txt");
        FileManager.writeTextFile(targetSeq, seqBuilder.toString(), true);
        StringBuilder queryBuilder = new StringBuilder();
        for (String type : outputTypes) {
            queryBuilder.append(">").append(type).append("\n");
            queryBuilder.append(sequences.get(type));
        }
        File querySeq = File.createTempFile("seq", "txt");
        querySeq.deleteOnExit();
        FileManager.writeTextFile(querySeq, queryBuilder.toString(), true);
        String matchRecord = ParseFastaByHapType9.runCrossMatchForBackbones(querySeq, targetSeq);
        targetSeq.delete();
        querySeq.delete();
        return matchRecord;
    }

    private static Map<String, OneMatch> parseMatchRecord(String anchorName, String matchRecord) {
        LinkedHashMap<String, OneMatch> matches = new LinkedHashMap<String, OneMatch>();
        String[] lines = matchRecord.split("\n");
        int lineCount = 0;
        boolean startRecord = false;
        OneMatch aMatch = null;
        String fullName = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ++lineCount;
            if (line.indexOf(anchorName) > 0 && line.trim().split("\\s+").length >= 12) {
                String[] items = line.trim().split("\\s+");
                startRecord = true;
                fullName = items[4].trim();
                aMatch = new OneMatch();
                aMatch.setForwardExist(true);
                aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
                aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
                aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
                aMatch.setForwardFullName(fullName);
                aMatch.setForwardStart(Integer.valueOf(items[5].trim()));
                aMatch.setForwardEnd(Integer.valueOf(items[6].trim()));
                if (aMatch.getForwardStart() < aMatch.getForwardTargetStart()) {
                    Discrepancy dis = new Discrepancy('D', aMatch.getForwardTargetStart() - aMatch.getForwardStart(), aMatch.getForwardStart(), " ", 20, aMatch.getForwardTargetStart() - (aMatch.getForwardTargetStart() - aMatch.getForwardStart()), " ");
                    aMatch.addForDiscrepencies(dis);
                }
                matches.put(fullName, aMatch);
            } else if (startRecord && line.trim().split("\\s+").length == 5) {
                ParseFastaByHapType9.populateDiscrepency((OneMatch)matches.get(fullName), line, fullName);
            }
            ++n2;
        }
        return matches;
    }

    private static String runCrossMatchForBackbones(File queryFile, File anchorFile) throws Exception {
        String cmd = "/genome/bin/cross_match -discrep_lists " + queryFile.getAbsolutePath() + " " + anchorFile.getAbsolutePath();
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, true);
        System.out.println("running cross_match...");
        command.makeItSo();
        System.out.println("done cross_match...");
        return command.getStandardOut();
    }

    private static boolean isAllSameSize(String anchor, Map<String, String> sequences, List<String> outputTypes) {
        for (String type : outputTypes) {
            String seq = sequences.get(type);
            if (seq.length() == anchor.length()) continue;
            return false;
        }
        return true;
    }

    private static void outputForSameLength(List<String> outputTypes, Map<String, String> sequences, Map<String, MatchStatistics> matchStatisticsList, String locus, StringBuilder resultSummary) {
        resultSummary.append("\n");
        String anchorName = null;
        String anchor = null;
        Iterator<String> iterator = sequences.keySet().iterator();
        if (iterator.hasNext()) {
            String name;
            anchorName = name = iterator.next();
            anchor = sequences.get(name);
        }
        resultSummary.append(anchorName).append("\t").append(anchor).append("\n");
        for (String type : outputTypes) {
            String seq = sequences.get(type);
            resultSummary.append(type).append("\t");
            int i = 0;
            while (i < anchor.length()) {
                if (i >= seq.length()) break;
                if (seq.charAt(i) == anchor.charAt(i)) {
                    resultSummary.append("-");
                } else {
                    resultSummary.append(seq.charAt(i));
                }
                ++i;
            }
            resultSummary.append("\n");
        }
        for (String type : outputTypes) {
            StringBuilder builder = new StringBuilder();
            MatchStatistics stats = matchStatisticsList.get(type);
            resultSummary.append(type).append("\t");
            int i = 0;
            while (i < anchor.length()) {
                if (i >= stats.getPosCount().size()) break;
                if (stats.getPosCount().get(i + 1) >= COVERAGE_CUTOFF) {
                    int coverage = stats.getPosCount().get(i + 1) / COVERAGE_CUTOFF;
                    resultSummary.append(Math.min(coverage, 9));
                } else {
                    resultSummary.append("0");
                }
                builder.append(stats.getPosCount().get(i + 1)).append(",");
                ++i;
            }
            resultSummary.append("\n");
        }
    }

    public static boolean isSpecialDQA1exon2Type(String type) {
        return type.indexOf("DQA1*01") < 0 && type.indexOf("DQA1*03") < 0;
    }

    private static boolean misMatchBelowThreshHold(double sub, double ins, double del, double cutoff, String name) {
        double threshold = cutoff;
        return !(sub + ins + del > threshold);
    }

    private static List<String> summaryResult(StringBuilder resultSummary, Map<String, MatchStatistics> matchStatisticsList, int exonSize, String locus, String sample, AlleleDropOffLog alleleDropOffLog, MatchParameters mp) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap orgnizedByExonCoverageTypes = new HashMap();
        for (String type : matchStatisticsList.keySet()) {
            MatchStatistics matchStatistics = matchStatisticsList.get(type);
            if (!orgnizedByExonCoverageTypes.containsKey(matchStatistics.getExonSize() - matchStatistics.getNumPosGoodCoverage())) {
                orgnizedByExonCoverageTypes.put(matchStatistics.getExonSize() - matchStatistics.getNumPosGoodCoverage(), new ArrayList());
            }
            ((List)orgnizedByExonCoverageTypes.get(matchStatistics.getExonSize() - matchStatistics.getNumPosGoodCoverage())).add(type);
        }
        int count = 0;
        Object[] num = orgnizedByExonCoverageTypes.keySet().toArray();
        Arrays.sort(num);
        int i = 0;
        while (i < num.length) {
            int c = (Integer)num[i];
            if (c == exonSize || (result.size() >= IMAGE_TO_DRAW && c != 0 || (double)c > 0.15 * (double)exonSize) && result.size() > 0 && ParseFastaByHapType9.resultContainsLocus(result)) break;
            HashMap orgnizedByAmpliconSizeTypes = new HashMap();
            for (String t : (List)orgnizedByExonCoverageTypes.get(c)) {
                int keyNumber = matchStatisticsList.get(t).getNumPairsSupport();
                if (locus.indexOf(EXON23) > -1) {
                    keyNumber = Math.min(matchStatisticsList.get(t).getNumPairsSupportExonA(), matchStatisticsList.get(t).getNumPairsSupportExonB());
                }
                if (!orgnizedByAmpliconSizeTypes.containsKey(keyNumber)) {
                    orgnizedByAmpliconSizeTypes.put(keyNumber, new ArrayList());
                }
                ((List)orgnizedByAmpliconSizeTypes.get(keyNumber)).add(t);
            }
            Object[] num3 = orgnizedByAmpliconSizeTypes.keySet().toArray();
            Arrays.sort(num3);
            int j = num3.length - 1;
            while (j >= 0) {
                int z = (Integer)num3[j];
                HashMap detailedOrderedTypes = new HashMap();
                for (String tt : (List)orgnizedByAmpliconSizeTypes.get(z)) {
                    int numOrder = matchStatisticsList.get(tt).getQuestionPos().size() * -1;
                    if (locus.indexOf(EXON23) > -1) {
                        numOrder = matchStatisticsList.get(tt).getNumPairsSupportExonA() + matchStatisticsList.get(tt).getNumPairsSupportExonB();
                    }
                    if (!detailedOrderedTypes.containsKey(numOrder)) {
                        detailedOrderedTypes.put(numOrder, new ArrayList());
                    }
                    ((List)detailedOrderedTypes.get(numOrder)).add(tt);
                }
                Object[] num4 = detailedOrderedTypes.keySet().toArray();
                Arrays.sort(num4);
                int x = num4.length - 1;
                while (x >= 0) {
                    int y = (Integer)num4[x];
                    for (String ttt : (List)detailedOrderedTypes.get(y)) {
                        if (alleleDropOffLog.isDRB107Present() && ttt.indexOf("DRB1*07") > -1) {
                            resultSummary.append(sample).append("\t").append(locus).append("\t").append(ttt).append("\t").append(matchStatisticsList.get(ttt).format()).append("\t").append(count + 1).append("\t").append("dropOff=").append(alleleDropOffLog.getNamesDRB07().size() * (mp.getReadsUsed() * 100 / mp.getTotalReads()) / 100).append("\n");
                        } else {
                            resultSummary.append(sample).append("\t").append(locus).append("\t").append(ttt).append("\t").append(matchStatisticsList.get(ttt).format()).append("\t").append(count + 1).append("\n");
                        }
                        result.add(ttt);
                        ++count;
                    }
                    --x;
                }
                --j;
            }
            ++i;
        }
        if (alleleDropOffLog.isDRB107Present()) {
            boolean findDropOffType = false;
            for (String type : result) {
                if (type.indexOf("DRB1*07") <= -1) continue;
                findDropOffType = true;
                break;
            }
            if (!findDropOffType) {
                int u = 0;
                while (u < num.length) {
                    int c = (Integer)num[u];
                    if (c == exonSize) break;
                    boolean isFind = false;
                    HashMap orgnizedByAmpliconSizeTypes = new HashMap();
                    for (String t : (List)orgnizedByExonCoverageTypes.get(c)) {
                        if (!orgnizedByAmpliconSizeTypes.containsKey(matchStatisticsList.get(t).getNumPairsSupport())) {
                            orgnizedByAmpliconSizeTypes.put(matchStatisticsList.get(t).getNumPairsSupport(), new ArrayList());
                        }
                        ((List)orgnizedByAmpliconSizeTypes.get(matchStatisticsList.get(t).getNumPairsSupport())).add(t);
                    }
                    Object[] num3 = orgnizedByAmpliconSizeTypes.keySet().toArray();
                    Arrays.sort(num3);
                    int j = num3.length - 1;
                    while (j >= 0) {
                        int z = (Integer)num3[j];
                        for (String tt : (List)orgnizedByAmpliconSizeTypes.get(z)) {
                            if (tt.indexOf("DRB1*07") <= -1) continue;
                            System.out.println("force " + tt + " into result!!!" + alleleDropOffLog.getNamesDRB07().size());
                            resultSummary.append(sample).append("\t").append(locus).append("\t").append(tt).append("\t").append(matchStatisticsList.get(tt).format()).append("\t").append(count + 1).append("\t").append("dropOff=").append(alleleDropOffLog.getNamesDRB07().size() * (mp.getReadsUsed() * 100 / mp.getTotalReads()) / 100).append("\n");
                            result.add(tt);
                            isFind = true;
                        }
                        if (isFind) break;
                        --j;
                    }
                    if (isFind) break;
                    ++u;
                }
            }
        }
        if (result.size() == 0) {
            resultSummary.append(sample).append("\t").append(locus).append("\t").append("No Result").append("\n");
        }
        return result;
    }

    private static boolean resultContainsLocus(List<String> result) {
        for (String t : result) {
            if (t.startsWith("DRB3") || t.startsWith("DRB4") || t.startsWith("DRB5")) continue;
            return true;
        }
        return false;
    }

    private static MatchStatistics fillMatchStatistics(List<OneMatch> list, int exonSize, int rountNum, String type, String locus) {
        MatchStatistics matchStatistics = new MatchStatistics();
        int totalSize = 0;
        int totalCount = 0;
        int pairsWithCompleteCoverage = 0;
        Map<Integer, Integer> posCount = ParseFastaByHapType9.initMap(exonSize);
        HashMap<Integer, Integer> misMatchPosCount = new HashMap<Integer, Integer>();
        for (OneMatch match : list) {
            int fstart = match.getForwardTargetStart();
            int fend = match.getForwardTargetEnd();
            int rstart = match.getReverseTargetStart();
            int rend = match.getReverseTargetEnd();
            if (locus.indexOf(EXON23) > 0 && !ParseFastaByHapType9.specialType(type, locus)) {
                if (fstart < 250 && fend > 270) {
                    fend = 270;
                } else if (rend > 290 && rstart <= 270) {
                    rstart = 271;
                }
            }
            if (fstart > match.getReverseTargetStart()) {
                fstart = match.getReverseTargetStart();
                fend = match.getReverseTargetEnd();
                rstart = match.getForwardTargetStart();
                rend = match.getForwardTargetEnd();
            }
            int size = 0;
            if (rountNum == 0) {
                if (fend >= rstart) {
                    size = Math.max(rend, fend) - fstart + 1;
                    ParseFastaByHapType9.addToPosCount(posCount, fstart, Math.max(rend, fend));
                    if (fstart == 1 && rend == exonSize) {
                        ++pairsWithCompleteCoverage;
                    }
                } else {
                    size = fend - fstart + 1 + (rend - rstart + 1);
                    ParseFastaByHapType9.addToPosCount(posCount, fstart, fend);
                    ParseFastaByHapType9.addToPosCount(posCount, rstart, rend);
                }
                ParseFastaByHapType9.addInDiscrepenies(match.getForDiscrepencies(), posCount, misMatchPosCount);
                ParseFastaByHapType9.addInDiscrepenies(match.getRevDiscrepencies(), posCount, misMatchPosCount);
                match.setCoverageSize(size);
                totalSize += size;
                ++totalCount;
                continue;
            }
            int thisSize = 0;
            if (match.isForwardExist()) {
                size = fend - fstart + 1;
                ParseFastaByHapType9.addToPosCount(posCount, fstart, fend);
                totalSize += size;
                thisSize += size;
                ++totalCount;
            }
            if (match.isReverseExist()) {
                size = rend - rstart + 1;
                ParseFastaByHapType9.addToPosCount(posCount, rstart, rend);
                totalSize += size;
                thisSize += size;
                ++totalCount;
            }
            match.setCoverageSize(thisSize);
        }
        matchStatistics.setAverageAmpliconSize(totalSize / totalCount);
        ArrayList<Integer> firmPos = new ArrayList<Integer>();
        for (int pos : posCount.keySet()) {
            if (posCount.get(pos) < COVERAGE_CUTOFF) continue;
            firmPos.add(pos);
        }
        ArrayList<Integer> questionPos = new ArrayList<Integer>();
        Iterator iterator = misMatchPosCount.keySet().iterator();
        while (iterator.hasNext()) {
            int pos = (Integer)iterator.next();
            if ((Integer)misMatchPosCount.get(pos) <= posCount.get(pos) || posCount.get(pos) < COVERAGE_CUTOFF) continue;
            questionPos.add(pos);
        }
        matchStatistics.setMisMatchPosCount(misMatchPosCount);
        matchStatistics.setPosCount(posCount);
        matchStatistics.setQuestionPos(questionPos);
        matchStatistics.setNumPosGoodCoverage(firmPos.size());
        matchStatistics.setNumPairsCompletelyCoverExon(pairsWithCompleteCoverage);
        matchStatistics.setExonSize(exonSize);
        return matchStatistics;
    }

    private static boolean specialType(String type, String locus) {
        return type.equals("A*24:232N") || type.equals("A*23:11N") || type.equals("A*68:18N") || type.equals("A*26:25N") || type.equals("B*15:79N") || type.equals("C*08:36N") || type.equals("C*12:84N") || type.equals("C*08:89N");
    }

    public static void addInDiscrepenies(List<Discrepancy> discrepencies, Map<Integer, Integer> posCount, Map<Integer, Integer> misMatchPosCount) {
        for (Discrepancy d : discrepencies) {
            if (!posCount.containsKey(d.getTargetPosition()) || d.getQueryPosition() <= 18) continue;
            int count = posCount.get(d.getTargetPosition()) - 1;
            posCount.put(d.getTargetPosition(), count);
            if (!misMatchPosCount.containsKey(d.getTargetPosition())) {
                misMatchPosCount.put(d.getTargetPosition(), 0);
            }
            count = misMatchPosCount.get(d.getTargetPosition()) + 1;
            misMatchPosCount.put(d.getTargetPosition(), count);
        }
    }

    private static String getStatistics(MatchStatistics matchStatistics) {
        String output = "\t" + matchStatistics.getAverageAmpliconSize();
        output = String.valueOf(output) + "\t" + matchStatistics.getNumPosGoodCoverage();
        output = String.valueOf(output) + "\t" + matchStatistics.formatQuestionPostion(matchStatistics.getQuestionPos());
        output = String.valueOf(output) + "\t" + matchStatistics.getNumPairsUnique();
        return output;
    }

    public static String getSeqFromFile(String hap, Map<String, String> inputSequences) {
        return inputSequences.get(hap);
    }

    private static void drawAmplicons(List<OneMatch> alllist, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, Map<String, String> inputSequences, String hapSeq, MatchParameters mp) {
        int length = exonSize;
        Color[] colors = new Color[]{Color.DARK_GRAY, Color.LIGHT_GRAY};
        List<OneMatch> list = ParseFastaByHapType9.orgnizeMatches(alllist, exonSize);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        int index = 1;
        for (OneMatch match : list) {
            int x0;
            int x2;
            int y1;
            int x1;
            Color c = colors[index % 2];
            graphics2D.setColor(c);
            if (match.isForwardExist()) {
                x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getForwardTargetStart() - match.getForwardStart() + 1)).floatValue());
                y1 = yBase - 424 + index * 4;
                x2 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getForwardTargetEnd() + mp.getReadSize() - match.getForwardEnd())).floatValue());
                if (mp.isPrimerMaskOff()) {
                    x0 = x1 + Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * 18.0).floatValue());
                    graphics2D.setColor(Color.YELLOW);
                    graphics2D.drawLine(x1, y1, x0, y1);
                    graphics2D.setColor(c);
                    graphics2D.drawLine(x0, y1, x2, y1);
                } else {
                    graphics2D.drawLine(x1, y1, x2, y1);
                }
            }
            if (match.isReverseExist()) {
                x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getReverseTargetStart() - mp.getReadSize() + match.getReverseEnd())).floatValue());
                y1 = yBase - 424 + index * 4;
                x2 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getReverseTargetEnd() + match.getReverseStart() - 1)).floatValue());
                if (mp.isPrimerMaskOff()) {
                    x0 = x2 - Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * 18.0).floatValue());
                    graphics2D.setColor(c);
                    graphics2D.drawLine(x1, y1, x0, y1);
                    graphics2D.setColor(Color.YELLOW);
                    graphics2D.drawLine(x0, y1, x2, y1);
                } else {
                    graphics2D.drawLine(x1, y1, x2, y1);
                }
            }
            ParseFastaByHapType9.drawMismatchPos(yBase, exonSize, bufferedImage, match, graphics2D, index, inputSequences, hapSeq, mp);
            if (++index > 100) break;
        }
    }

    private static void drawMismatchPos(int yBase, int exonSize, BufferedImage bufferedImage, OneMatch match, Graphics2D graphics2D, int index, Map<String, String> inputSequences, String hapSeq, MatchParameters mp) {
        int y1 = yBase - 424 + index * 4;
        if (match.isForwardExist() && match.isReverseExist()) {
            int x1 = match.getForwardStart();
            int x2 = match.getForwardEnd();
            int x3 = match.getReverseStart();
            int x4 = match.getReverseEnd();
            if (x1 == x2 || x3 == x4) {
                return;
            }
            String forwardSeq = ParseFastaByHapType9.getSeqFromFile(match.getForwardFullName(), inputSequences);
            String reverseSeq = ParseFastaByHapType9.getSeqFromFile(match.getReverseFullName(), inputSequences);
            int t1 = match.getForwardTargetStart();
            int t2 = match.getForwardTargetEnd();
            int t3 = match.getReverseTargetStart();
            int t4 = match.getReverseTargetEnd();
            LinkedHashMap<Integer, String> misMatches = new LinkedHashMap<Integer, String>();
            ParseFastaByHapType9.findMismatches(misMatches, forwardSeq, hapSeq, x1, x2, t1, t2, false, mp, t3, t4);
            ParseFastaByHapType9.findMismatches(misMatches, reverseSeq, hapSeq, x3, x4, t3, t4, true, mp, t1, t2);
            ParseFastaByHapType9.addMismatches(misMatches, match.getForDiscrepencies(), false);
            ParseFastaByHapType9.addMismatches(misMatches, match.getRevDiscrepencies(), true);
            for (Integer pos : misMatches.keySet()) {
                int y = yBase - 424 + index * 4;
                int x = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(exonSize) * (double)pos.intValue()).floatValue());
                graphics2D.setColor(ParseFastaByHapType9.getBaseColor((String)misMatches.get(pos)));
                graphics2D.drawLine(x, y - 1, x, y + 1);
            }
        }
    }

    private static void addMismatches(Map<Integer, String> misMatches, List<Discrepancy> forDiscrepencies, boolean isRevComp) {
        for (Discrepancy d : forDiscrepencies) {
            if (isRevComp) {
                misMatches.put(d.getTargetPosition(), StringUtils.revCompSeq(d.getQueryBase()));
                continue;
            }
            misMatches.put(d.getTargetPosition(), d.getQueryBase());
        }
    }

    private static boolean isInMatchRegion(Integer pos, OneMatch match) {
        int t1 = match.getForwardTargetStart();
        int t2 = match.getForwardTargetEnd();
        int t3 = match.getReverseTargetStart();
        int t4 = match.getReverseTargetEnd();
        if (pos > t1 && pos < t2) {
            return true;
        }
        return pos > t3 && pos < t4;
    }

    private static Color getBaseColor(String base) {
        if (base.equals("A")) {
            return Color.GREEN;
        }
        if (base.equals("T")) {
            return Color.RED;
        }
        if (base.equals("C")) {
            return Color.BLUE;
        }
        if (base.equals("G")) {
            return Color.ORANGE;
        }
        return Color.LIGHT_GRAY;
    }

    private static void findMismatches(Map<Integer, String> misMatches, String seq, String hapSeq, int x1, int x2, int t1, int t2, boolean isReverseComp, MatchParameters mp, int t3, int t4) {
        if (!isReverseComp) {
            char h;
            int targetIndex;
            char s;
            int i = 0;
            while (i < x1 - 1) {
                s = seq.charAt(i);
                targetIndex = t1 - x1 + i;
                if (targetIndex >= 0 && s != (h = hapSeq.charAt(targetIndex)) && s != 'N' && h != 'N' && ParseFastaByHapType9.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
            i = x2;
            while (i < mp.getReadSize()) {
                s = seq.charAt(i);
                targetIndex = t2 + (i - x2);
                if (targetIndex <= hapSeq.length() - 1 && s != (h = hapSeq.charAt(targetIndex)) && s != 'N' && h != 'N' && ParseFastaByHapType9.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
        } else {
            char h;
            int targetIndex;
            char s;
            int i = 0;
            while (i < x1 - 1) {
                s = StringUtils.revCompSeq(String.valueOf(seq.charAt(i))).charAt(0);
                targetIndex = t2 + (x1 - i) - 2;
                if (targetIndex <= hapSeq.length() - 1 && s != (h = hapSeq.charAt(targetIndex)) && s != 'N' && h != 'N' && ParseFastaByHapType9.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
            i = x2;
            while (i < mp.getReadSize()) {
                s = StringUtils.revCompSeq(String.valueOf(seq.charAt(i))).charAt(0);
                targetIndex = t1 - (i - x2) - 2;
                if (targetIndex >= 0 && s != (h = hapSeq.charAt(targetIndex)) && s != 'N' && h != 'N' && ParseFastaByHapType9.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
        }
    }

    private static boolean outsideOtherStrandsMatchRegion(int targetIndex, int t3, int t4) {
        return targetIndex < t3 - 1 || targetIndex > t4 - 1;
    }

    private static List<OneMatch> orgnizeMatches(List<OneMatch> list, int exonSize) {
        HashMap sortedMatches = new HashMap();
        ArrayList<OneMatch> sortedList = new ArrayList<OneMatch>();
        int count = 0;
        for (OneMatch match : list) {
            int size = match.getCoverageSize();
            if (!sortedMatches.containsKey(size)) {
                sortedMatches.put(size, new ArrayList());
            }
            ((List)sortedMatches.get(size)).add(match);
            if (++count > 100) break;
        }
        Object[] num = sortedMatches.keySet().toArray();
        Arrays.sort(num);
        int i = num.length - 1;
        while (i >= 0) {
            sortedList.addAll((Collection)sortedMatches.get(num[i]));
            --i;
        }
        return sortedList;
    }

    public static void drawDeepth(Map<Integer, Integer> posCount, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, String output) {
        int length = exonSize;
        int countMax = ParseFastaByHapType9.getCountMax(posCount);
        double depthUnit = 0.0;
        depthUnit = (double)countMax > 50.0 ? new Double(400.0) / new Double((double)countMax * 1.5) : new Double(400.0) / new Double(75.0);
        graphics2D.setColor(Color.LIGHT_GRAY);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        for (int pos : posCount.keySet()) {
            int x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)pos).floatValue());
            int y1 = yBase - 450 - 10;
            int y2 = Math.round(new Float(depthUnit * (double)posCount.get(pos).intValue()).floatValue());
            graphics2D.drawLine(x1, y1 - y2, x1, y1);
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(" coverage max=" + countMax, 1, yBase - 650);
        graphics2D.drawString(output, 1, yBase - 650 + 10);
    }

    public static int getCountMax(Map<Integer, Integer> posCount) {
        int max = 0;
        for (Integer count : posCount.values()) {
            if (count <= max) continue;
            max = count;
        }
        return max;
    }

    public static void addToPosCount(Map<Integer, Integer> posCount, int start, int end) {
        int i = start;
        while (i < end + 1) {
            if (posCount.get(i) != null) {
                int count = posCount.get(i) + 1;
                posCount.put(i, count);
            }
            ++i;
        }
    }

    public static Map<Integer, Integer> initMap(int exonSize) {
        LinkedHashMap<Integer, Integer> posCount = new LinkedHashMap<Integer, Integer>();
        int i = 1;
        while (i < exonSize + 1) {
            posCount.put(i, 0);
            ++i;
        }
        return posCount;
    }

    private static Object getName(String t, Map<String, String> types) {
        for (String name : types.keySet()) {
            if (!types.get(name).equals(t)) continue;
            return name;
        }
        return null;
    }

    private static Map<String, String> getAllTypes(File hapFile) {
        String[] lines;
        HashMap<String, String> types = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(hapFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(">")) {
                String[] items = line.substring(1).trim().split("\\s+");
                if (items.length == 1) {
                    types.put(items[0], items[0]);
                } else {
                    types.put(items[0], items[1]);
                }
            }
            ++n2;
        }
        return types;
    }

    private static void ParseResult(Map<String, Map<String, OneMatch>> result, File matchResult, Map<String, List<String>> filteredResult, AlleleDropOffLog alleleDropOffLog, List<String> DPBdropTypes, List<String> DPBdropGroup1Types, List<String> DPBdropGroup2Types, File fastaFile, Map<String, String> inputSequences, String locus, Map<String, String> hapSequences) throws Exception {
        String[] lines = FileManager.readTextFile(matchResult).split("\n");
        int lineCount = 0;
        boolean startRecord = false;
        OneMatch aMatch = null;
        String fullName = null;
        boolean isRevComp = false;
        String type = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ++lineCount;
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                String[] items = line.trim().split("\\s+");
                if (ParseFastaByHapType9.isInFilteredResult(filteredResult, items)) {
                    startRecord = true;
                    fullName = items[4].trim();
                    isRevComp = items[8].trim().equals("C");
                    type = isRevComp ? items[9].trim() : items[8].trim();
                    boolean isUnique = ParseFastaByHapType9.isUniqueMatch(filteredResult, items);
                    aMatch = ParseFastaByHapType9.populateAmatch(fastaFile, result, alleleDropOffLog, DPBdropTypes, DPBdropGroup1Types, DPBdropGroup2Types, line, inputSequences, isUnique, locus, hapSequences);
                } else {
                    startRecord = false;
                    aMatch = null;
                    fullName = null;
                    type = null;
                    isRevComp = false;
                }
            } else if (startRecord && line.trim().split("\\s+").length == 5) {
                ParseFastaByHapType9.populateDiscrepency(aMatch, line, fullName, locus, hapSequences.get(type));
            }
            ++n2;
        }
    }

    private static boolean isUniqueMatch(Map<String, List<String>> filteredResult, String[] items) {
        String name = items[4].trim().substring(0, items[4].trim().length() - 2);
        return filteredResult.get(name).size() == 1;
    }

    private static boolean isInFilteredResult(Map<String, List<String>> filteredResult, String[] items) {
        String type;
        String name = items[4].trim().substring(0, items[4].trim().length() - 2);
        boolean isRevComp = items[8].trim().equals("C");
        String string = type = isRevComp ? items[9].trim() : items[8].trim();
        return filteredResult.containsKey(name) && filteredResult.get(name).contains(type);
    }

    private static Discrepancy generateDiscrepancy(String[] item) {
        int count = 1;
        if (item[0].trim().length() > 1) {
            count = new Integer(item[0].trim().substring(2));
        }
        String base = item[2].trim().substring(0, item[2].indexOf("("));
        int qual = new Integer(item[2].trim().substring(item[2].indexOf("(") + 1, item[2].indexOf(")")));
        Discrepancy dis = new Discrepancy(item[0].charAt(0), count, new Integer(item[1]), base, qual, new Integer(item[3]), item[4].trim());
        return dis;
    }

    private static void populateDiscrepency(OneMatch match, String line, String fullName, String locus, String hapSequence) {
        String[] items = line.trim().split("\\s+");
        if (items[0].charAt(0) != 'S' && items[0].charAt(0) != 'I' && items[0].charAt(0) != 'D') {
            return;
        }
        Discrepancy dis = ParseFastaByHapType9.generateDiscrepancy(items);
        if (locus.indexOf(EXON23) > 0) {
            ParseFastaByHapType9.resetDisTargetIndex(dis, hapSequence);
        }
        if (match.getForwardFullName() != null && match.getForwardFullName().equals(fullName)) {
            match.addForDiscrepencies(dis);
        } else if (match.getReverseFullName() != null && match.getReverseFullName().equals(fullName)) {
            match.addRevDiscrepencies(dis);
        } else {
            System.out.println("error in parsing discrep !!!!!!!!!!!!");
        }
    }

    private static void resetDisTargetIndex(Discrepancy dis, String hapSeq) {
        int index = hapSeq.indexOf(EXON_SEPERATOR);
        if (index < 0) {
            return;
        }
        if (dis.getTargetPosition() > index) {
            dis.setTargetPosition(dis.getTargetPosition() - EXON_SEPERATOR.length());
        }
    }

    private static void populateDiscrepency(OneMatch match, String line, String fullName) {
        String[] items = line.trim().split("\\s+");
        if (items[0].charAt(0) != 'S' && items[0].charAt(0) != 'I' && items[0].charAt(0) != 'D') {
            return;
        }
        Discrepancy dis = ParseFastaByHapType9.generateDiscrepancy(items);
        if (match.getForwardFullName() != null && match.getForwardFullName().equals(fullName)) {
            match.addForDiscrepencies(dis);
        } else if (match.getReverseFullName() != null && match.getReverseFullName().equals(fullName)) {
            match.addRevDiscrepencies(dis);
        } else {
            System.out.println("error in parsing discrep !!!!!!!!!!!!");
        }
    }

    private static OneMatch populateAmatch(File fastaFile, Map<String, Map<String, OneMatch>> result, AlleleDropOffLog alleleDropOffLog, List<String> DPBdropTypes, List<String> DPBdropGroup1Types, List<String> DPBdropGroup2Types, String line, Map<String, String> inputSequences, boolean isUnique, String locus, Map<String, String> hapSequences) {
        OneMatch aMatch;
        Map<String, OneMatch> matches;
        String type;
        String[] items = line.trim().split("\\s+");
        String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
        String name = thisRead.substring(0, thisRead.length() - 2);
        String fullName = items[4].trim();
        boolean isRevComp = items[8].trim().equals("C");
        String string = type = isRevComp ? items[9].trim() : items[8].trim();
        if (!result.containsKey(type)) {
            result.put(type, new HashMap());
        }
        if (!(matches = result.get(type)).containsKey(name)) {
            aMatch = new OneMatch();
            aMatch.setName(name);
            matches.put(name, aMatch);
        }
        aMatch = matches.get(name);
        if (isUnique) {
            aMatch.setSharedMatch(false);
        } else {
            aMatch.setSharedMatch(true);
        }
        if (isRevComp) {
            String forwardSeq;
            aMatch.setReverseExist(true);
            aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
            aMatch.setReverseFullName(fullName);
            aMatch.setReverseStart(Integer.valueOf(items[5].trim()));
            aMatch.setReverseEnd(Integer.valueOf(items[6].trim()));
            aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
            aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
            if (locus.indexOf(EXON23) > 0) {
                ParseFastaByHapType9.resetTargetIndex(hapSequences.get(type), aMatch, true);
            }
            if (alleleDropOffLog.isDPBdropPresent() && alleleDropOffLog.getNamesDPBdrop().contains(name) && DPBdropTypes.contains(type) && !aMatch.isForwardExist() && (alleleDropOffLog.getNamesDPBdropGroup1().contains(name) && DPBdropGroup1Types.contains(type) || alleleDropOffLog.getNamesDPBdropGroup2().contains(name) && DPBdropGroup2Types.contains(type))) {
                aMatch.setForwardScore(30);
                aMatch.setForwardTargetStart(1);
                aMatch.setForwardTargetEnd(30);
                aMatch.setForwardExist(true);
                aMatch.setForwardFullName(String.valueOf(fullName.substring(0, fullName.length() - 1)) + (fullName.charAt(fullName.length() - 1) == '1' ? 2 : 1));
                forwardSeq = ParseFastaByHapType9.getSeqFromFile(aMatch.getForwardFullName(), inputSequences);
                aMatch.setForwardStart(forwardSeq.indexOf(DPB1_DROP_STABLE) - 12);
                aMatch.setForwardEnd(aMatch.getForwardStart() + 29);
            }
            if (alleleDropOffLog.isDRB107Present() && alleleDropOffLog.getNamesDRB07().contains(name) && type.indexOf("DRB1*07") > -1) {
                aMatch.setForwardExist(true);
                aMatch.setForwardScore(alleleDropOffLog.getNameDRB07MoreCoverage().contains(name) && !ParseFastaByHapType9.inExcludingList(type) ? 47 : 22);
                aMatch.setForwardTargetStart(1);
                aMatch.setForwardTargetEnd(alleleDropOffLog.getNameDRB07MoreCoverage().contains(name) && !ParseFastaByHapType9.inExcludingList(type) ? 47 : 22);
                aMatch.setForwardFullName(String.valueOf(fullName.substring(0, fullName.length() - 1)) + (fullName.charAt(fullName.length() - 1) == '1' ? 2 : 1));
                forwardSeq = ParseFastaByHapType9.getSeqFromFile(aMatch.getForwardFullName(), inputSequences);
                aMatch.setForwardStart(forwardSeq.indexOf(DRB1_07_SPECIFIC) - 5 + 1);
                if (aMatch.getForwardScore() == 47) {
                    aMatch.setForwardEnd(aMatch.getForwardStart() + 47 - 1);
                } else {
                    aMatch.setForwardEnd(aMatch.getForwardStart() + 22 - 1);
                }
            }
        } else {
            aMatch.setForwardExist(true);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardFullName(fullName);
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
            aMatch.setForwardStart(Integer.valueOf(items[5].trim()));
            aMatch.setForwardEnd(Integer.valueOf(items[6].trim()));
            if (locus.indexOf(EXON23) > 0) {
                ParseFastaByHapType9.resetTargetIndex(hapSequences.get(type), aMatch, false);
            }
        }
        return aMatch;
    }

    private static void resetTargetIndex(String hapSeq, OneMatch match, boolean isRevComp) {
        int index = hapSeq.indexOf(EXON_SEPERATOR);
        if (index < 0) {
            return;
        }
        if (isRevComp && match.getReverseTargetStart() > index) {
            match.setReverseTargetStart(match.getReverseTargetStart() - EXON_SEPERATOR.length());
            match.setReverseTargetEnd(match.getReverseTargetEnd() - EXON_SEPERATOR.length());
        }
        if (!isRevComp && match.getForwardTargetStart() > index) {
            match.setForwardTargetStart(match.getForwardTargetStart() - EXON_SEPERATOR.length());
            match.setForwardTargetEnd(match.getForwardTargetEnd() - EXON_SEPERATOR.length());
        }
    }

    private static boolean inExcludingList(String type) {
        int i = 0;
        while (i < DRB1_07_SPECIFIC23_EXCLUDING.length) {
            if (type.equals(DRB1_07_SPECIFIC23_EXCLUDING[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static List<String> addDRB107SpecificReads(String[] log) {
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = log;
        int n = log.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith(">")) {
                String thisRead = ConvertFastaQdataMiSeq.generateName(line.trim().substring(1));
                String name = thisRead.substring(0, thisRead.length() - 2);
                names.add(name);
            }
            ++n2;
        }
        return names;
    }

    private static List<String> addDPBdropTypes(String[] log) {
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = log;
        int n = log.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith(">")) {
                String name = line.trim().substring(1);
                names.add(name);
            }
            ++n2;
        }
        return names;
    }

    private static File runCrossMatch(File fastaFile, File hapFile, MatchParameters mp) throws Exception {
        File tmpFile = File.createTempFile("out", "txt");
        tmpFile.deleteOnExit();
        String cmd = "/genome/bin/cross_match -masklevel 101 -minmatch 60 -minscore " + mp.getMatchMinScore() + " -discrep_lists " + " -penalty " + mp.misPenalty + " " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath() + " > " + tmpFile.getAbsolutePath();
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        System.out.println("running cross_match...");
        command.makeItSo();
        System.out.println("done cross_match...");
        return tmpFile;
    }

    public static void excuteCommand(String[] cmd) {
        Object data = null;
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            proc = null;
        }
        catch (IOException ioe) {
            System.err.println("an I/O error occurs" + ioe.toString());
            System.exit(1);
        }
        catch (InterruptedException e) {
            System.err.println("Interrupted waiting for process!");
            System.exit(1);
        }
    }

    public static BufferedImage initializeBufferedImage(int exonSize) {
        BufferedImage bufferedImage = new BufferedImage(1000, 1000 * IMAGE_TO_DRAW, 9);
        return bufferedImage;
    }

    /*
     * Unable to fully structure code
     */
    public static double getUnit(int length) {
        num = length;
        i = 0;
        if (!((double)length <= 5.0)) ** GOTO lbl6
        return 1.0;
lbl-1000:
        // 1 sources

        {
            num = new Double((double)length / Math.pow(10.0, ++i));
lbl6:
            // 2 sources

            ** while (num > 10.0)
        }
lbl7:
        // 1 sources

        if (num > 5.0) {
            return Math.pow(10.0, i);
        }
        j = 1;
        while (num * (double)j * 2.0 < 5.0) {
            ++j;
        }
        return Math.pow(10.0, i) / new Double(j * 2);
    }

    public static Graphics2D initializeGraphics2D(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return graphics2D;
    }

    public static void drawSequence(Map<Integer, Integer> posCount, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, String hap) {
        int length = exonSize;
        graphics2D.setColor(Color.LIGHT_GRAY);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        graphics2D.draw3DRect(0, yBase - 450, 1000, 10, true);
        graphics2D.fill3DRect(0, yBase - 450, 1000, 10, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(1, yBase - 450, 1, bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000 - 450 + 10);
        graphics2D.drawString("1 " + hap, 1, yBase - 424);
        graphics2D.drawLine(bufferedImage.getWidth() - 1, yBase - 450, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000 - 450 + 10);
        graphics2D.drawString(new Integer(length).toString(), bufferedImage.getWidth() - new Integer(length).toString().length() * 8, yBase - 424);
        double unit = ParseFastaByHapType9.getUnit(exonSize);
        int num = new Double((double)exonSize / unit).intValue();
        int x = 0;
        String index = null;
        int i = 1;
        while (i <= num) {
            x = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * unit * (double)i).floatValue());
            index = String.valueOf(new Double(unit * (double)i).intValue());
            graphics2D.drawLine(x, yBase - 450, x, yBase - 450 + 10);
            if (i < num || i == num && (double)length - unit * (double)num >= unit / 2.0) {
                graphics2D.drawString(index, x, yBase - 424);
            }
            ++i;
        }
    }

    public static void writeImageToFile(BufferedImage bufferedImage, File imageFile) {
        FileImageOutputStream fileImageOutputStream = null;
        ImageWriter imageWriter = null;
        try {
            try {
                fileImageOutputStream = new FileImageOutputStream(imageFile);
                imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
                imageWriter.setOutput(fileImageOutputStream);
                imageWriter.write(bufferedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fileImageOutputStream != null) {
                    try {
                        fileImageOutputStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
            }
        }
        finally {
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }
}

