/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.MatchStatistics;
import fileOperation.OneMatch;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import misc.FileManager;
import misc.OsHelper;
import misc.SystemCommand;

public class ParseFastaByHapType3 {
    private static final int MIN_HIT = 10;
    static int MIN_SCORE = 80;
    static String LABEL = "A0NBFADXX";
    static String HAP_AMB_TXT = "-hap-amb.txt";
    static int COVERAGE_CUTOFF = 8;
    static int IMAGE_TO_DRAW = 10;
    private static final int IMAGE_HEIGHT = 1000;
    private static final int IMAGE_SEQUENCE_POSITION = 450;
    private static final int IMAGE_WIDTH = 1000;
    private static final int IMAGE_SEQUENCE_BAR_HEIGHT = 10;
    private static final int INDEX_SPACE = 16;
    private static final int INDEX_POSITION = 424;
    private static final int LETTER_WIDTH = 8;
    private static final int DEEPTH_HEIGHT = 400;
    private static final int LABEL_POSITION = 650;
    private static final int AMPLICON_TO_DRAW = 100;
    private static final int AMPLICON_HEIGHT = 400;
    private static String DRB1_07_SPECIFIC = "TTCCTGTGGCAGGG";
    private static final int COUNT_CUTOFF = 25;
    private static final int DRB1_07_STABLE_SIZE = 22;
    private static String DRB1_07_SPECIFIC2 = "AAGTATAAGTGTCATTT";
    private static String DRB1_07_SPECIFIC3 = "TTCAACGGG";
    private static final int DRB1_07_STABLE_SIZE_EXTENSION = 47;
    private static final String[] DRB1_07_SPECIFIC23_EXCLUDING = new String[]{"DRB1*07:22", "DRB1*07:01:02", "DRB1*07:21"};
    private static final int MIN_NUM_PAIRS_OUTPUT = 5;
    private static final int MIN_PAIRS_COMPLETE_COVERAGE_COUNT = 5;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File hapTypeRoot = new File(args[1]);
        File outputFile = new File(args[2]);
        File outputImageDir = new File(args[3]);
        String name = new String(args[4]);
        StringBuilder result = new StringBuilder();
        ParseFastaByHapType3.startType(fastaFile, hapTypeRoot, outputFile, outputImageDir, name, result);
        System.out.println(result.toString());
    }

    public static void startType(File fastaFile, File hapTypeRoot, File outputFile, File outputImageDir, String name, StringBuilder resultSummary) throws Exception {
        File[] hapFiles;
        StringBuilder builder = new StringBuilder();
        File[] fileArray = hapFiles = hapTypeRoot.listFiles();
        int n = hapFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File hapFile = fileArray[n2];
            if (hapFile.getName().endsWith("fa")) {
                List<String> filteredResult;
                Map<String, Map<String, OneMatch>> result;
                boolean needMoreTyping;
                boolean isDRB107Present = false;
                String[] log1 = null;
                String[] log2 = null;
                if (hapFile.getName().startsWith("DRB1")) {
                    String cmd = "grep -o \"" + DRB1_07_SPECIFIC + "\" " + fastaFile.getAbsolutePath() + " | wc -w";
                    String[] commandArray = new String[]{"bash", "-c", cmd};
                    SystemCommand command = new SystemCommand(commandArray, null, true);
                    command.makeItSo();
                    int count = Integer.valueOf(command.getStandardOut().trim());
                    if (count > 25) {
                        System.out.println("find DRB1*07 " + count);
                        isDRB107Present = true;
                        cmd = "grep -R -B1 \"" + DRB1_07_SPECIFIC + "\" " + fastaFile.getAbsolutePath();
                        String[] commandArray2 = new String[]{"bash", "-c", cmd};
                        command = new SystemCommand(commandArray2, null, true);
                        command.makeItSo();
                        log1 = command.getStandardOut().trim().split("\n");
                        cmd = "grep -R -B1 \"" + DRB1_07_SPECIFIC + "\" " + fastaFile.getAbsolutePath() + " | grep -R -B1 \"" + DRB1_07_SPECIFIC2 + "\"" + " | grep -R -B1 \"" + DRB1_07_SPECIFIC3 + "\"";
                        String[] commandArray3 = new String[]{"bash", "-c", cmd};
                        command = new SystemCommand(commandArray3, null, true);
                        command.makeItSo();
                        log2 = command.getStandardOut().trim().split("\n");
                    }
                }
                File hapAmbFile = new File(hapTypeRoot, String.valueOf(hapFile.getName().substring(0, hapFile.getName().length() - 3)) + HAP_AMB_TXT);
                HashMap<String, String> hapNames = new HashMap<String, String>();
                if (hapAmbFile.exists()) {
                    System.out.println("parse hap amb file " + hapAmbFile.getName());
                    ParseFastaByHapType3.populateHapAmbNames(hapNames, hapAmbFile);
                }
                builder.append("\n---------").append(hapFile.getName());
                resultSummary.append("\n");
                File tmpFile = ParseFastaByHapType3.organizeFastaByHap(hapNames, hapFile, builder);
                int exonSize = FileManager.readTextFile(tmpFile).split("\n")[1].trim().length();
                builder.append(" exon size=").append(exonSize).append("\n");
                builder.append("Hap Type\t").append("#Pairs Perfect Match\t").append("Average Amplicon Size\t").append("#Positions w >=8x Coverage\t").append("#Pairs Completely Cover Exon\n");
                File outputImage = new File(outputImageDir, String.valueOf(name) + "-" + hapFile.getName().split("\\.")[0] + ".jpg");
                String matchResult = ParseFastaByHapType3.runCrossMatch(fastaFile, tmpFile);
                if (hapFile.getName().startsWith("kir")) {
                    Map<String, Map<String, OneMatch>> map = ParseFastaByHapType3.ParseKirResult(matchResult);
                }
                if (needMoreTyping = ParseFastaByHapType3.output(result = ParseFastaByHapType3.ParseResult(filteredResult = ParseFastaByHapType3.filterResult(matchResult), isDRB107Present, log1, log2), hapFile, 0, builder, exonSize, outputImage, resultSummary, hapFile.getName(), name)) {
                    builder.append("******* further typing based on single direction match \n");
                    ParseFastaByHapType3.output(result, hapFile, 1, builder, exonSize, outputImage, resultSummary, hapFile.getName(), name);
                }
            }
            ++n2;
        }
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    private static List<String> filterResult(String matchResult) {
        ArrayList<String> results = new ArrayList<String>();
        LinkedHashMap groupedMap = new LinkedHashMap();
        String[] lines = matchResult.split("\n");
        HashMap result = new HashMap();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12 && (items = line.trim().split("\\s+"))[1].equals("0.00") && items[2].equals("0.00") && items[3].equals("0.00")) {
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                if (!groupedMap.containsKey(thisRead)) {
                    groupedMap.put(thisRead, new HashMap());
                }
                Integer score = Integer.valueOf(items[0].trim());
                if (!((Map)groupedMap.get(thisRead)).containsKey(score)) {
                    ((Map)groupedMap.get(thisRead)).put(score, new ArrayList());
                }
                ((List)((Map)groupedMap.get(thisRead)).get(score)).add(line.trim());
            }
            ++n2;
        }
        for (String read : groupedMap.keySet()) {
            Map scoreMap = (Map)groupedMap.get(read);
            Object[] num = scoreMap.keySet().toArray();
            Arrays.sort(num);
            results.addAll((Collection)scoreMap.get(num[num.length - 1]));
        }
        return results;
    }

    private static File organizeFastaByHap(Map<String, String> hapAmbNames, File fastaFile, StringBuilder log) throws Exception {
        File tmpFn = File.createTempFile("seq", "fasta");
        StringBuilder builder = new StringBuilder();
        ArrayList<String> existAmbTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (!hapAmbNames.containsKey(name)) {
                    builder.append(lines[i].trim()).append("\n");
                    builder.append(sequence).append("\n");
                } else {
                    String gname = hapAmbNames.get(name);
                    if (!existAmbTypes.contains(gname)) {
                        builder.append(">").append(gname).append("\n");
                        builder.append(sequence).append("\n");
                        existAmbTypes.add(gname);
                    }
                }
            }
            ++i;
        }
        FileManager.writeTextFile(tmpFn, builder.toString(), true);
        return tmpFn;
    }

    private static void populateHapAmbNames(Map<String, String> hapNames, File hapAmbFile) {
        String[] lines;
        String[] stringArray = lines = FileManager.readTextFile(hapAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    hapNames.put(items[i].trim(), gname);
                    ++i;
                }
            }
            ++n2;
        }
    }

    private static boolean output(Map<String, Map<String, OneMatch>> result, File hapFile, int roundNum, StringBuilder builder, int exonSize, File outputImage, StringBuilder resultSummary, String locus, String sample) {
        HashMap orgnizedTypes = new HashMap();
        HashMap<String, ArrayList<OneMatch>> effectiveMatchesByType = new HashMap<String, ArrayList<OneMatch>>();
        HashMap<String, MatchStatistics> matchStatisticsList = new HashMap<String, MatchStatistics>();
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            ArrayList<OneMatch> effectiveMatches = new ArrayList<OneMatch>();
            int count = 0;
            for (OneMatch match : matches.values()) {
                if (roundNum == 0 && match.isForwardExist() && match.isReverseExist()) {
                    effectiveMatches.add(match);
                    ++count;
                    continue;
                }
                if (roundNum <= 0 || !match.isForwardExist() && !match.isReverseExist()) continue;
                effectiveMatches.add(match);
                ++count;
            }
            if (count <= 0) continue;
            effectiveMatchesByType.put(type, effectiveMatches);
            matchStatisticsList.put(type, ParseFastaByHapType3.fillMatchStatistics(effectiveMatches, exonSize, roundNum));
            ((MatchStatistics)matchStatisticsList.get(type)).setNumPairsPerfect(count);
            if (!orgnizedTypes.containsKey(count)) {
                orgnizedTypes.put(count, new ArrayList());
            }
            ((List)orgnizedTypes.get(count)).add(type);
        }
        ParseFastaByHapType3.summaryResult(resultSummary, matchStatisticsList, exonSize, locus, sample);
        BufferedImage bufferedImage = ParseFastaByHapType3.initializeBufferedImage(exonSize);
        Graphics2D graphics2D = ParseFastaByHapType3.initializeGraphics2D(bufferedImage);
        Object[] num = orgnizedTypes.keySet().toArray();
        Arrays.sort(num);
        int imageCount = 0;
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            if (c > 5) {
                for (String t : (List)orgnizedTypes.get(c)) {
                    String info;
                    if (roundNum == 0) {
                        info = String.valueOf(t) + "\t" + c;
                        builder.append(info);
                        builder.append(ParseFastaByHapType3.getStatistics(t, (MatchStatistics)matchStatisticsList.get(t), (List)effectiveMatchesByType.get(t), 0, exonSize, bufferedImage, graphics2D, imageCount, (Integer)num[num.length - 1]));
                        builder.append("\n");
                        ++imageCount;
                        continue;
                    }
                    info = String.valueOf(t) + "\t" + c;
                    builder.append(info);
                    builder.append(ParseFastaByHapType3.getStatistics(t, (MatchStatistics)matchStatisticsList.get(t), (List)effectiveMatchesByType.get(t), 1, exonSize, bufferedImage, graphics2D, imageCount, (Integer)num[num.length - 1]));
                    builder.append("\n");
                    ++imageCount;
                }
            }
            --i;
        }
        ParseFastaByHapType3.writeImageToFile(bufferedImage, outputImage);
        return num.length == 0 || (Integer)num[num.length - 1] < 10;
    }

    private static void summaryResult(StringBuilder resultSummary, Map<String, MatchStatistics> matchStatisticsList, int exonSize, String locus, String sample) {
        int c;
        HashMap orgnizedByPairCompleteCoverTypes = new HashMap();
        HashMap orgnizedByExonCoverageTypes = new HashMap();
        ArrayList<String> types = new ArrayList<String>();
        for (String type : matchStatisticsList.keySet()) {
            MatchStatistics matchStatistics = matchStatisticsList.get(type);
            if (!orgnizedByPairCompleteCoverTypes.containsKey(matchStatistics.getNumPairsCompletelyCoverExon())) {
                orgnizedByPairCompleteCoverTypes.put(matchStatistics.getNumPairsCompletelyCoverExon(), new ArrayList());
            }
            ((List)orgnizedByPairCompleteCoverTypes.get(matchStatistics.getNumPairsCompletelyCoverExon())).add(type);
            if (!orgnizedByExonCoverageTypes.containsKey(matchStatistics.getNumPosGoodCoverage())) {
                orgnizedByExonCoverageTypes.put(matchStatistics.getNumPosGoodCoverage(), new ArrayList());
            }
            ((List)orgnizedByExonCoverageTypes.get(matchStatistics.getNumPosGoodCoverage())).add(type);
        }
        int count = 0;
        Object[] num = orgnizedByPairCompleteCoverTypes.keySet().toArray();
        Arrays.sort(num);
        int i = num.length - 1;
        while (i >= 0) {
            c = (Integer)num[i];
            if (c < 5) break;
            for (String t : (List)orgnizedByPairCompleteCoverTypes.get(c)) {
                resultSummary.append(sample).append("\t").append(locus).append("\t").append(t).append("\t").append(matchStatisticsList.get(t).format()).append("\n");
                types.add(t);
                if (t.startsWith("DRB3") || t.startsWith("DRB4") || t.startsWith("DRB5")) continue;
                ++count;
            }
            --i;
        }
        num = orgnizedByExonCoverageTypes.keySet().toArray();
        Arrays.sort(num);
        i = num.length - 1;
        while (i >= 0) {
            c = (Integer)num[i];
            if (c != exonSize && count >= 2 || (double)c < 0.3 * (double)exonSize) break;
            HashMap orgnizedByAmpliconSizeTypes = new HashMap();
            for (String t : (List)orgnizedByExonCoverageTypes.get(c)) {
                if (types.contains(t)) continue;
                if (!orgnizedByAmpliconSizeTypes.containsKey(matchStatisticsList.get(t).getAverageAmpliconSize())) {
                    orgnizedByAmpliconSizeTypes.put(matchStatisticsList.get(t).getAverageAmpliconSize(), new ArrayList());
                }
                ((List)orgnizedByAmpliconSizeTypes.get(matchStatisticsList.get(t).getAverageAmpliconSize())).add(t);
            }
            Object[] num3 = orgnizedByAmpliconSizeTypes.keySet().toArray();
            Arrays.sort(num3);
            int j = num3.length - 1;
            while (j >= 0) {
                int z = (Integer)num3[j];
                for (String tt : (List)orgnizedByAmpliconSizeTypes.get(z)) {
                    resultSummary.append(sample).append("\t").append(locus).append("\t").append(tt).append("\t").append(matchStatisticsList.get(tt).format()).append("\n");
                    types.add(tt);
                    ++count;
                }
                --j;
            }
            --i;
        }
    }

    private static MatchStatistics fillMatchStatistics(List<OneMatch> list, int exonSize, int rountNum) {
        MatchStatistics matchStatistics = new MatchStatistics();
        int totalSize = 0;
        int totalCount = 0;
        int pairsWithCompleteCoverage = 0;
        Map<Integer, Integer> posCount = ParseFastaByHapType3.initMap(exonSize);
        for (OneMatch match : list) {
            int fstart = match.getForwardTargetStart();
            int fend = match.getForwardTargetEnd();
            int rstart = match.getReverseTargetStart();
            int rend = match.getReverseTargetEnd();
            int size = 0;
            if (rountNum == 0) {
                if (fend >= rstart) {
                    size = rend - fstart + 1;
                    ParseFastaByHapType3.addToPosCount(posCount, fstart, rend);
                    if (fstart == 1 && rend == exonSize) {
                        ++pairsWithCompleteCoverage;
                    }
                } else {
                    size = fend - fstart + 1 + (rend - rstart + 1);
                    ParseFastaByHapType3.addToPosCount(posCount, fstart, fend);
                    ParseFastaByHapType3.addToPosCount(posCount, rstart, rend);
                }
                match.setCoverageSize(size);
                totalSize += size;
                ++totalCount;
                continue;
            }
            int thisSize = 0;
            if (match.isForwardExist()) {
                size = fend - fstart + 1;
                ParseFastaByHapType3.addToPosCount(posCount, fstart, fend);
                totalSize += size;
                thisSize += size;
                ++totalCount;
            }
            if (match.isReverseExist()) {
                size = rend - rstart + 1;
                ParseFastaByHapType3.addToPosCount(posCount, rstart, rend);
                totalSize += size;
                thisSize += size;
                ++totalCount;
            }
            match.setCoverageSize(thisSize);
        }
        matchStatistics.setAverageAmpliconSize(totalSize / totalCount);
        ArrayList<Integer> firmPos = new ArrayList<Integer>();
        for (int pos : posCount.keySet()) {
            if (posCount.get(pos) < COVERAGE_CUTOFF) continue;
            firmPos.add(pos);
        }
        matchStatistics.setPosCount(posCount);
        matchStatistics.setNumPosGoodCoverage(firmPos.size());
        matchStatistics.setNumPairsCompletelyCoverExon(pairsWithCompleteCoverage);
        matchStatistics.setExonSize(exonSize);
        return matchStatistics;
    }

    private static String getStatistics(String hap, MatchStatistics matchStatistics, List<OneMatch> list, int rountNum, int exonSize, BufferedImage bufferedImage, Graphics2D graphics2D, int imageCount, int scale) {
        String output = "\t" + matchStatistics.getAverageAmpliconSize();
        String label = " average match size =" + matchStatistics.getAverageAmpliconSize();
        output = String.valueOf(output) + "\t" + matchStatistics.getNumPosGoodCoverage();
        label = String.valueOf(label) + ", positions with over 8x coverage =" + matchStatistics.getNumPosGoodCoverage() + " ";
        output = String.valueOf(output) + "\t" + matchStatistics.getNumPairsCompletelyCoverExon();
        label = String.valueOf(label) + ", number of pairs complete covered exon =" + matchStatistics.getNumPairsCompletelyCoverExon();
        if (imageCount < IMAGE_TO_DRAW) {
            ParseFastaByHapType3.drawSequence(matchStatistics.getPosCount(), exonSize, imageCount, bufferedImage, graphics2D, hap);
            ParseFastaByHapType3.drawDeepth(matchStatistics.getPosCount(), exonSize, imageCount, bufferedImage, graphics2D, scale, label);
            ParseFastaByHapType3.drawAmplicons(list, exonSize, imageCount, bufferedImage, graphics2D);
        }
        return output;
    }

    private static void drawAmplicons(List<OneMatch> alllist, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D) {
        int length = exonSize;
        Color[] colors = new Color[]{Color.RED, Color.BLUE};
        List<OneMatch> list = ParseFastaByHapType3.orgnizeMatches(alllist, exonSize);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        int index = 1;
        for (OneMatch match : list) {
            int x2;
            int y1;
            int x1;
            graphics2D.setColor(colors[index % 2]);
            if (match.isForwardExist()) {
                x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)match.getForwardTargetStart()).floatValue());
                y1 = yBase - 424 + index * 4;
                x2 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)match.getForwardTargetEnd()).floatValue());
                graphics2D.drawLine(x1, y1, x2, y1);
            }
            if (match.isReverseExist()) {
                x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)match.getReverseTargetStart()).floatValue());
                y1 = yBase - 424 + index * 4;
                x2 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)match.getReverseTargetEnd()).floatValue());
                graphics2D.drawLine(x1, y1, x2, y1);
            }
            if (++index > 100) break;
        }
    }

    private static List<OneMatch> orgnizeMatches(List<OneMatch> list, int exonSize) {
        HashMap sortedMatches = new HashMap();
        ArrayList<OneMatch> sortedList = new ArrayList<OneMatch>();
        int count = 0;
        for (OneMatch match : list) {
            int size = match.getCoverageSize();
            if (!sortedMatches.containsKey(size)) {
                sortedMatches.put(size, new ArrayList());
            }
            ((List)sortedMatches.get(size)).add(match);
            if (++count > 100) break;
        }
        Object[] num = sortedMatches.keySet().toArray();
        Arrays.sort(num);
        int i = num.length - 1;
        while (i >= 0) {
            sortedList.addAll((Collection)sortedMatches.get(num[i]));
            --i;
        }
        return sortedList;
    }

    private static void drawDeepth(Map<Integer, Integer> posCount, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, int scale, String output) {
        int length = exonSize;
        int countMax = ParseFastaByHapType3.getCountMax(posCount);
        graphics2D.setColor(Color.LIGHT_GRAY);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        for (int pos : posCount.keySet()) {
            int x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)pos).floatValue());
            int y1 = yBase - 450 - 10;
            int y2 = Math.round(new Float(new Double(400.0) / new Double((double)scale * 1.5) * (double)posCount.get(pos).intValue()).floatValue());
            graphics2D.drawLine(x1, y1 - y2, x1, y1);
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(" coverage max=" + countMax, 1, yBase - 650);
        graphics2D.drawString(output, 1, yBase - 650 + 10);
    }

    private static int getCountMax(Map<Integer, Integer> posCount) {
        int max = 0;
        for (Integer count : posCount.values()) {
            if (count <= max) continue;
            max = count;
        }
        return max;
    }

    private static void addToPosCount(Map<Integer, Integer> posCount, int start, int end) {
        int i = start;
        while (i < end + 1) {
            if (posCount.get(i) != null) {
                int count = posCount.get(i) + 1;
                posCount.put(i, count);
            }
            ++i;
        }
    }

    private static Map<Integer, Integer> initMap(int exonSize) {
        LinkedHashMap<Integer, Integer> posCount = new LinkedHashMap<Integer, Integer>();
        int i = 1;
        while (i < exonSize + 1) {
            posCount.put(i, 0);
            ++i;
        }
        return posCount;
    }

    private static Object getName(String t, Map<String, String> types) {
        for (String name : types.keySet()) {
            if (!types.get(name).equals(t)) continue;
            return name;
        }
        return null;
    }

    private static Map<String, String> getAllTypes(File hapFile) {
        String[] lines;
        HashMap<String, String> types = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(hapFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(">")) {
                String[] items = line.substring(1).trim().split("\\s+");
                if (items.length == 1) {
                    types.put(items[0], items[0]);
                } else {
                    types.put(items[0], items[1]);
                }
            }
            ++n2;
        }
        return types;
    }

    private static Map<String, Map<String, OneMatch>> ParseKirResult(String matchResult) {
        String[] lines = matchResult.split("\n");
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12 && Integer.valueOf((items = line.trim().split("\\s+"))[0]) > 50) {
                OneMatch aMatch;
                Map matches;
                String type;
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                String name = thisRead.substring(0, thisRead.length() - 2);
                boolean isRevComp = items[8].trim().equals("C");
                String string = type = isRevComp ? items[9].trim() : items[8].trim();
                if (!result.containsKey(type)) {
                    result.put(type, new HashMap());
                }
                if (!(matches = (Map)result.get(type)).containsKey(name)) {
                    aMatch = new OneMatch();
                    aMatch.setName(name);
                    matches.put(name, aMatch);
                }
                aMatch = (OneMatch)matches.get(name);
                if (isRevComp) {
                    aMatch.setReverseExist(true);
                    aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                } else {
                    aMatch.setForwardExist(true);
                    aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
                }
            }
            ++n2;
        }
        return result;
    }

    private static Map<String, Map<String, OneMatch>> ParseResult(List<String> filteredResult, boolean isDRB107Present, String[] log1, String[] log2) {
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        List<String> names07 = null;
        List<String> name07MoreCoverage = null;
        if (isDRB107Present) {
            names07 = ParseFastaByHapType3.addDRB107SpecificReads(log1);
            System.out.println("total " + names07.size());
            name07MoreCoverage = ParseFastaByHapType3.addDRB107SpecificReads(log2);
        }
        for (String line : filteredResult) {
            OneMatch aMatch;
            Map matches;
            String type;
            String[] items;
            if (line.indexOf(LABEL) <= 0 || line.trim().split("\\s+").length < 12 || !(items = line.trim().split("\\s+"))[1].equals("0.00") || !items[2].equals("0.00") || !items[3].equals("0.00")) continue;
            String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
            String name = thisRead.substring(0, thisRead.length() - 2);
            boolean isRevComp = items[8].trim().equals("C");
            String string = type = isRevComp ? items[9].trim() : items[8].trim();
            if (!result.containsKey(type)) {
                result.put(type, new HashMap());
            }
            if (!(matches = (Map)result.get(type)).containsKey(name)) {
                aMatch = new OneMatch();
                aMatch.setName(name);
                matches.put(name, aMatch);
            }
            aMatch = (OneMatch)matches.get(name);
            if (isRevComp) {
                aMatch.setReverseExist(true);
                aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
                aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
                if (!isDRB107Present || !names07.contains(name)) continue;
                aMatch.setForwardExist(true);
                aMatch.setForwardScore(name07MoreCoverage.contains(name) && !ParseFastaByHapType3.inExcludingList(type) ? 47 : 22);
                aMatch.setForwardTargetStart(1);
                aMatch.setForwardTargetEnd(name07MoreCoverage.contains(name) && !ParseFastaByHapType3.inExcludingList(type) ? 47 : 22);
                continue;
            }
            aMatch.setForwardExist(true);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
        }
        return result;
    }

    private static boolean inExcludingList(String type) {
        int i = 0;
        while (i < DRB1_07_SPECIFIC23_EXCLUDING.length) {
            if (type.equals(DRB1_07_SPECIFIC23_EXCLUDING[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static List<String> addDRB107SpecificReads(String[] log) {
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = log;
        int n = log.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith(">")) {
                String thisRead = ConvertFastaQdataMiSeq.generateName(line.trim().substring(1));
                String name = thisRead.substring(0, thisRead.length() - 2);
                names.add(name);
            }
            ++n2;
        }
        return names;
    }

    private static String runCrossMatch(File fastaFile, File hapFile) {
        String cmd = "/genome/bin/cross_match -masklevel 101 -minmatch 60 -minscore " + MIN_SCORE + " " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath();
        String data = OsHelper.excuteCommand(cmd);
        return data;
    }

    private static BufferedImage initializeBufferedImage(int exonSize) {
        BufferedImage bufferedImage = new BufferedImage(1000, 1000 * IMAGE_TO_DRAW, 9);
        return bufferedImage;
    }

    /*
     * Unable to fully structure code
     */
    private static double getUnit(int length) {
        num = length;
        i = 0;
        if (!((double)length <= 5.0)) ** GOTO lbl6
        return 1.0;
lbl-1000:
        // 1 sources

        {
            num = new Double((double)length / Math.pow(10.0, ++i));
lbl6:
            // 2 sources

            ** while (num > 10.0)
        }
lbl7:
        // 1 sources

        if (num > 5.0) {
            return Math.pow(10.0, i);
        }
        j = 1;
        while (num * (double)j * 2.0 < 5.0) {
            ++j;
        }
        return Math.pow(10.0, i) / new Double(j * 2);
    }

    private static Graphics2D initializeGraphics2D(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return graphics2D;
    }

    private static void drawSequence(Map<Integer, Integer> posCount, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, String hap) {
        int length = exonSize;
        graphics2D.setColor(Color.LIGHT_GRAY);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        graphics2D.draw3DRect(0, yBase - 450, 1000, 10, true);
        graphics2D.fill3DRect(0, yBase - 450, 1000, 10, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(1, yBase - 450, 1, bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000 - 450 + 10);
        graphics2D.drawString("1 " + hap, 1, yBase - 424);
        graphics2D.drawLine(bufferedImage.getWidth() - 1, yBase - 450, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000 - 450 + 10);
        graphics2D.drawString(new Integer(length).toString(), bufferedImage.getWidth() - new Integer(length).toString().length() * 8, yBase - 424);
        double unit = ParseFastaByHapType3.getUnit(exonSize);
        int num = new Double((double)exonSize / unit).intValue();
        int x = 0;
        String index = null;
        int i = 1;
        while (i <= num) {
            x = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * unit * (double)i).floatValue());
            index = String.valueOf(new Double(unit * (double)i).intValue());
            graphics2D.drawLine(x, yBase - 450, x, yBase - 450 + 10);
            if (i < num || i == num && (double)length - unit * (double)num >= unit / 2.0) {
                graphics2D.drawString(index, x, yBase - 424);
            }
            ++i;
        }
    }

    private static void writeImageToFile(BufferedImage bufferedImage, File imageFile) {
        FileImageOutputStream fileImageOutputStream = null;
        ImageWriter imageWriter = null;
        try {
            try {
                fileImageOutputStream = new FileImageOutputStream(imageFile);
                imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
                imageWriter.setOutput(fileImageOutputStream);
                imageWriter.write(bufferedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fileImageOutputStream != null) {
                    try {
                        fileImageOutputStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
            }
        }
        finally {
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }
}

