/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.ConvertFastaQdataSelect;
import fileOperation.OneMatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;

public class ParseFastaByHapType {
    private static final int MIN_HIT = 10;
    static String LABEL = "000000";

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File hapTypeFile = new File(args[1]);
        File assemblyDir = new File(args[2]);
        File fastaqFile = new File(args[3]);
        ParseFastaByHapType.startType(fastaFile, hapTypeFile, assemblyDir, fastaqFile);
    }

    public static Map<String, List<String>> getReadsByGene(File fastaFile, File hapFile) throws Exception {
        String matchResult = ParseFastaByHapType.runCrossMatch(fastaFile, hapFile);
        Map<String, OneMatch> result = ParseFastaByHapType.ParseResult(matchResult);
        Map<String, List<String>> resultByType = ParseFastaByHapType.orgnizeResult(result);
        return resultByType;
    }

    public static void startType(File fastaFile, File hapFile, File assemblyDir, File fastaqFile) throws Exception {
        String matchResult = ParseFastaByHapType.runCrossMatch(fastaFile, hapFile);
        Map<String, OneMatch> result = ParseFastaByHapType.ParseResult(matchResult);
        Map<String, List<String>> resultByType = ParseFastaByHapType.orgnizeResult(result);
        ParseFastaByHapType.output(resultByType, hapFile, assemblyDir, fastaqFile);
    }

    private static Map<String, List<String>> orgnizeResult(Map<String, OneMatch> result) throws Exception {
        HashMap<String, List<String>> resultByType = new HashMap<String, List<String>>();
        for (String name : result.keySet()) {
            String type2;
            String type1;
            OneMatch aMatch = result.get(name);
            String type = null;
            type = aMatch.isForwardExist() && aMatch.isReverseExist() ? ((type1 = aMatch.getForwardType()).equals(type2 = aMatch.getReverseType()) ? type1 : (aMatch.getForwardMisMatch() < aMatch.getReverseMisMatch() ? type1 : type2)) : (aMatch.isForwardExist() ? aMatch.getForwardType() : aMatch.getReverseType());
            if (!resultByType.containsKey(type)) {
                resultByType.put(type, new ArrayList());
            }
            ((List)resultByType.get(type)).add(name);
        }
        return resultByType;
    }

    private static void output(Map<String, List<String>> result, File hapFile, File assemblyDir, File fastaqFile) throws Exception {
        Map<String, String> types = ParseFastaByHapType.getAllTypes(hapFile);
        for (String type : types.keySet()) {
            if (!result.containsKey(type)) continue;
            String name = ParseFastaByHapType.formatTypeName(type);
            System.out.println(String.valueOf(name) + "\t" + result.get(type).size());
        }
    }

    public static void convert(File phdDir, List<String> fNames, File fastaqFile, String prefix) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(fastaqFile));
        try {
            String line;
            String name = null;
            String sequence = null;
            String qualityChars = null;
            boolean isSeq = false;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("@") && fNames.contains(line.trim().substring(1, line.trim().length() - 2))) {
                    name = ConvertFastaQdataMiSeq.generateName(line.trim().substring(1));
                    isSeq = true;
                } else if (line.startsWith("+") && line.trim().length() == 1) {
                    isSeq = false;
                } else if (isSeq) {
                    sequence = line.trim();
                } else {
                    qualityChars = line.trim();
                }
                if (sequence == null || qualityChars == null) continue;
                ConvertFastaQdataSelect.writePhdFile(phdDir, prefix == null ? name : String.valueOf(prefix) + "-" + name, sequence, qualityChars);
                sequence = null;
                qualityChars = null;
                name = null;
                isSeq = false;
            }
        }
        finally {
            reader.close();
        }
    }

    public static File makeDirs(File outputRoot) {
        File phdDir = new File(outputRoot, "phd_dir");
        File assemblyDir = new File(outputRoot, "assembly");
        File chromatDir = new File(outputRoot, "chromat_dir");
        if (!phdDir.isDirectory()) {
            phdDir.mkdirs();
        }
        if (!assemblyDir.isDirectory()) {
            assemblyDir.mkdirs();
        }
        if (!chromatDir.isDirectory()) {
            chromatDir.mkdirs();
        }
        return phdDir;
    }

    private static String formatTypeName(String type) {
        return type;
    }

    private static Object getName(String t, Map<String, String> types) {
        for (String name : types.keySet()) {
            if (!types.get(name).equals(t)) continue;
            return name;
        }
        return null;
    }

    private static Map<String, String> getAllTypes(File hapFile) {
        String[] lines;
        LinkedHashMap<String, String> types = new LinkedHashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(hapFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(">")) {
                String[] items = line.substring(1).split("\\s+");
                if (items.length == 1) {
                    types.put(items[0], items[0]);
                } else {
                    types.put(items[0], items[1]);
                }
            }
            ++n2;
        }
        return types;
    }

    private static Map<String, OneMatch> ParseResult(String matchResult) {
        String[] lines = matchResult.split("\n");
        HashMap<String, OneMatch> result = new HashMap<String, OneMatch>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                String type;
                OneMatch aMatch;
                String[] items = line.trim().split("\\s+");
                String thisRead = items[4].trim();
                String name = thisRead.substring(0, thisRead.length() - 2);
                if (!result.containsKey(name)) {
                    aMatch = new OneMatch();
                    aMatch.setName(name);
                    result.put(name, aMatch);
                }
                aMatch = (OneMatch)result.get(name);
                boolean isRevComp = items[8].trim().equals("C");
                String string = type = isRevComp ? items[9].trim() : items[8].trim();
                if (isRevComp) {
                    aMatch.setReverseExist(true);
                    aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                    aMatch.setReverseMisMatch(Double.valueOf(items[1].trim()));
                    aMatch.setReverseType(type);
                } else {
                    aMatch.setForwardExist(true);
                    aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
                    aMatch.setForwardMisMatch(Double.valueOf(items[1].trim()));
                    aMatch.setForwardType(type);
                }
            }
            ++n2;
        }
        return result;
    }

    private static String runCrossMatch(File fastaFile, File hapFile) {
        String cmd = "/genome/bin/cross_match " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath();
        String data = OsHelper.excuteCommand(cmd);
        return data;
    }
}

