/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.Reads;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class ParseAce {
    static int SIZE = 600;
    static String GENERAL_NAME = "000000";

    public static void main(String[] args) throws Exception {
        File aceFile = new File(args[0]);
        String[] lines = FileManager.readTextFile(aceFile).split("\n");
        Map<String, Reads> reads = ParseAce.getAllReads(lines);
        ParseAce.getAllInfo(reads);
        ParseAce.getAllError(reads);
    }

    private static void getAllInfo(Map<String, Reads> reads) {
        System.out.println("-------------info------------");
        ArrayList<Integer> contigNum = new ArrayList<Integer>();
        HashMap info = new HashMap();
        for (String name : reads.keySet()) {
            Reads read = reads.get(name);
            if (read.getForwardContigs() == read.getReverseContigs() || read.getForwardContigs() == 0 || read.getReverseContigs() == 0) continue;
            if (!contigNum.contains(new Integer(read.getForwardContigs()))) {
                contigNum.add(read.getForwardContigs());
            }
            if (!contigNum.contains(new Integer(read.getReverseContigs()))) {
                contigNum.add(read.getReverseContigs());
            }
            if (!info.containsKey(new Integer(read.getForwardContigs()))) {
                info.put(new Integer(read.getForwardContigs()), new ArrayList());
            }
            if (!info.containsKey(new Integer(read.getReverseContigs()))) {
                info.put(new Integer(read.getReverseContigs()), new ArrayList());
            }
            ((List)info.get(new Integer(read.getForwardContigs()))).add(read);
            ((List)info.get(new Integer(read.getReverseContigs()))).add(read);
        }
        Collections.sort(contigNum);
        for (Integer num : contigNum) {
            System.out.println("\n------Contig" + num + "-------------\n");
            List rs = (List)info.get(num);
            for (Reads read : rs) {
                if (read.getForwardContigs() != num.intValue()) {
                    System.out.print("Contig" + read.getForwardContigs() + " " + read.getName() + " " + read.getForwardPos() + " " + read.getForwardDirection() + " vs " + read.getReversePos() + " " + read.getReverseDirection());
                } else {
                    System.out.print("Contig" + read.getReverseContigs() + " " + read.getName() + " " + read.getReversePos() + " " + read.getReverseDirection() + " vs " + read.getForwardPos() + " " + read.getForwardDirection());
                }
                System.out.print("\n");
            }
        }
    }

    private static void getAllError(Map<String, Reads> reads) {
        System.out.println("-------------error------------");
        for (String name : reads.keySet()) {
            Reads read = reads.get(name);
            if (read.getForwardContigs() == 0 || read.getReverseContigs() == 0 || read.getForwardContigs() != read.getReverseContigs()) continue;
            if (read.getForwardDirection().equals(read.getReverseDirection())) {
                System.out.println("Code A :" + name + " 1: Contig" + read.getForwardContigs() + " " + read.getForwardPos() + " " + read.getForwardDirection() + ", 2: Contig" + read.getReverseContigs() + " " + read.getReversePos() + " " + read.getReverseDirection());
                continue;
            }
            int distance = Math.abs(read.getForwardPos() - read.getReversePos());
            if (distance > SIZE) {
                System.out.println("Code B :" + name + " 1: Contig" + read.getForwardContigs() + " " + read.getForwardPos() + " " + read.getForwardDirection() + ", 2: Contig" + read.getReverseContigs() + " " + read.getReversePos() + " " + read.getReverseDirection());
                continue;
            }
            if (read.getForwardDirection().equals("U") && read.getForwardPos() > read.getReversePos() + 150) {
                System.out.println("Code C :" + name + " 1: Contig" + read.getForwardContigs() + " " + read.getForwardPos() + " " + read.getForwardDirection() + ", 2: Contig" + read.getReverseContigs() + " " + read.getReversePos() + " " + read.getReverseDirection());
            }
            if (!read.getReverseDirection().equals("U") || read.getReversePos() <= read.getForwardPos() + 150) continue;
            System.out.println("Code C :" + name + " 1: Contig" + read.getForwardContigs() + " " + read.getForwardPos() + " " + read.getForwardDirection() + ", 2: Contig" + read.getReverseContigs() + " " + read.getReversePos() + " " + read.getReverseDirection());
        }
    }

    private static Map<String, Reads> getAllReads(String[] lines) {
        HashMap<String, Reads> reads = new HashMap<String, Reads>();
        int contigNum = 0;
        String name = null;
        int index = 0;
        String dir = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.split("\\s+");
            if (line.startsWith("CO ")) {
                contigNum = Integer.valueOf(items[1].replaceAll("Contig", ""));
            } else if (line.startsWith("AF") && (name = items[1].substring(0, items[1].length() - 2)).startsWith(GENERAL_NAME)) {
                index = Integer.valueOf(items[1].substring(items[1].length() - 1));
                dir = items[2];
                if (!reads.containsKey(name)) {
                    reads.put(name, new Reads());
                }
                Reads read = (Reads)reads.get(name);
                read.setName(name);
                if (index == 1) {
                    read.setForwardContigs(contigNum);
                    read.setForwardPos(Integer.valueOf(items[3]));
                    read.setForwardDirection(dir);
                } else if (index == 2) {
                    read.setReverseContigs(contigNum);
                    read.setReversePos(Integer.valueOf(items[3]));
                    read.setReverseDirection(dir);
                } else {
                    System.out.println("error " + line);
                }
            }
            ++n2;
        }
        return reads;
    }
}

