/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import misc.FileManager;

public class NalleleRule {
    public static void main(String[] args) throws Exception {
        File RuleDir = new File(args[0]);
        File outputFile = new File(args[1]);
        String locus = new String(args[2]);
        File majorFile = new File(RuleDir, String.valueOf(locus) + "-exon23.fa");
        File majorAmbFile = new File(RuleDir, String.valueOf(locus) + "-exon23-hap-amb.txt");
        List<String> nNames = NalleleRule.getAllNnames(majorFile);
        List<String> nNamesWithAmb = NalleleRule.getNambiguityNames(nNames, majorAmbFile);
        File exon4File = new File(RuleDir, String.valueOf(locus) + "-exon4.fa");
        File exon4AmbFile = new File(RuleDir, String.valueOf(locus) + "-exon4-hap-amb.txt");
        File exon1File = new File(RuleDir, "ABC-exon1.fa");
        File exon1AmbFile = new File(RuleDir, "ABC-exon1-hap-amb.txt");
        File exon5File = new File(RuleDir, "ABC-exon5.fa");
        File exon5AmbFile = new File(RuleDir, "ABC-exon5-hap-amb.txt");
        File exon6File = new File(RuleDir, "ABC-exon6.fa");
        File exon6AmbFile = new File(RuleDir, "ABC-exon6-hap-amb.txt");
        File exon7File = new File(RuleDir, "ABC-exon7.fa");
        File exon7AmbFile = new File(RuleDir, "ABC-exon7-hap-amb.txt");
        List<String> nNamesUniqueExon4 = NalleleRule.checkUniqueAndExist(exon4File, exon4AmbFile);
        List<String> nNamesUniqueExon1 = NalleleRule.checkUniqueAndExist(exon1File, exon1AmbFile);
        List<String> nNamesUniqueExon5 = NalleleRule.checkUniqueAndExist(exon5File, exon5AmbFile);
        List<String> nNamesUniqueExon6 = NalleleRule.checkUniqueAndExist(exon6File, exon6AmbFile);
        List<String> nNamesUniqueExon7 = NalleleRule.checkUniqueAndExist(exon7File, exon7AmbFile);
        StringBuilder builder = new StringBuilder();
        for (String name : nNamesWithAmb) {
            builder.append(name).append("\t");
            if (nNamesUniqueExon4.contains(name)) {
                builder.append("exon4").append("\t");
            }
            if (nNamesUniqueExon1.contains(name)) {
                builder.append("exon1").append("\t");
            }
            if (nNamesUniqueExon5.contains(name)) {
                builder.append("exon5").append("\t");
            }
            if (nNamesUniqueExon6.contains(name)) {
                builder.append("exon6").append("\t");
            }
            if (nNamesUniqueExon7.contains(name)) {
                builder.append("exon7").append("\t");
            }
            builder.append("\n");
        }
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    private static List<String> checkUniqueAndExist(File exonFile, File exonAmbFile) {
        List<String> nNamesExon = NalleleRule.getAllNnames(exonFile);
        List<String> nNamesUnique = NalleleRule.getUniqueNames(nNamesExon, exonAmbFile);
        return nNamesUnique;
    }

    private static List<String> getUniqueNames(List<String> nNames, File hapAmbFile) {
        List<String> ambNnames = NalleleRule.getNambiguityNames(nNames, hapAmbFile);
        ArrayList<String> uniquNames = new ArrayList<String>();
        for (String nName : nNames) {
            if (ambNnames.contains(nName)) continue;
            uniquNames.add(nName);
        }
        return uniquNames;
    }

    private static List<String> getNambiguityNames(List<String> nNames, File hapAmbFile) {
        String[] lines;
        LinkedHashMap<String, String> hapNames = new LinkedHashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(hapAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    hapNames.put(items[i].trim(), gname);
                    ++i;
                }
            }
            ++n2;
        }
        ArrayList<String> ambNnames = new ArrayList<String>();
        block2: for (String nName : nNames) {
            for (String hapName : hapNames.keySet()) {
                if (!nName.equals(hapName)) continue;
                ambNnames.add(nName);
                continue block2;
            }
        }
        return ambNnames;
    }

    private static List<String> getAllNnames(File fastaFile) {
        ArrayList<String> nNames = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            String name;
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">") && (name = lines[i].trim().substring(1)).endsWith("N")) {
                nNames.add(name);
            }
            ++i;
        }
        return nNames;
    }
}

