/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import misc.FileManager;

public class MergeFastqFiles {
    static String HEADER = "@M00474";
    static String HEADER2 = "@M00676";
    static String HEADER3 = "@M02385";
    static String SEPARATER1 = "000000000-A7PBP";
    static String SEPARATER2 = "000000000-A6U3L";
    static String SEPARATER3 = "000000000-A7WBV";
    static String SEPARATER4 = "000000000-A6AN3";
    static String SEPARATER5 = "000000000-A6DET";
    static String NEW_HEADER = ">000000";
    static String NEW_HEADER2 = "000000";

    public static void main(String[] args) throws Exception {
        File r1File = new File(args[0]);
        File r2File = new File(args[1]);
        File outputFile = new File(args[2]);
        String[] lines1 = FileManager.readTextFile(r1File).split("\n");
        String[] lines2 = FileManager.readTextFile(r2File).split("\n");
        Map<String, String> seqMap1 = MergeFastqFiles.getSeqMap(lines1, 1);
        Map<String, String> seqMap2 = MergeFastqFiles.getSeqMap(lines2, 2);
        StringBuilder out = new StringBuilder();
        long seed = System.nanoTime();
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(seqMap1.keySet());
        Collections.shuffle(names, new Random(seed));
        for (String name : seqMap1.keySet()) {
            out.append(seqMap1.get(name));
            out.append(seqMap2.get(name));
        }
        FileManager.writeTextFile(outputFile, out.toString(), true);
    }

    private static Map<String, String> getSeqMap(String[] lines, int index) {
        HashMap<String, String> seqMap = new HashMap<String, String>();
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith(HEADER) || line.startsWith(HEADER2) || line.startsWith(HEADER3)) {
                String name = MergeFastqFiles.generateName(line);
                seqMap.put(name, MergeFastqFiles.getThisBlock(lines, i, name, index));
                ++i;
            }
            ++i;
        }
        return seqMap;
    }

    private static String getThisBlock(String[] lines, int i, String name, int index) {
        StringBuilder block = new StringBuilder();
        block.append("@").append(NEW_HEADER2).append(name).append("/").append(index).append("\n");
        block.append(lines[i + 1].trim()).append("\n");
        block.append(lines[i + 2].trim()).append("\n");
        block.append(lines[i + 3].trim()).append("\n");
        return block.toString();
    }

    private static String generateName(String line) {
        String[] items = line.split("\\s+")[0].split(SEPARATER1);
        if (items.length == 1) {
            items = line.split("\\s+")[0].split(SEPARATER2);
        }
        if (items.length == 1) {
            items = line.split("\\s+")[0].split(SEPARATER3);
        }
        if (items.length == 1) {
            items = line.split("\\s+")[0].split(SEPARATER4);
        }
        if (items.length == 1) {
            items = line.split("\\s+")[0].split(SEPARATER5);
        }
        String name = items[1].trim();
        return name;
    }
}

