/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import misc.FileManager;

public class MergeAndRandomizeFasta {
    static int LENGTH = 301;
    static String TAIL = "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN";

    public static void main(String[] args) throws Exception {
        File[] files2;
        File inputDir1 = new File(args[0]);
        File inputDir2 = new File(args[1]);
        File outputDir = new File(args[2]);
        File[] files1 = inputDir1.listFiles();
        HashMap fileMap = new HashMap();
        File[] fileArray = files1;
        int n = files1.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            String sample = MergeAndRandomizeFasta.findSampleName(name);
            if (!fileMap.containsKey(sample)) {
                fileMap.put(sample, new ArrayList());
            }
            ((List)fileMap.get(sample)).add(file);
            ++n2;
        }
        File[] fileArray2 = files2 = inputDir2.listFiles();
        int n3 = files2.length;
        n = 0;
        while (n < n3) {
            File file = fileArray2[n];
            String name = file.getName();
            String sample = MergeAndRandomizeFasta.findSampleName(name);
            System.out.println(String.valueOf(name) + "->" + sample + " " + fileMap.containsKey(sample));
            if (fileMap.containsKey(sample)) {
                ((List)fileMap.get(sample)).add(file);
            }
            ++n;
        }
        System.out.println("total samples : " + fileMap.size());
        for (String sample : fileMap.keySet()) {
            File dest = new File(outputDir, ((File)((List)fileMap.get(sample)).get(0)).getName());
            if (((List)fileMap.get(sample)).size() != 2) {
                System.out.println("??????" + sample + " " + fileMap.get(sample));
                continue;
            }
            System.out.println(String.valueOf(sample) + " " + ((File)((List)fileMap.get(sample)).get(0)).getAbsolutePath() + " " + ((File)((List)fileMap.get(sample)).get(1)).getAbsolutePath());
            MergeAndRandomizeFasta.mergeFile((File)((List)fileMap.get(sample)).get(0), (File)((List)fileMap.get(sample)).get(1), dest);
        }
    }

    private static String findSampleName(String name) {
        String[] mainFields;
        String[] stringArray = mainFields = name.split("_")[0].split("-");
        int n = mainFields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (field.length() == 7 && (field.startsWith("NA") || field.startsWith("HG"))) {
                return field;
            }
            ++n2;
        }
        return name.split("_")[0];
    }

    private static void mergeFile(File file, File mergeFile, File output) {
        HashMap<String, String> seqMap = new HashMap<String, String>();
        String[] lines1 = FileManager.readTextFile(file).split("\n");
        MergeAndRandomizeFasta.getSeqMap(lines1, seqMap);
        String[] lines2 = FileManager.readTextFile(mergeFile).split("\n");
        MergeAndRandomizeFasta.getSeqMap(lines2, seqMap);
        StringBuilder out = new StringBuilder();
        long seed = System.nanoTime();
        ArrayList names = new ArrayList();
        names.addAll(seqMap.keySet());
        Collections.shuffle(names, new Random(seed));
        for (String name : names) {
            out.append(name).append("\n");
            out.append((String)seqMap.get(name));
        }
        FileManager.writeTextFile(output, out.toString(), true);
    }

    private static Map<String, String> getSeqMap(String[] lines, Map<String, String> seqMap) {
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith(">") && line.endsWith("1")) {
                String name = line;
                String seq1 = lines[i + 1].trim();
                String seq2 = lines[i + 3].trim();
                seqMap.put(name, String.valueOf(MergeAndRandomizeFasta.patch(seq1)) + "\n" + lines[i + 2].trim() + "\n" + MergeAndRandomizeFasta.patch(seq2) + "\n");
                i += 3;
            }
            ++i;
        }
        return seqMap;
    }

    private static String patch(String seq) {
        if (seq.length() < 301) {
            return String.valueOf(seq) + TAIL;
        }
        return seq;
    }
}

