/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import misc.FileManager;
import misc.SystemCommand;

public class MergeAceFile {
    public static void main(String[] args) throws Exception {
        File mainFile = new File(args[0]);
        File smallFile = new File(args[1]);
        MergeAceFile.merge(mainFile, smallFile);
    }

    public static void merge(File mainFile, File smallFile) {
        int num;
        String[] lines = FileManager.readTextFile(mainFile).split("\n");
        String[] toAdd = FileManager.readTextFile(smallFile).split("\n");
        StringBuilder data = new StringBuilder();
        data.append(MergeAceFile.makeHeaderLine(lines[0], toAdd[0])).append("\n");
        int maxContig = 1;
        int i = 1;
        while (i < lines.length - 6) {
            data.append(lines[i].trim()).append("\n");
            if (lines[i].startsWith("CO Contig") && (num = Integer.valueOf(lines[i].split("\\s+")[1].substring(6)).intValue()) > maxContig) {
                maxContig = num;
            }
            ++i;
        }
        System.out.println("max " + maxContig);
        i = 1;
        while (i < toAdd.length) {
            if (toAdd[i].startsWith("CO Contig")) {
                num = maxContig + 1;
                String[] elem = toAdd[i].split("\\s+");
                String thisLine = "CO Contig" + num + " " + elem[2] + " " + elem[3] + " " + elem[4] + " " + elem[5];
                ++maxContig;
                data.append(thisLine.trim()).append("\n");
            } else {
                data.append(toAdd[i].trim()).append("\n");
            }
            ++i;
        }
        FileManager.writeTextFile(mainFile, data.toString(), true);
        MergeAceFile.copyPhds(new File(smallFile.getParentFile().getParentFile(), "phd_dir"), new File(mainFile.getParentFile().getParentFile(), "phd_dir"));
    }

    private static void copyPhds(File srcDir, File destDir) {
        String cmd = "cp " + srcDir.getAbsolutePath() + "/* " + destDir;
        System.out.println(cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, true);
        command.makeItSo();
    }

    private static String makeHeaderLine(String mainLine, String addLine) {
        String[] m = mainLine.split("\\s+");
        String[] a = addLine.split("\\s+");
        int numContigs = Integer.valueOf(m[1]) + Integer.valueOf(a[1]);
        int numReads = Integer.valueOf(m[2]) + Integer.valueOf(a[2]);
        System.out.println("new Header :AS " + numContigs + " " + numReads);
        return "AS " + numContigs + " " + numReads;
    }
}

