/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import misc.FileManager;

public class JoinFasta {
    public static void main(String[] args) throws Exception {
        File joinLog = new File(args[0]);
        File dir = new File(args[1]);
        File output = new File(args[2]);
        StringBuilder seq = new StringBuilder();
        seq.append(">\n");
        String[] log = FileManager.readTextFile(joinLog).split("\n");
        int i = 0;
        while (i < log.length) {
            String[] fields = log[i].split("\\s+");
            if (fields[0].trim().equals("N")) {
                seq.append(JoinFasta.getGapSeq(Integer.valueOf(fields[1].trim())));
            } else {
                String bacName = fields[0].trim();
                File bacFile = new File(dir, String.valueOf(bacName) + ".fa");
                System.out.println(bacName);
                seq.append(JoinFasta.getSequenceFromFasta(bacFile).substring(Integer.valueOf(fields[1].trim()) - 1));
            }
            ++i;
        }
        FileManager.writeTextFile(output, seq.toString(), true);
    }

    public static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }

    private static String getGapSeq(Integer count) {
        StringBuilder seq = new StringBuilder();
        int i = 0;
        while (i < count) {
            seq.append("N");
            ++i;
        }
        return seq.toString();
    }
}

