/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ParseFastaByHapType8;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import misc.FileManager;
import misc.StringUtils;

public class HashRuleSet {
    static int HASH_SIZE = 15;
    static int START_OFF_SET = 5;
    static int NUMBER_EACH_DIRECTION = 4;
    static int BOUNDARY = 270;

    public static void main(String[] args) throws Exception {
        File[] hapFiles;
        File hapTypeRoot = new File(args[0]);
        File outputRoot = new File(args[1]);
        StringBuilder builder = new StringBuilder();
        File[] fileArray = hapFiles = hapTypeRoot.listFiles();
        int n = hapFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File hapFile = fileArray[n2];
            builder = new StringBuilder();
            if (hapFile.getName().endsWith("fa")) {
                File hapAmbFile = new File(hapTypeRoot, String.valueOf(hapFile.getName().substring(0, hapFile.getName().length() - 3)) + ParseFastaByHapType8.HAP_AMB_TXT);
                HashMap<String, String> hapNames = new HashMap<String, String>();
                if (hapAmbFile.exists()) {
                    System.out.println("parse hap amb file " + hapAmbFile.getName());
                    ParseFastaByHapType8.populateHapAmbNames(hapNames, hapAmbFile);
                }
                File tmpFile = HashRuleSet.organizeFastaByHap(hapNames, hapFile);
                tmpFile.deleteOnExit();
                File outputFile = new File(outputRoot, String.valueOf(hapFile.getName().substring(0, hapFile.getName().length() - 3)) + "-hash.txt");
                String[] lines = FileManager.readTextFile(tmpFile).split("\n");
                Map<String, String> seqMap = HashRuleSet.getAllSequences(lines);
                HashRuleSet.hashExon(builder, seqMap, 0);
                HashRuleSet.hashExon(builder, seqMap, BOUNDARY);
                FileManager.writeTextFile(outputFile, builder.toString(), true);
            }
            ++n2;
        }
    }

    private static void hashExon(StringBuilder builder, Map<String, String> seqMap, int start) {
        String seq = null;
        int i = 0;
        while (i < NUMBER_EACH_DIRECTION) {
            HashMap<String, String> fseqTable = new HashMap<String, String>();
            HashMap<String, String> rseqTable = new HashMap<String, String>();
            for (String type : seqMap.keySet()) {
                seq = seqMap.get(type).substring(start + START_OFF_SET + i * HASH_SIZE, start + START_OFF_SET + (i + 1) * HASH_SIZE);
                if (!fseqTable.containsKey(seq)) {
                    fseqTable.put(seq, "");
                }
                fseqTable.put(seq, String.valueOf((String)fseqTable.get(seq)) + type + ",");
                int end = seqMap.get(type).length() - 1;
                if (start == 0) {
                    end = 269;
                }
                seq = seqMap.get(type).substring(end - (i + 1) * HASH_SIZE - START_OFF_SET, end - i * HASH_SIZE - START_OFF_SET);
                if (!rseqTable.containsKey(seq = StringUtils.revCompSeq(seq))) {
                    rseqTable.put(seq, "");
                }
                rseqTable.put(seq, String.valueOf((String)rseqTable.get(seq)) + type + ",");
            }
            HashRuleSet.addToLog(builder, fseqTable, false, i, start);
            HashRuleSet.addToLog(builder, rseqTable, true, i, start);
            ++i;
        }
    }

    public static File organizeFastaByHap(Map<String, String> hapAmbNames, File fastaFile) throws Exception {
        File tmpFn = File.createTempFile("seq", "fasta");
        tmpFn.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        ArrayList<String> existAmbTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (!hapAmbNames.containsKey(name)) {
                    builder.append(lines[i].trim()).append("\n");
                    builder.append(sequence).append("\n");
                } else {
                    String gname = hapAmbNames.get(name);
                    if (!existAmbTypes.contains(gname)) {
                        builder.append(">").append(gname).append("\n");
                        builder.append(sequence).append("\n");
                        existAmbTypes.add(gname);
                    }
                }
            }
            ++i;
        }
        FileManager.writeTextFile(tmpFn, builder.toString(), true);
        System.out.println("total type: " + FileManager.readTextFile(tmpFn).split("\n").length / 2);
        return tmpFn;
    }

    private static void addToLog(StringBuilder builder, Map<String, String> seqTable, boolean isRevComp, int index, int start) {
        for (String seq : seqTable.keySet()) {
            builder.append(seq).append("\t");
            builder.append(seqTable.get(seq)).append("\t");
            builder.append(index + 1).append("\t");
            builder.append(start == 0 ? 2 : 3).append("\t");
            builder.append(isRevComp).append("\n");
        }
    }

    private static Map<String, String> getAllSequences(String[] lines) {
        HashMap<String, String> seqMap = new HashMap<String, String>();
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                seqMap.put(name, sequence);
            }
            ++i;
        }
        return seqMap;
    }
}

