/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.SystemCommand;

public class HapTypingBuck {
    static String PREFIX = "000000";

    public static void main(String[] args) throws Exception {
        File fastaDir = new File(args[0]);
        File kirKeyFile = new File(args[1]);
        File kirHapFile = new File(args[2]);
        File outputFile = new File(args[3]);
        LinkedHashMap<String, Map<String, Integer>> overallResult = new LinkedHashMap<String, Map<String, Integer>>();
        HapTypingBuck.match(fastaDir, kirKeyFile, kirHapFile, overallResult, outputFile);
    }

    public static void match(File fastaDir, File kirKeyFile, File kirHapFile, Map<String, Map<String, Integer>> overallResult, File outputFile) throws Exception {
        Map<String, String> keyMap = HapTypingBuck.getKeyMap(kirKeyFile);
        String[] lines = FileManager.readTextFile(kirHapFile).split("\n");
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            String[] info = data.trim().split("\\s+");
            if (info.length >= 5) {
                String geneExon = info[1].substring(0, info[1].length() - 2);
                List<File> files = HapTypingBuck.getCelllines(fastaDir, info[0]);
                for (File file : files) {
                    String outName = file.getName().substring(0, file.getName().length() - 9);
                    if (!overallResult.containsKey(outName)) {
                        overallResult.put(outName, new LinkedHashMap());
                    }
                    File geneExonFile = HapTypingBuck.createGeneExonFile(file, keyMap.get(geneExon));
                    if (!overallResult.get(outName).containsKey(geneExon)) {
                        overallResult.get(outName).put(geneExon, 0);
                    }
                    HapTypingBuck.getCount(geneExonFile, geneExon, keyMap.get(geneExon), info[1], info[2], overallResult.get(outName));
                }
            }
            ++n2;
        }
        for (String gene : keyMap.keySet()) {
            for (String cellLine : overallResult.keySet()) {
                if (overallResult.get(cellLine).get(gene) != null) continue;
                File geneExonFile = HapTypingBuck.createGeneExonFile(HapTypingBuck.getFastaFile(fastaDir, cellLine), keyMap.get(gene));
                String cmd = "grep -o \"" + keyMap.get(gene) + "\" " + geneExonFile.getAbsolutePath() + " | wc -l";
                String[] commandArray = new String[]{"bash", "-c", cmd};
                SystemCommand command = new SystemCommand(commandArray, null, true);
                command.makeItSo();
                overallResult.get(cellLine).put(gene, Integer.valueOf(command.getStandardOut().trim()));
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String cellLine : overallResult.keySet()) {
            builder.append(cellLine).append("\t");
            for (String gene : keyMap.keySet()) {
                builder.append(String.valueOf(gene) + "=" + (overallResult.get(cellLine).get(gene) == null ? 0 : overallResult.get(cellLine).get(gene))).append("(");
                for (String hapType : overallResult.get(cellLine).keySet()) {
                    if (hapType.equals(gene) || hapType.indexOf(gene) < 0) continue;
                    builder.append(String.valueOf(hapType) + "=" + overallResult.get(cellLine).get(hapType) + ",");
                }
                builder.append(")").append("\t");
            }
            builder.append("\n");
        }
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    private static List<File> getCelllines(File fastaDir, String name) {
        ArrayList<File> files = new ArrayList<File>();
        Object[] all = fastaDir.listFiles();
        Arrays.sort(all);
        Object[] objectArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).getName().indexOf(name) >= 0 && ((File)file).getName().endsWith("fa")) {
                files.add((File)file);
            }
            ++n2;
        }
        return files;
    }

    private static File createGeneExonFile(File fastaFile, String key) throws Exception {
        File tempFile = File.createTempFile("abc", "fa");
        tempFile.deleteOnExit();
        System.out.println(String.valueOf(fastaFile.getAbsolutePath()) + " " + key);
        String cmd = "grep -R -B1 \"" + key + "\" " + fastaFile.getAbsolutePath();
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, true);
        command.makeItSo();
        if (command.getStandardOut() == null) {
            return tempFile;
        }
        List<String> fNames = HapTypingBuck.getAllNames(command.getStandardOut().trim());
        StringBuilder builder = new StringBuilder();
        String[] data = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < data.length) {
            String line = data[i];
            if (line.startsWith(">") && fNames.contains(line.trim().substring(1, line.trim().length() - 2))) {
                builder.append(line.trim()).append("\n");
                builder.append(data[i + 1].trim()).append("\n");
            }
            ++i;
        }
        FileManager.writeTextFile(tempFile, builder.toString(), true);
        return tempFile;
    }

    private static List<String> getAllNames(String fnames) {
        String[] lines;
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = lines = fnames.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] data;
            String line = stringArray[n2];
            String[] stringArray2 = data = line.split("\\s+");
            int n3 = data.length;
            int n4 = 0;
            while (n4 < n3) {
                String item = stringArray2[n4];
                if (item.startsWith(PREFIX)) {
                    names.add(item.trim().substring(0, item.trim().length() - 2));
                    break;
                }
                if (item.startsWith(">" + PREFIX)) {
                    names.add(item.trim().substring(1, item.trim().length() - 2));
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        System.out.println("total " + names.size());
        return names;
    }

    private static void getCount(File fastaFile, String geneExon, String key, String gene, String secKey, Map<String, Integer> result) {
        SystemCommand command;
        String[] commandArray;
        String cmd;
        if (result.get(geneExon) == 0) {
            cmd = "grep -o \"" + key + "\" " + fastaFile.getAbsolutePath() + " | wc -l";
            commandArray = new String[]{"bash", "-c", cmd};
            command = new SystemCommand(commandArray, null, true);
            command.makeItSo();
            result.put(geneExon, Integer.valueOf(command.getStandardOut().trim()));
        }
        cmd = "grep -o \"" + secKey.toUpperCase() + "\" " + fastaFile.getAbsolutePath() + " | wc -l";
        commandArray = new String[]{"bash", "-c", cmd};
        command = new SystemCommand(commandArray, null, true);
        command.makeItSo();
        System.out.println("search " + secKey + "=" + command.getStandardOut());
        result.put(gene, Integer.valueOf(command.getStandardOut().trim()));
    }

    private static File getFastaFile(File fastaDir, String name) {
        return new File(fastaDir, String.valueOf(name) + "-47000.fa");
    }

    private static Map<String, String> getKeyMap(File kirKeyFile) {
        String[] lines = FileManager.readTextFile(kirKeyFile).split("\n");
        HashMap<String, String> keys = new HashMap<String, String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] info = line.trim().split("\\s+");
            if (info.length >= 4) {
                String geneExon = String.valueOf(info[0]) + "-exon" + info[3];
                keys.put(geneExon, info[1].trim());
            }
            ++n2;
        }
        return keys;
    }
}

