/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class GenerateExonIntron23 {
    static int TRIM_SIZE = 80;

    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        File output = new File(args[1]);
        String header = args[2];
        File padFile = new File(args[3]);
        File exon2 = new File(input, String.valueOf(header) + "-exon2.fa");
        File exon3 = new File(input, String.valueOf(header) + "-exon3.fa");
        File intron2File = new File(input, String.valueOf(header) + "-intron2.fa");
        File exon23 = new File(output, String.valueOf(header) + "-exon23.fa");
        File bridge23 = new File(output, String.valueOf(header) + "-bridge.fa");
        File bridge23amb = new File(output, String.valueOf(header) + "-bridge-hap-amb.txt");
        Map<String, String> pad = GenerateExonIntron23.getPadInfo(FileManager.readTextFile(padFile).split("\n"));
        Map<String, String> seq2 = GenerateExonIntron23.getSequences(exon2);
        Map<String, String> seq3 = GenerateExonIntron23.getSequences(exon3);
        Map<String, String> intron2 = GenerateExonIntron23.getSequences(intron2File);
        LinkedHashMap<String, String> seq23 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> bridgeSeq23 = new LinkedHashMap<String, String>();
        GenerateExonIntron23.combineAndCutSequences(seq2, seq3, intron2, seq23, bridgeSeq23, pad, header);
        GenerateExonIntron23.outputAmb(bridgeSeq23, bridge23amb);
        GenerateExonIntron23.writeFastaOutput(seq23, exon23);
        GenerateExonIntron23.writeFastaOutput(bridgeSeq23, bridge23);
    }

    public static Map<String, String> getPadInfo(String[] data) {
        LinkedHashMap<String, String> pad = new LinkedHashMap<String, String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split("\\s+");
            pad.put(items[0].trim(), items[1].trim());
            ++n2;
        }
        return pad;
    }

    private static void writeFastaOutput(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        for (String name : seq.keySet()) {
            sb.append(">").append(name).append("\n");
            sb.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static void combineAndCutSequences(Map<String, String> seq2, Map<String, String> seq3, Map<String, String> intron2, Map<String, String> seq23, Map<String, String> bridgeSeq23, Map<String, String> pad, String header) {
        for (String name : seq2.keySet()) {
            if (name.indexOf("sudo") > 0 || !name.startsWith(header)) continue;
            String intron = null;
            if (!intron2.containsKey(name) && !pad.containsKey(name)) {
                if (name.startsWith("A*01")) {
                    intron = intron2.get("A*01:01:01:01");
                } else if (name.startsWith("A*02")) {
                    intron = intron2.get("A*02:01:01:01");
                } else if (name.startsWith("A*03")) {
                    intron = intron2.get("A*03:01:01:01");
                } else if (name.startsWith("A*11")) {
                    intron = intron2.get("A*11:01:01:01");
                } else if (name.startsWith("A*23")) {
                    intron = intron2.get("A*23:01:01");
                } else if (name.startsWith("A*24")) {
                    intron = intron2.get("A*24:02:01:01");
                } else if (name.startsWith("A*25")) {
                    intron = intron2.get("A*25:01:01");
                } else if (name.startsWith("A*26")) {
                    intron = intron2.get("A*26:01:01:01");
                } else if (name.startsWith("A*29")) {
                    intron = intron2.get("A*29:01:01:01");
                } else if (name.startsWith("A*30")) {
                    intron = intron2.get("A*30:01:01");
                } else if (name.startsWith("A*31")) {
                    intron = intron2.get("A*31:01:02:01");
                } else if (name.startsWith("A*32")) {
                    intron = intron2.get("A*32:01:01");
                } else if (name.startsWith("A*33")) {
                    intron = intron2.get("A*33:01:01");
                } else if (name.startsWith("A*34")) {
                    intron = intron2.get("A*34:01:01");
                } else if (name.startsWith("A*36")) {
                    intron = intron2.get("A*36:01");
                } else if (name.startsWith("A*66")) {
                    intron = intron2.get("A*66:01:01");
                } else if (name.startsWith("A*68")) {
                    intron = intron2.get("A*68:01:01:01");
                } else if (name.startsWith("A*69")) {
                    intron = intron2.get("A*69:01");
                } else if (name.startsWith("A*74")) {
                    intron = intron2.get("A*74:01:01");
                } else if (name.startsWith("A*80")) {
                    intron = intron2.get("A*80:01:01:01");
                } else if (name.startsWith("B*07")) {
                    intron = intron2.get("B*07:02:01");
                } else if (name.startsWith("B*08")) {
                    intron = intron2.get("B*08:01:01");
                } else if (name.startsWith("B*13")) {
                    intron = intron2.get("B*13:01:01");
                } else if (name.startsWith("B*14")) {
                    intron = intron2.get("B*14:01:01");
                } else if (name.startsWith("B*15")) {
                    intron = intron2.get("B*15:01:01:01");
                } else if (name.startsWith("B*18")) {
                    intron = intron2.get("B*18:01:01:01");
                } else if (name.startsWith("B*27")) {
                    intron = intron2.get("B*27:02:01");
                } else if (name.startsWith("B*35")) {
                    intron = intron2.get("B*35:01:01:01");
                } else if (name.startsWith("B*37")) {
                    intron = intron2.get("B*37:01:01");
                } else if (name.startsWith("B*38")) {
                    intron = intron2.get("B*38:01:01");
                } else if (name.startsWith("B*39")) {
                    intron = intron2.get("B*39:01:01:01");
                } else if (name.startsWith("B*40")) {
                    intron = intron2.get("B*40:01:01");
                } else if (name.startsWith("B*41")) {
                    intron = intron2.get("B*41:01:01");
                } else if (name.startsWith("B*42")) {
                    intron = intron2.get("B*42:01:01");
                } else if (name.startsWith("B*44")) {
                    intron = intron2.get("B*44:02:01:01");
                } else if (name.startsWith("B*45")) {
                    intron = intron2.get("B*45:01:01");
                } else if (name.startsWith("B*46")) {
                    intron = intron2.get("B*46:01:01");
                } else if (name.startsWith("B*47")) {
                    intron = intron2.get("B*47:01:01:01");
                } else if (name.startsWith("B*48")) {
                    intron = intron2.get("B*48:01:01");
                } else if (name.startsWith("B*49")) {
                    intron = intron2.get("B*49:01:01");
                } else if (name.startsWith("B*50")) {
                    intron = intron2.get("B*50:01:01");
                } else if (name.startsWith("B*51")) {
                    intron = intron2.get("B*51:01:01:01");
                } else if (name.startsWith("B*52")) {
                    intron = intron2.get("B*52:01:01:01");
                } else if (name.startsWith("B*53")) {
                    intron = intron2.get("B*53:01:01");
                } else if (name.startsWith("B*54")) {
                    intron = intron2.get("B*54:01:01");
                } else if (name.startsWith("B*55")) {
                    intron = intron2.get("B*55:01:01");
                } else if (name.startsWith("B*56")) {
                    intron = intron2.get("B*56:01:01:01");
                } else if (name.startsWith("B*57")) {
                    intron = intron2.get("B*57:01:01");
                } else if (name.startsWith("B*58")) {
                    intron = intron2.get("B*58:01:01:01");
                } else if (name.startsWith("B*59")) {
                    intron = intron2.get("B*59:01:01:01");
                } else if (name.startsWith("B*67")) {
                    intron = intron2.get("B*67:01:01");
                } else if (name.startsWith("B*73")) {
                    intron = intron2.get("B*73:01");
                } else if (name.startsWith("B*78")) {
                    intron = intron2.get("B*78:01:01");
                } else if (name.startsWith("B*81")) {
                    intron = intron2.get("B*81:01");
                } else if (name.startsWith("B*82")) {
                    intron = intron2.get("B*82:02:01");
                } else if (name.startsWith("C*01")) {
                    intron = intron2.get("C*01:02:01");
                } else if (name.startsWith("C*02")) {
                    intron = intron2.get("C*02:02:02:01");
                } else if (name.startsWith("C*03")) {
                    intron = intron2.get("C*03:02:01");
                } else if (name.startsWith("C*04")) {
                    intron = intron2.get("C*04:01:01:01");
                } else if (name.startsWith("C*05")) {
                    intron = intron2.get("C*05:01:01:01");
                } else if (name.startsWith("C*06")) {
                    intron = intron2.get("C*06:02:01:01");
                } else if (name.startsWith("C*07")) {
                    intron = intron2.get("C*07:01:01:01");
                } else if (name.startsWith("C*08")) {
                    intron = intron2.get("C*08:01:01");
                } else if (name.startsWith("C*12")) {
                    intron = intron2.get("C*12:02:02");
                } else if (name.startsWith("C*14")) {
                    intron = intron2.get("C*14:02:01:01");
                } else if (name.startsWith("C*15")) {
                    intron = intron2.get("C*15:02:01:01");
                } else if (name.startsWith("C*16")) {
                    intron = intron2.get("C*16:01:01:01");
                } else if (name.startsWith("C*17")) {
                    intron = intron2.get("C*17:01:01:01");
                } else if (name.startsWith("C*18")) {
                    intron = intron2.get("C*18:01");
                }
            } else {
                intron = intron2.containsKey(name) ? intron2.get(name) : intron2.get(pad.get(name));
            }
            seq23.put(name, String.valueOf(seq2.get(name)) + intron + seq3.get(name));
            bridgeSeq23.put(name, String.valueOf(seq2.get(name).substring(TRIM_SIZE)) + intron + seq3.get(name).substring(0, seq3.get(name).length() - TRIM_SIZE));
        }
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static void outputAmb(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap seqName = new LinkedHashMap();
        for (String name : seq.keySet()) {
            if (!seqName.containsKey(seq.get(name))) {
                seqName.put(seq.get(name), new ArrayList());
            }
            ((List)seqName.get(seq.get(name))).add(name);
        }
        for (String sequence : seqName.keySet()) {
            if (((List)seqName.get(sequence)).size() <= 1) continue;
            sb.append(GenerateExonIntron23.createOutput((List)seqName.get(sequence))).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static String createOutput(List<String> list) {
        String out = String.valueOf(list.get(0)) + "R";
        for (String n : list) {
            out = String.valueOf(out) + "\t" + n;
        }
        return out;
    }
}

