/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ExtractFasta;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class GenerateExon678 {
    public static void main(String[] args) throws Exception {
        File inputExon67 = new File(args[0]);
        File inputIntron6 = new File(args[1]);
        File inputIntron7 = new File(args[2]);
        File inputExon8 = new File(args[3]);
        File output = new File(args[4]);
        String header = args[5];
        File padFile = new File(args[6]);
        Map<String, String> pad = ExtractFasta.getPadInfo(FileManager.readTextFile(padFile).split("\n"));
        Map<String, String> seq67 = GenerateExon678.getSequences(inputExon67);
        Map<String, String> intron6 = GenerateExon678.getSequences(inputIntron6);
        Map<String, String> intron7 = GenerateExon678.getSequences(inputIntron7);
        Map<String, String> seq8 = GenerateExon678.getSequences(inputExon8);
        LinkedHashMap<String, String> seq678 = new LinkedHashMap<String, String>();
        GenerateExon678.combineAndCutSequences(seq67, intron6, intron7, seq8, seq678, pad);
        GenerateExon678.writeFastaOutput(seq678, new File(output, String.valueOf(header) + "-bridge678.fa"));
    }

    private static void writeFastaOutput(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        for (String name : seq.keySet()) {
            sb.append(">").append(name).append("\n");
            sb.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
        System.out.println(outfile.getAbsolutePath());
    }

    private static void combineAndCutSequences(Map<String, String> seq67, Map<String, String> intron6, Map<String, String> intron7, Map<String, String> seq8, Map<String, String> seq678, Map<String, String> pad) {
        for (String name : seq8.keySet()) {
            String intron6seq = GenerateExon678.getSequenceByName(name, intron6);
            String intron7seq = GenerateExon678.getSequenceByName(name, intron7);
            String exon67seq = GenerateExon678.getSequenceByName(name, seq67);
            if (intron6seq == null || intron7seq == null || exon67seq == null) {
                System.out.println("No seq " + name);
                continue;
            }
            String[] items = exon67seq.split("XXXXXXXXXX");
            String exon67seqFull = String.valueOf(items[0].substring(0, items[0].length() - 2)) + intron6seq + items[1].substring(2, items[1].length() - 21);
            String sequence678 = String.valueOf(exon67seqFull) + "XXXXXXXXXX" + intron7seq.substring(intron7seq.length() - 70, intron7seq.length()) + seq8.get(name);
            seq678.put(name, sequence678);
        }
    }

    private static String getSequenceByName(String name, Map<String, String> intron6) {
        if (intron6.containsKey(name)) {
            return intron6.get(name);
        }
        return GenerateExon678.getSeqPadding(name, intron6);
    }

    private static String getSeqPadding(String name, Map<String, String> intron7) {
        String baseName = name.split(":")[0];
        for (String type : intron7.keySet()) {
            if (!type.startsWith(String.valueOf(baseName) + ":")) continue;
            System.out.println(String.valueOf(name) + " " + type);
            return intron7.get(type);
        }
        return null;
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static void outputAmb(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap seqName = new LinkedHashMap();
        for (String name : seq.keySet()) {
            if (!seqName.containsKey(seq.get(name))) {
                seqName.put(seq.get(name), new ArrayList());
            }
            ((List)seqName.get(seq.get(name))).add(name);
        }
        for (String sequence : seqName.keySet()) {
            if (((List)seqName.get(sequence)).size() <= 1) continue;
            sb.append(GenerateExon678.createOutput((List)seqName.get(sequence))).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static String createOutput(List<String> list) {
        String out = String.valueOf(list.get(0)) + "R";
        for (String n : list) {
            out = String.valueOf(out) + "\t" + n;
        }
        return out;
    }
}

