/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ExtractFasta;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class GenerateExon56 {
    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        File output = new File(args[1]);
        String header = args[2];
        File padFile = new File(args[3]);
        File exon6 = new File(input, String.valueOf(header) + "-exon6.fa");
        File intron5 = new File(input, String.valueOf(header) + "-intron5.fa");
        File exon56 = new File(output, String.valueOf(header) + "-bridge56.fa");
        Map<String, String> pad = ExtractFasta.getPadInfo(FileManager.readTextFile(padFile).split("\n"));
        Map<String, String> seq6 = GenerateExon56.getSequences(exon6);
        Map<String, String> intron5seq = GenerateExon56.getSequences(intron5);
        LinkedHashMap<String, String> seq56 = new LinkedHashMap<String, String>();
        GenerateExon56.combineAndCutSequences(seq6, intron5seq, seq56, pad, header);
        GenerateExon56.writeFastaOutput(seq56, exon56);
    }

    private static void writeFastaOutput(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        for (String name : seq.keySet()) {
            sb.append(">").append(name).append("\n");
            sb.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
        System.out.println(outfile.getAbsolutePath());
    }

    private static void combineAndCutSequences(Map<String, String> seq6, Map<String, String> intron5, Map<String, String> seq56, Map<String, String> pad, String header) {
        for (String name : seq6.keySet()) {
            if (intron5.containsKey(name)) {
                seq56.put(name, GenerateExon56.customTrim(intron5.get(name), seq6.get(name), header));
                continue;
            }
            if (pad.containsKey(name)) {
                seq56.put(name, GenerateExon56.customTrim(intron5.get(pad.get(name)), seq6.get(name), header));
                continue;
            }
            seq56.put(name, GenerateExon56.customTrim(GenerateExon56.getIntronPadding(name, intron5), seq6.get(name), header));
        }
    }

    private static String customTrim(String intron5, String exon6, String header) {
        String left = null;
        String right = null;
        if (header.equals("DQB1")) {
            left = intron5.substring(127, 353);
            right = String.valueOf(intron5.substring(intron5.length() - 148, intron5.length())) + exon6;
        } else if (header.equals("DRB1")) {
            left = intron5.substring(15, 238);
            right = String.valueOf(intron5.substring(intron5.length() - 162, intron5.length())) + exon6;
        }
        return String.valueOf(left) + "XXXXXXXXXX" + right;
    }

    private static String getIntronPadding(String name, Map<String, String> intron7) {
        String baseName = name.split(":")[0];
        for (String type : intron7.keySet()) {
            if (!type.startsWith(String.valueOf(baseName) + ":")) continue;
            System.out.println(String.valueOf(name) + " " + type);
            return intron7.get(type);
        }
        String newBaseName = baseName.substring(0, baseName.length() - 1);
        for (String type : intron7.keySet()) {
            if (!type.startsWith(newBaseName) || type.split(":")[0].length() != baseName.length()) continue;
            System.out.println(String.valueOf(name) + " " + type);
            return intron7.get(type);
        }
        Iterator<String> iterator = intron7.keySet().iterator();
        if (iterator.hasNext()) {
            String type;
            type = iterator.next();
            System.out.println(String.valueOf(name) + " " + type);
            return intron7.get(type);
        }
        System.out.println("????????? " + name);
        return null;
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static void outputAmb(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap seqName = new LinkedHashMap();
        for (String name : seq.keySet()) {
            if (!seqName.containsKey(seq.get(name))) {
                seqName.put(seq.get(name), new ArrayList());
            }
            ((List)seqName.get(seq.get(name))).add(name);
        }
        for (String sequence : seqName.keySet()) {
            if (((List)seqName.get(sequence)).size() <= 1) continue;
            sb.append(GenerateExon56.createOutput((List)seqName.get(sequence))).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static String createOutput(List<String> list) {
        String out = String.valueOf(list.get(0)) + "R";
        for (String n : list) {
            out = String.valueOf(out) + "\t" + n;
        }
        return out;
    }
}

