/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class GenerateCIbridge45separate {
    public static void main(String[] args) throws Exception {
        File input1 = new File(args[0]);
        File input2 = new File(args[1]);
        File output = new File(args[2]);
        String header = args[3];
        File exon5 = new File(input1, "ABC-exon5.fa");
        File exon4a = new File(input2, String.valueOf(header) + "-exon4.fa");
        File bridge45 = new File(output, String.valueOf(header) + "-bridge45.fa");
        File bridge45amb = new File(output, String.valueOf(header) + "-bridge45-hap-amb.txt");
        Map<String, String> seq5 = GenerateCIbridge45separate.getSequences(exon5);
        Map<String, String> seq4a = GenerateCIbridge45separate.getSequences(exon4a);
        LinkedHashMap<String, String> bridgeSeq45 = new LinkedHashMap<String, String>();
        GenerateCIbridge45separate.combineAndCutSequences(seq5, seq4a, bridgeSeq45);
        GenerateCIbridge45separate.outputAmb(bridgeSeq45, bridge45amb);
        GenerateCIbridge45separate.writeFastaOutput(bridgeSeq45, bridge45);
    }

    private static void writeFastaOutput(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        for (String name : seq.keySet()) {
            sb.append(">").append(name).append("\n");
            sb.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static void combineAndCutSequences(Map<String, String> seq5, Map<String, String> seq4a, Map<String, String> bridgeSeq45) {
        for (String name : seq5.keySet()) {
            if (name.indexOf("sudo") > 0) continue;
            String seq = null;
            if (seq4a.containsKey(name)) {
                seq = seq4a.get(name);
            }
            if (seq == null) continue;
            if (name.startsWith("B") || name.startsWith("C")) {
                bridgeSeq45.put(name, String.valueOf(seq.substring(seq.length() - 62)) + "XXXXXXXXXX" + seq5.get(name));
                continue;
            }
            bridgeSeq45.put(name, String.valueOf(seq.substring(seq.length() - 48)) + "XXXXXXXXXX" + seq5.get(name));
        }
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static void outputAmb(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap seqName = new LinkedHashMap();
        for (String name : seq.keySet()) {
            if (!seqName.containsKey(seq.get(name))) {
                seqName.put(seq.get(name), new ArrayList());
            }
            ((List)seqName.get(seq.get(name))).add(name);
        }
        for (String sequence : seqName.keySet()) {
            if (((List)seqName.get(sequence)).size() <= 1) continue;
            sb.append(GenerateCIbridge45separate.createOutput((List)seqName.get(sequence))).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static String createOutput(List<String> list) {
        String out = String.valueOf(list.get(0)) + "R";
        for (String n : list) {
            out = String.valueOf(out) + "\t" + n;
        }
        return out;
    }
}

