/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class GenerateCIbridge12 {
    public static void main(String[] args) throws Exception {
        File input1 = new File(args[0]);
        File input2 = new File(args[1]);
        File output = new File(args[2]);
        String header = args[3];
        File exon1 = new File(input1, String.valueOf(header) + "-exon1.fa");
        File exon2a = new File(input2, "A-exon2.fa");
        File exon2b = new File(input2, "B-exon2.fa");
        File exon2c = new File(input2, "C-exon2.fa");
        File bridge12 = new File(output, String.valueOf(header) + "-bridge12.fa");
        File bridge12amb = new File(output, String.valueOf(header) + "-bridge12-hap-amb.txt");
        Map<String, String> seq1 = GenerateCIbridge12.getSequences(exon1);
        Map<String, String> seq2a = GenerateCIbridge12.getSequences(exon2a);
        Map<String, String> seq2b = GenerateCIbridge12.getSequences(exon2b);
        Map<String, String> seq2c = GenerateCIbridge12.getSequences(exon2c);
        LinkedHashMap<String, String> bridgeSeq12 = new LinkedHashMap<String, String>();
        GenerateCIbridge12.combineAndCutSequences(seq1, seq2a, seq2b, seq2c, bridgeSeq12);
        GenerateCIbridge12.outputAmb(bridgeSeq12, bridge12amb);
        GenerateCIbridge12.writeFastaOutput(bridgeSeq12, bridge12);
    }

    private static void writeFastaOutput(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        for (String name : seq.keySet()) {
            sb.append(">").append(name).append("\n");
            sb.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static void combineAndCutSequences(Map<String, String> seq1, Map<String, String> seq2a, Map<String, String> seq2b, Map<String, String> seq2c, Map<String, String> bridgeSeq12) {
        for (String name : seq1.keySet()) {
            if (name.indexOf("sudo") > 0) continue;
            String seq = null;
            if (seq2a.containsKey(name)) {
                seq = seq2a.get(name);
            } else if (seq2b.containsKey(name)) {
                seq = seq2b.get(name);
            } else if (seq2c.containsKey(name)) {
                seq = seq2c.get(name);
            }
            if (seq == null) continue;
            bridgeSeq12.put(name, String.valueOf(seq1.get(name)) + "XXXXXXXXXX" + seq.substring(0, 68));
        }
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static void outputAmb(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap seqName = new LinkedHashMap();
        for (String name : seq.keySet()) {
            if (!seqName.containsKey(seq.get(name))) {
                seqName.put(seq.get(name), new ArrayList());
            }
            ((List)seqName.get(seq.get(name))).add(name);
        }
        for (String sequence : seqName.keySet()) {
            if (((List)seqName.get(sequence)).size() <= 1) continue;
            sb.append(GenerateCIbridge12.createOutput((List)seqName.get(sequence))).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static String createOutput(List<String> list) {
        String out = String.valueOf(list.get(0)) + "R";
        for (String n : list) {
            out = String.valueOf(out) + "\t" + n;
        }
        return out;
    }
}

