/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import misc.FileManager;

public class FastaToFastq {
    static String PREFIX = "@M00474:181:000000000-BN7T9:";
    static String TAIL = ":N:0:111";
    static int LENGTH = 301;

    public static void main(String[] args) throws Exception {
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        File[] files = inputDir.listFiles();
        String qualityString = FastaToFastq.makeQstring();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.getName().endsWith(".fa")) {
                System.out.println("Skip " + file.getName());
            } else {
                String sampleName = FastaToFastq.extractName(file.getName());
                File r1File = new File(outputDir, String.valueOf(sampleName) + "_L001_R1_001.fastq");
                File r2File = new File(outputDir, String.valueOf(sampleName) + "_L001_R2_001.fastq");
                String[] in = FileManager.readTextFile(file).split("\n");
                StringBuilder r1 = new StringBuilder();
                StringBuilder r2 = new StringBuilder();
                String baseName = null;
                int i = 0;
                while (i < in.length) {
                    if (i % 4 == 0) {
                        baseName = FastaToFastq.getBaseName(in[i].trim());
                        r1.append(PREFIX).append(baseName).append(" 1").append(TAIL).append("\n");
                    } else if (i % 4 == 1) {
                        r1.append(in[i].trim()).append("\n");
                        r1.append("+").append("\n");
                        r1.append(qualityString).append("\n");
                    } else if (i % 4 == 2) {
                        r2.append(PREFIX).append(baseName).append(" 2").append(TAIL).append("\n");
                    } else if (i % 4 == 3) {
                        r2.append(in[i].trim()).append("\n");
                        r2.append("+").append("\n");
                        r2.append(qualityString).append("\n");
                    }
                    ++i;
                }
                FileManager.writeTextFile(r1File, r1.toString(), true);
                FileManager.writeTextFile(r2File, r2.toString(), true);
            }
            ++n2;
        }
    }

    private static String makeQstring() {
        return "AAAAAFBCCCBBGGGGGGGGGGGHGGGGGGGGGGHHHHHHHGHHHHFGGHHGHGHGGGEFEFEGGGGHHHFHGHGCGGCGHEGFFHGFEGFGEGCGGGHHHHEHGDEHGHHHHHHHHHFADFGCGFFDEHHGGHEGGGGGCEEFCAD-A?BGGAGA;FFFFFFAAFFA@D?BDCFFFFFFFFFFFACDFFFFFFFCCFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFF";
    }

    private static String getBaseName(String line) {
        return line.substring(8, line.length() - 2);
    }

    private static String extractName(String name) {
        return name.replaceAll("_R1.fa", "");
    }
}

