/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.LocusExon;
import fileOperation.LocusExonResult;
import fileOperation.MatchStatistics;
import fileOperation.ParseFastaByHapType7;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class ExtractTypingResult {
    static String DQA2 = "DQA2";
    static String DQB2 = "DQB2";
    static String EXON2 = "exon2";
    static String EXON3 = "exon3";
    static String DQA1 = "DQA1";
    static String DQB1 = "DQB1";
    static String HAP_AMB_TXT = "-hap-amb.txt";
    static String NO_RESULT = "No Result";
    static int MIN_SUPPORT_READS = 20;

    public static void main(String[] args) throws Exception {
        File detailedResultFile = new File(args[0]);
        File hapTypeRoot = new File(args[1]);
        File output = new File(args[2]);
        String[] detailedResult = FileManager.readTextFile(detailedResultFile).split("\n");
        Map<String, List<LocusExon>> allLocus = ExtractTypingResult.initLocusMap();
        HashMap summaryMap = new HashMap();
        HashMap detailMap = new HashMap();
        StringBuilder builder = new StringBuilder();
        builder.append("Sample").append(",").append("locus").append(",").append("Type1").append(",").append("#Pairs Support Match").append(",").append("#Positions w >=10x Coverage").append("\n");
        for (String locus : allLocus.keySet()) {
            System.out.println("memory usage 0: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
            System.out.println("--------------process " + locus);
            summaryMap.put(locus, new HashMap());
            detailMap.put(locus, new HashMap());
            List<LocusExon> locusExons = allLocus.get(locus);
            LocusExon majorExon = locusExons.get(0);
            LocusExon minorExon = locusExons.size() > 1 ? locusExons.get(1) : null;
            String representString1 = String.valueOf(locus) + "-" + majorExon.getExon();
            File hapTypeFile1 = new File(hapTypeRoot, String.valueOf(representString1) + ".fa");
            File hapAmbFile1 = new File(hapTypeRoot, String.valueOf(hapTypeFile1.getName().substring(0, hapTypeFile1.getName().length() - 3)) + HAP_AMB_TXT);
            Map<String, Map<String, MatchStatistics>> allMajorResult = ExtractTypingResult.extractForLocusExon(detailedResult, representString1, (Map)detailMap.get(locus));
            if (allMajorResult.size() == 0) continue;
            ExtractTypingResult.analyzeResult(allMajorResult, hapTypeFile1, hapAmbFile1, majorExon, (Map)detailMap.get(locus), representString1, builder);
            if (minorExon == null) continue;
            String representString2 = String.valueOf(locus) + "-" + minorExon.getExon();
            File hapTypeFile2 = new File(hapTypeRoot, String.valueOf(representString2) + ".fa");
            File hapAmbFile2 = new File(hapTypeRoot, String.valueOf(hapTypeFile2.getName().substring(0, hapTypeFile1.getName().length() - 3)) + HAP_AMB_TXT);
            Map<String, Map<String, MatchStatistics>> allMinorResult = ExtractTypingResult.extractForLocusExon(detailedResult, representString2, (Map)detailMap.get(locus));
            if (allMinorResult.size() == 0) continue;
            ExtractTypingResult.analyzeResult(allMinorResult, hapTypeFile2, hapAmbFile2, minorExon, (Map)detailMap.get(locus), representString2, builder);
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static Map<String, Map<String, MatchStatistics>> extractForLocusExon(String[] detailedResult, String representString, Map<String, Map<String, List<String>>> details) {
        LinkedHashMap<String, Map<String, MatchStatistics>> allMajorResult = new LinkedHashMap<String, Map<String, MatchStatistics>>();
        int i = 0;
        while (i < detailedResult.length) {
            String line = detailedResult[i];
            if (line.indexOf(representString) > 0) {
                String[] items = line.split("\\s+");
                String sampleName = items[0].trim();
                if (!allMajorResult.containsKey(sampleName)) {
                    allMajorResult.put(sampleName, new LinkedHashMap());
                    if (!details.containsKey(sampleName)) {
                        details.put(sampleName, new HashMap());
                    }
                    details.get(sampleName).put(representString, ExtractTypingResult.getDetailedResult(detailedResult, i, sampleName, representString));
                }
                if (line.indexOf(NO_RESULT) < 0 && items.length >= 8) {
                    ((Map)allMajorResult.get(sampleName)).put(items[2].trim(), ExtractTypingResult.parseStatistices(items, detailedResult, i));
                }
            }
            ++i;
        }
        return allMajorResult;
    }

    private static List<String> getDetailedResult(String[] detailedResult, int index, String sampleName, String representString) {
        ArrayList<String> results = new ArrayList<String>();
        int i = index;
        while (i < detailedResult.length) {
            String line = detailedResult[i].trim();
            if (line.indexOf(NO_RESULT) > 0) {
                results.add(line);
                return results;
            }
            String[] entries = line.split("\t");
            if (entries.length >= 8 && entries[0].trim().equals(sampleName) && entries[1].trim().indexOf(representString) >= 0) {
                results.add(line);
            } else if (line.indexOf("usedTotaldata") >= 0) {
                results.add(line);
            } else if (entries.length == 2) {
                results.add(line);
            } else if (line.length() == 0) {
                results.add(line);
            } else {
                if (!(entries.length < 8 || entries[0].trim().equals(sampleName) && entries[1].trim().indexOf(representString) >= 0)) {
                    return results;
                }
                System.out.println("don't know what is it!!! " + line);
            }
            ++i;
        }
        return results;
    }

    public static Map<String, String> organizeSequenceFromFasta(Map<String, String> hapAmbNames, File fastaFile) throws Exception {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        ArrayList<String> existAmbTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (!hapAmbNames.containsKey(name)) {
                    sequences.put(name, sequence);
                } else {
                    String gname = hapAmbNames.get(name);
                    if (!existAmbTypes.contains(gname)) {
                        sequences.put(gname, sequence);
                        existAmbTypes.add(gname);
                    }
                }
            }
            ++i;
        }
        return sequences;
    }

    private static void analyzeResult(Map<String, Map<String, MatchStatistics>> allResult, File hapTypeFile, File hapAmbFile, LocusExon locusExon, Map<String, Map<String, List<String>>> detail, String representString, StringBuilder builder) throws Exception {
        HashMap<String, String> hapNames = new HashMap<String, String>();
        if (hapAmbFile.exists()) {
            ParseFastaByHapType7.populateHapAmbNames(hapNames, hapAmbFile);
        }
        for (String sample : allResult.keySet()) {
            System.out.println("--------------" + sample);
            Map<String, MatchStatistics> matches = allResult.get(sample);
            Map<String, MatchStatistics> perfectMatches = ExtractTypingResult.filterForGoodMatches(matches, locusExon);
            ExtractTypingResult.setResult(perfectMatches, builder, sample, hapTypeFile);
        }
    }

    private static void setResult(Map<String, MatchStatistics> perfectMatches, StringBuilder builder, String sample, File hapTypeFile) {
        builder.append(sample).append(",").append(hapTypeFile.getName()).append(",");
        for (String type : perfectMatches.keySet()) {
            builder.append(type).append(",").append(perfectMatches.get(type).getNumPairsSupport()).append(",").append(perfectMatches.get(type).getNumPosGoodCoverage()).append("/").append(perfectMatches.get(type).getExonSize()).append(",");
        }
        builder.append("\n");
    }

    private static void setCanadidateResult(Map<String, MatchStatistics> matches, LocusExon locusExon, LocusExonResult sampleExonResult) {
        List<String> otherTypeNames = locusExon.getOtherTypeNames();
        for (String type : matches.keySet()) {
            if (otherTypeNames.contains(type.split("\\*")[0])) {
                sampleExonResult.addOtherCandidateTypes(type);
                continue;
            }
            sampleExonResult.addCandidateTypes(type);
        }
    }

    private static String rankByTotal(List<String> bestTypes, Map<String, MatchStatistics> mainMatches) {
        int max = 0;
        String btype = null;
        for (String type : bestTypes) {
            int total = mainMatches.get(type).getNumPairsSupportExonA() + mainMatches.get(type).getNumPairsSupportExonB();
            if (max == 0) {
                btype = type;
                max = total;
                continue;
            }
            if (total <= max) continue;
            max = total;
            btype = type;
        }
        return btype;
    }

    private static void separateMatches(Map<String, MatchStatistics> mainMatchesA, Map<String, MatchStatistics> mainMatchesB, Map<String, MatchStatistics> mainMatches) {
        String group = null;
        for (String type : mainMatches.keySet()) {
            if (group == null) {
                group = ExtractTypingResult.extractMainTypeString(type);
                mainMatchesA.put(type, mainMatches.get(type));
                continue;
            }
            if (!group.equals(ExtractTypingResult.extractMainTypeString(type))) {
                mainMatchesB.put(type, mainMatches.get(type));
                continue;
            }
            mainMatchesA.put(type, mainMatches.get(type));
        }
    }

    private static Map<String, MatchStatistics> filterMatches(Map<String, MatchStatistics> inputMatches) {
        int max1 = 0;
        int max2 = 0;
        for (MatchStatistics matchStatistics : inputMatches.values()) {
            if (matchStatistics.getNumPairsSupportExonA() > max1) {
                max1 = matchStatistics.getNumPairsSupportExonA();
            }
            if (matchStatistics.getNumPairsSupportExonB() <= max2) continue;
            max2 = matchStatistics.getNumPairsSupportExonB();
        }
        Map<String, MatchStatistics> mainMatches = new LinkedHashMap<String, MatchStatistics>();
        int i = 0;
        while (i < 8) {
            mainMatches = ExtractTypingResult.getMatches(inputMatches, i, max1, max2);
            if (ExtractTypingResult.findMultiGroup(mainMatches)) break;
            ++i;
        }
        if (!ExtractTypingResult.findMultiGroup(mainMatches)) {
            mainMatches = ExtractTypingResult.getMatches(inputMatches, 0, max1, max2);
        }
        if (mainMatches.size() == 0) {
            mainMatches = ExtractTypingResult.getBestMatches(inputMatches, max1, max2);
        }
        return mainMatches;
    }

    private static Map<String, MatchStatistics> getBestMatches(Map<String, MatchStatistics> inputMatches, int max1, int max2) {
        LinkedHashMap<String, MatchStatistics> matches = new LinkedHashMap<String, MatchStatistics>();
        boolean foundA = false;
        boolean foundB = false;
        for (String type : inputMatches.keySet()) {
            if (inputMatches.get(type).getNumPairsSupportExonA() == max1 && !foundA) {
                foundA = true;
                matches.put(type, inputMatches.get(type));
            }
            if (inputMatches.get(type).getNumPairsSupportExonB() != max2 || foundB) continue;
            foundB = true;
            matches.put(type, inputMatches.get(type));
        }
        return matches;
    }

    private static Map<String, MatchStatistics> getMatches(Map<String, MatchStatistics> inputMatches, int i, int max1, int max2) {
        LinkedHashMap<String, MatchStatistics> matches = new LinkedHashMap<String, MatchStatistics>();
        for (String type : inputMatches.keySet()) {
            if (!((double)inputMatches.get(type).getNumPairsSupportExonA() * ((double)i + 2.25) > (double)max1) || !((double)inputMatches.get(type).getNumPairsSupportExonB() * ((double)i + 2.25) > (double)max2)) continue;
            matches.put(type, inputMatches.get(type));
        }
        return matches;
    }

    private static boolean findMultiGroup(Map<String, MatchStatistics> mainMatches) {
        String group = null;
        for (String type : mainMatches.keySet()) {
            if (group == null) {
                group = ExtractTypingResult.extractMainTypeString(type);
                continue;
            }
            if (group.equals(ExtractTypingResult.extractMainTypeString(type))) continue;
            System.out.println(">>>>>>>>find " + group + " " + ExtractTypingResult.extractMainTypeString(type));
            return true;
        }
        return false;
    }

    private static String extractMainTypeString(String type) {
        return type.split("\\*")[1].split(":")[0];
    }

    private static int getMaxBridgeCount(Map<String, MatchStatistics> mainMatches) {
        int max = 0;
        for (String type : mainMatches.keySet()) {
            MatchStatistics matchStatistics = mainMatches.get(type);
            if (matchStatistics.getBridgeCount() <= max) continue;
            max = matchStatistics.getBridgeCount();
        }
        return max;
    }

    private static void addBeggingLog(LocusExonResult sampleExonResult, String msg) {
        if (sampleExonResult.getLog() == null) {
            sampleExonResult.setLog(msg);
        } else {
            sampleExonResult.setLog(String.valueOf(msg) + "," + sampleExonResult.getLog());
        }
    }

    private static boolean isDRB5groupTypes(String type) {
        return type.indexOf("DRB1*15") >= 0 || type.indexOf("DRB1*16") >= 0;
    }

    private static boolean isDRB4groupTypes(String type) {
        return type.indexOf("DRB1*04") >= 0 || type.indexOf("DRB1*07") >= 0 || type.indexOf("DRB1*09") >= 0;
    }

    private static boolean isDRB3groupTypes(String type) {
        return type.indexOf("DRB1*03") >= 0 || type.indexOf("DRB1*11") >= 0 || type.indexOf("DRB1*12") >= 0 || type.indexOf("DRB1*13") >= 0 || type.indexOf("DRB1*14") >= 0;
    }

    private static boolean checkDropOff(String type, MatchStatistics matchStatistics, LocusExonResult sampleExonResult) {
        if (matchStatistics.isDropOff()) {
            ExtractTypingResult.addToLog(sampleExonResult, String.valueOf(type) + " allele Drop Off");
            return true;
        }
        return false;
    }

    private static boolean secondTypeFromRecombination(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult, Map<String, String> sequences, LocusExon locusExon, Map<String, MatchStatistics> perfectMatches) {
        StringBuilder homoLog;
        boolean isValidatedAsHomo;
        String type1 = null;
        String type2 = null;
        for (String type : mainMatches.keySet()) {
            if (type1 == null) {
                type1 = type;
                continue;
            }
            if (type2 != null) continue;
            type2 = type;
        }
        LinkedHashMap<String, Map<Integer, String>> discrepancyPositions = new LinkedHashMap<String, Map<Integer, String>>();
        discrepancyPositions.put(type2, ExtractTypingResult.getDiscrepancies(type2, type1, perfectMatches));
        ArrayList<String> allOtherTypes = new ArrayList<String>();
        if (sampleExonResult.getOtherTypes() != null && sampleExonResult.getOtherTypes().length() > 0) {
            String[] otherTypes;
            String[] stringArray = otherTypes = sampleExonResult.getOtherTypes().split(",");
            int n = otherTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String otherType = stringArray[n2];
                allOtherTypes.add(otherType);
                discrepancyPositions.put(otherType, ExtractTypingResult.getDiscrepancies(otherType, type1, perfectMatches));
                ++n2;
            }
        }
        if ((float)mainMatches.get(type2).getNumPairsSupport() < (float)mainMatches.get(type1).getNumPairsSupport() * 0.55f && (isValidatedAsHomo = ExtractTypingResult.recombineHomoValidation(mainMatches, sampleExonResult, type1, discrepancyPositions, allOtherTypes, homoLog = new StringBuilder()))) {
            System.out.println("find homo sample result " + type1 + " not using---- " + type2);
            sampleExonResult.setFirm(true);
            ExtractTypingResult.addToLog(sampleExonResult, homoLog.toString());
            return true;
        }
        return false;
    }

    private static boolean checkOtherAlleleExist(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult, Map<String, String> sequences, LocusExon locusExon, String homoType, boolean isHomoCheck) {
        LinkedHashMap<String, Map<Integer, String>> discrepancyPositions = new LinkedHashMap<String, Map<Integer, String>>();
        for (String type : mainMatches.keySet()) {
            if (type.equals(homoType)) continue;
            discrepancyPositions.put(type, ExtractTypingResult.getDiscrepancies(type, homoType, mainMatches));
        }
        ArrayList<String> allOtherTypes = new ArrayList<String>();
        if (sampleExonResult.getOtherTypes() != null && sampleExonResult.getOtherTypes().length() > 0) {
            String[] otherTypes;
            String[] stringArray = otherTypes = sampleExonResult.getOtherTypes().split(",");
            int n = otherTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String otherType = stringArray[n2];
                allOtherTypes.add(otherType);
                discrepancyPositions.put(otherType, ExtractTypingResult.getDiscrepancies(otherType, homoType, mainMatches));
                ++n2;
            }
        }
        for (String type : discrepancyPositions.keySet()) {
            if (type.equals(homoType) || allOtherTypes.contains(type) || ExtractTypingResult.isOtherType(locusExon, type) || ExtractTypingResult.isSubsetType(type, homoType, allOtherTypes, discrepancyPositions, mainMatches.get(type))) continue;
            if (isHomoCheck) {
                sampleExonResult.setType2(type);
                ExtractTypingResult.addToLog(sampleExonResult, String.valueOf(type) + " not fully covered");
            } else {
                ExtractTypingResult.addToLog(sampleExonResult, String.valueOf(type) + "(unique)");
            }
            return true;
        }
        return false;
    }

    private static boolean isOtherType(LocusExon locusExon, String type) {
        List<String> otherTypeNames = locusExon.getOtherTypeNames();
        return otherTypeNames.contains(type.split("\\*")[0]);
    }

    private static boolean isSubsetType(String type, String homoType, List<String> allOtherTypes, Map<String, Map<Integer, String>> discrepancyPositions, MatchStatistics matchStatistics) {
        Map<Integer, String> discrepencies = discrepancyPositions.get(type);
        for (Integer pos : discrepencies.keySet()) {
            if (ExtractTypingResult.isQuestionPos(pos, matchStatistics.getQuestionPos()) || matchStatistics.getCoverageString().length() <= pos || ExtractTypingResult.isWeakPosition(String.valueOf(matchStatistics.getCoverageString().charAt(pos))) || discrepencies.get(pos).equalsIgnoreCase("*")) continue;
            boolean isOK = false;
            for (String otherType : allOtherTypes) {
                Map<Integer, String> otherDiscrepencies = discrepancyPositions.get(otherType);
                if (!otherDiscrepencies.containsKey(pos) || !discrepencies.get(pos).equals(otherDiscrepencies.get(pos))) continue;
                isOK = true;
            }
            if (isOK) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllGoodPos(MatchStatistics matchStatistics) {
        String coverageString = matchStatistics.getCoverageString();
        int i = 0;
        while (i < coverageString.length()) {
            String coverage = String.valueOf(matchStatistics.getCoverageString().charAt(i));
            if (!coverage.equals(".") && Integer.valueOf(coverage) < 3) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getBestDropOffType(String type1, Map<String, MatchStatistics> mainMatches) {
        ArrayList<String> allDropOffTypes = new ArrayList<String>();
        for (String name : mainMatches.keySet()) {
            if (name.equals(type1) || !mainMatches.get(name).isDropOff() || mainMatches.get(name).getDropOffCount() * 3 <= mainMatches.get(type1).getNumPairsSupport()) continue;
            allDropOffTypes.add(name);
        }
        String bestType = null;
        for (String type : allDropOffTypes) {
            if (bestType == null) {
                bestType = type;
                continue;
            }
            if (mainMatches.get(type).getQuestionPos().size() >= mainMatches.get(bestType).getQuestionPos().size()) continue;
            bestType = type;
        }
        return bestType;
    }

    private static boolean recombineHomoValidation(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult, String type1, Map<String, Map<Integer, String>> discrepancyPositions, List<String> allOtherTypes, StringBuilder log) {
        boolean isAllValidated = true;
        for (String type : discrepancyPositions.keySet()) {
            if (allOtherTypes.contains(type)) continue;
            if (ExtractTypingResult.isRecombinedFromOtherTypes(type, type1, null, allOtherTypes, discrepancyPositions, mainMatches.get(type))) {
                log.append(",").append(String.valueOf(type) + "(T)");
                continue;
            }
            log.append(",").append(String.valueOf(type) + "(F)");
            isAllValidated = false;
        }
        sampleExonResult.setType1(type1);
        sampleExonResult.setType2(type1);
        return isAllValidated;
    }

    private static String getNextType(Map<String, Map<Integer, String>> discrepancyPositions, Map<String, MatchStatistics> mainMatches, int topPopulation, List<String> excludingTypes, List<String> allOtherTypes, int roundNum) {
        String type2;
        if (roundNum == 0) {
            for (String type2 : discrepancyPositions.keySet()) {
                if (excludingTypes.contains(type2) || allOtherTypes.contains(type2) || mainMatches.get(type2).getNumPairsSupport() <= topPopulation) continue;
                return type2;
            }
        }
        Iterator<String> iterator = discrepancyPositions.keySet().iterator();
        while (iterator.hasNext()) {
            type2 = iterator.next();
            if (excludingTypes.contains(type2) || allOtherTypes.contains(type2) || !((float)mainMatches.get(type2).getNumPairsSupport() > (float)topPopulation * 0.4f) && (!((float)mainMatches.get(type2).getNumPairsSupport() > (float)topPopulation * 0.25f) || mainMatches.get(type2).getQuestionPos().size() != 0)) continue;
            return type2;
        }
        if (roundNum == 0 && (iterator = discrepancyPositions.keySet().iterator()).hasNext()) {
            type2 = iterator.next();
            return type2;
        }
        return null;
    }

    private static boolean isRecombinedFromOtherTypes(String type, String type1, String type2, List<String> allOtherTypes, Map<String, Map<Integer, String>> discrepancyPositions, MatchStatistics matchStatistics) {
        if (allOtherTypes.size() == 0) {
            return false;
        }
        for (String otherType : allOtherTypes) {
            if (!ExtractTypingResult.isRecombined(type, type1, otherType, discrepancyPositions, matchStatistics) && (type2 == null || !ExtractTypingResult.isRecombined(type, type2, otherType, discrepancyPositions, matchStatistics))) continue;
            System.out.println("find recombine " + type + " from " + otherType);
            return true;
        }
        return false;
    }

    private static boolean isRecombined(String type, String type1, String type2, Map<String, Map<Integer, String>> discrepancyPositions, MatchStatistics matchStatistics) {
        Map<Integer, String> discrepencies = discrepancyPositions.get(type);
        Map<Integer, String> discrepencies1 = discrepancyPositions.get(type1);
        Map<Integer, String> discrepencies2 = discrepancyPositions.get(type2);
        for (Integer pos : discrepencies.keySet()) {
            if (ExtractTypingResult.isQuestionPos(pos, matchStatistics.getQuestionPos()) || ExtractTypingResult.isWeakPosition(String.valueOf(matchStatistics.getCoverageString().charAt(pos))) || discrepencies2.containsKey(pos) && discrepencies.get(pos).equals(discrepencies2.get(pos)) || (discrepencies1 == null || discrepencies1.containsKey(pos) && discrepencies.get(pos).equals(discrepencies1.get(pos))) && discrepencies1 != null) continue;
            return false;
        }
        return true;
    }

    private static boolean isWeakPosition(String coverage) {
        return coverage.equals(" ") || coverage.equals(".") || Integer.valueOf(coverage) < 2;
    }

    private static boolean isQuestionPos(Integer pos, List<Integer> questionPos) {
        return questionPos.contains(pos);
    }

    private static String getFurtherestDistanceType(Map<String, Map<Integer, String>> discrepancyPositions, Map<String, MatchStatistics> mainMatches, int topPopulation) {
        String hypType = null;
        int maxCount = 0;
        for (String type : discrepancyPositions.keySet()) {
            if (mainMatches.get(type).getNumPairsSupport() >= topPopulation) {
                return type;
            }
            if (!((float)mainMatches.get(type).getNumPairsSupport() > (float)topPopulation * 0.4f) && (!((float)mainMatches.get(type).getNumPairsSupport() > (float)topPopulation * 0.25f) || mainMatches.get(type).getQuestionPos().size() != 0) || discrepancyPositions.get(type).size() <= maxCount) continue;
            hypType = type;
            maxCount = discrepancyPositions.get(type).size();
        }
        if (hypType == null) {
            for (String type : discrepancyPositions.keySet()) {
                if (hypType != null) continue;
                return type;
            }
        }
        return hypType;
    }

    private static Map<Integer, String> getDiscrepancies(String query, String target, Map<String, MatchStatistics> mainMatches) {
        LinkedHashMap<Integer, String> positions = new LinkedHashMap<Integer, String>();
        String querySeq = mainMatches.get(query).getAlignmentString();
        String targetSeq = mainMatches.get(target).getAlignmentString();
        int i = 0;
        while (i < Math.min(targetSeq.length(), querySeq.length())) {
            if (querySeq.charAt(i) != targetSeq.charAt(i)) {
                positions.put(i, String.valueOf(querySeq.charAt(i)));
            }
            ++i;
        }
        return positions;
    }

    private static boolean checkQuestionPosition(String type, MatchStatistics matchStatistics, LocusExon locusExon, LocusExonResult sampleExonResult, boolean isOtherType) {
        if (matchStatistics == null) {
            return true;
        }
        if (matchStatistics.getQuestionPos().size() > 0 && !ExtractTypingResult.questionPositionOK(matchStatistics.getQuestionPos(), locusExon.getIgnoredPrimerDiffPositions())) {
            if (isOtherType) {
                ExtractTypingResult.addToOtherLog(sampleExonResult, String.valueOf(type) + " question position " + matchStatistics.formatQuestionPostion(matchStatistics.getQuestionPos()));
            } else {
                ExtractTypingResult.addToLog(sampleExonResult, String.valueOf(type) + " question position " + matchStatistics.formatQuestionPostion(matchStatistics.getQuestionPos()));
            }
            return true;
        }
        return false;
    }

    private static void generateHeterResult(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult) {
        for (String type : mainMatches.keySet()) {
            if (sampleExonResult.getType1() == null) {
                sampleExonResult.setType1(type);
                continue;
            }
            if (sampleExonResult.getType2() != null) continue;
            sampleExonResult.setType2(type);
        }
    }

    private static boolean isDQAexon2DiffGroups(String type1, String type2, LocusExon locusExon) {
        if (locusExon.getLocus().equals("DQA1") && locusExon.equals("exon2")) {
            if (ParseFastaByHapType7.isSpecialDQA1exon2Type(type1) && !ParseFastaByHapType7.isSpecialDQA1exon2Type(type2)) {
                return true;
            }
            if (!ParseFastaByHapType7.isSpecialDQA1exon2Type(type1) && ParseFastaByHapType7.isSpecialDQA1exon2Type(type2)) {
                return true;
            }
        }
        return false;
    }

    private static void generateHomoResult(Map<String, MatchStatistics> mainMatches, LocusExonResult sampleExonResult) {
        for (String type : mainMatches.keySet()) {
            sampleExonResult.setType1(type);
            sampleExonResult.setType2(type);
        }
    }

    private static void addToOtherLog(LocusExonResult sampleExonResult, String msg) {
        if (sampleExonResult.getOtherLog() == null) {
            sampleExonResult.setOtherLog(msg);
        } else {
            sampleExonResult.setOtherLog(String.valueOf(sampleExonResult.getOtherLog()) + "," + msg);
        }
    }

    private static void addToLog(LocusExonResult sampleExonResult, String msg) {
        if (sampleExonResult.getLog() == null) {
            sampleExonResult.setLog(msg);
        } else {
            sampleExonResult.setLog(String.valueOf(sampleExonResult.getLog()) + "," + msg);
        }
    }

    private static Map<String, MatchStatistics> seperateOtherTypes(LocusExon locusExon, LocusExonResult sampleExonResult, Map<String, MatchStatistics> perfectMatches) {
        LinkedHashMap<String, MatchStatistics> mainMatches = new LinkedHashMap<String, MatchStatistics>();
        List<String> otherTypeNames = locusExon.getOtherTypeNames();
        for (String type : perfectMatches.keySet()) {
            if (otherTypeNames.contains(type.split("\\*")[0])) {
                String allOtherTypes = sampleExonResult.getOtherTypes();
                if (allOtherTypes == null || allOtherTypes.length() == 0) {
                    sampleExonResult.setOtherTypes(type);
                    continue;
                }
                sampleExonResult.setOtherTypes(String.valueOf(allOtherTypes) + "," + type);
                continue;
            }
            mainMatches.put(type, perfectMatches.get(type));
        }
        return mainMatches;
    }

    private static Map<String, MatchStatistics> filterForGoodMatches(Map<String, MatchStatistics> matches, LocusExon locusExon) {
        LinkedHashMap<String, MatchStatistics> perfectMatches = new LinkedHashMap<String, MatchStatistics>();
        for (String type : matches.keySet()) {
            MatchStatistics matchStatistics;
            if (type.indexOf("DQA2") < 0 && type.indexOf("DQB2") < 0 || !ExtractTypingResult.withGoodNumber(matchStatistics = matches.get(type), locusExon) || !ExtractTypingResult.isGoodMatch(matchStatistics, locusExon)) continue;
            perfectMatches.put(type, matchStatistics);
        }
        if (perfectMatches.size() == 0) {
            int count = 0;
            for (String type : matches.keySet()) {
                MatchStatistics matchStatistics;
                if (type.indexOf("DQA2") < 0 && type.indexOf("DQB2") < 0 || !ExtractTypingResult.withGoodNumber(matchStatistics = matches.get(type), locusExon)) continue;
                perfectMatches.put(type, matchStatistics);
                if (++count >= 2) break;
            }
        }
        return perfectMatches;
    }

    private static boolean withGoodNumber(MatchStatistics matchStatistics, LocusExon locusExon) {
        return matchStatistics.getNumPairsSupport() >= MIN_SUPPORT_READS;
    }

    private static boolean isGoodMatch(MatchStatistics matchStatistics, LocusExon locusExon) {
        return matchStatistics.getExonSize() == matchStatistics.getNumPosGoodCoverage();
    }

    private static boolean questionPositionOK(List<Integer> questionPositions, List<Integer> ignoredPrimerDiffPositions) {
        for (Integer pos : questionPositions) {
            if (ignoredPrimerDiffPositions.contains(pos)) continue;
            return false;
        }
        return true;
    }

    private static MatchStatistics parseStatistices(String[] items, String[] detailedResult, int lineCount) {
        MatchStatistics matchStatistics = new MatchStatistics();
        if (items[3].indexOf("/") > 0) {
            String[] nums = items[3].trim().split("/");
            int numa = new Integer(nums[0]);
            int numb = new Integer(nums[1]);
            matchStatistics.setNumPairsSupport(numa + numb);
            matchStatistics.setNumPairsSupportExonA(numa);
            matchStatistics.setNumPairsSupportExonB(numb);
        } else {
            matchStatistics.setNumPairsSupport(new Integer(items[3].trim()));
        }
        matchStatistics.setNumPairsPerfect(new Integer(items[4].split("\\.")[0].trim()));
        matchStatistics.setNumPosGoodCoverage(new Integer(items[5].trim().split("/")[0]));
        matchStatistics.setExonSize(new Integer(items[5].trim().split("/")[1]));
        matchStatistics.setQuestionPos(ExtractTypingResult.parsePositions(items[6].trim()));
        if (items[7].indexOf("/") > 0) {
            String[] uniques = items[7].trim().split("/");
            matchStatistics.setNumPairsUniqueExonA(new Integer(uniques[0].trim()));
            matchStatistics.setNumPairsUniqueExonB(new Integer(uniques[1].trim()));
        } else {
            matchStatistics.setNumPairsUnique(new Integer(items[7].trim()));
        }
        matchStatistics.setBridgeCount(new Integer(items[8].trim()));
        int i = lineCount + 1;
        while (i < detailedResult.length) {
            String[] entries = detailedResult[i].split("\t");
            if (entries.length > 1 && entries[0].trim().equals(items[2].trim()) && ExtractTypingResult.isCoverage(entries[1].trim().charAt(0))) {
                matchStatistics.setCoverageString(entries[1]);
                break;
            }
            ++i;
        }
        i = lineCount + 1;
        while (i < detailedResult.length) {
            String[] entries = detailedResult[i].split("\t");
            if (entries.length > 1 && entries[0].trim().equals(items[2].trim()) && !ExtractTypingResult.isCoverage(entries[1].trim().charAt(0)) && entries[1].indexOf("-") >= 0) {
                matchStatistics.setAlignmentString(entries[1].trim());
                break;
            }
            ++i;
        }
        if (items.length >= 11 && items[10].trim().startsWith("dropOff")) {
            matchStatistics.setDropOff(true);
            if (items[10].trim().split("=").length > 1) {
                matchStatistics.setDropOffCount(Integer.valueOf(items[10].trim().split("=")[1]));
            } else {
                matchStatistics.setDropOffCount(100);
            }
        } else {
            matchStatistics.setDropOff(false);
        }
        return matchStatistics;
    }

    private static boolean isCoverage(char thisChar) {
        return thisChar == ' ' || thisChar == '0' || thisChar == '1' || thisChar == '2' || thisChar == '3' || thisChar == '4' || thisChar == '5' || thisChar == '6' || thisChar == '7' || thisChar == '8' || thisChar == '9';
    }

    private static List<Integer> parsePositions(String positions) {
        String[] items;
        ArrayList<Integer> posList = new ArrayList<Integer>();
        if (positions.equals("0")) {
            return posList;
        }
        String[] stringArray = items = positions.split(",");
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            posList.add(new Integer(item));
            ++n2;
        }
        return posList;
    }

    public static Map<String, List<LocusExon>> initLocusMap() {
        LinkedHashMap<String, List<LocusExon>> allLocus = new LinkedHashMap<String, List<LocusExon>>();
        allLocus.put(DQA1, new ArrayList());
        ((List)allLocus.get(DQA1)).add(new LocusExon(DQA1, EXON2, true, 83));
        ((List)allLocus.get(DQA1)).add(new LocusExon(DQA1, EXON3, false, 332));
        allLocus.put(DQB1, new ArrayList());
        ((List)allLocus.get(DQB1)).add(new LocusExon(DQB1, EXON3, true, 380));
        return allLocus;
    }

    private static void addOtherCIgenes(LocusExon locusExon) {
        locusExon.addOtherTypeNames("E");
        locusExon.addOtherTypeNames("F");
        locusExon.addOtherTypeNames("G");
        locusExon.addOtherTypeNames("H");
        locusExon.addOtherTypeNames("J");
        locusExon.addOtherTypeNames("K");
        locusExon.addOtherTypeNames("L");
    }

    private static void appendToFile(StringBuilder result, File targetFile) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile, true));
        writer.write(result.toString());
        writer.close();
    }
}

