/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class ExtractFullNucSeq {
    public static void main(String[] args) throws Exception {
        File[] files;
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        File padFile = new File(args[2]);
        boolean doPadding = new Boolean(args[3]);
        Map<String, String> pad = ExtractFullNucSeq.getPadInfo(FileManager.readTextFile(padFile).split("\n"));
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File input = fileArray[n2];
            if (input.getName().indexOf("_nuc.txt") >= 0 && !input.getName().startsWith("DOA") && !input.getName().startsWith("DOB") && !input.getName().startsWith("DPA2") && !input.getName().startsWith("DPB2") && (input.getName().startsWith("D") || input.getName().startsWith("A") || input.getName().startsWith("B") || input.getName().startsWith("C"))) {
                LinkedHashMap<String, String> seq = new LinkedHashMap<String, String>();
                String locusName = ExtractFullNucSeq.createLocusName(input.getName());
                ExtractFullNucSeq.loadAllSequence(input, locusName, seq);
                Map<String, String> translatedSeq = ExtractFullNucSeq.translateSequences(seq);
                Map<String, String> anchorSeqMap = ExtractFullNucSeq.initAnchorSeq();
                if (doPadding) {
                    Map<String, String> paddedSeq = ExtractFullNucSeq.padUnknown(translatedSeq, pad, anchorSeqMap, locusName);
                    ExtractFullNucSeq.writeSeqFiles(paddedSeq, outputDir, locusName, true);
                } else {
                    ExtractFullNucSeq.writeSeqFiles(translatedSeq, outputDir, locusName, false);
                }
            }
            ++n2;
        }
    }

    private static Map<String, String> initAnchorSeq() {
        HashMap<String, String> anchorSeqMap = new HashMap<String, String>();
        anchorSeqMap.put("A", "A*01:01:01:01");
        anchorSeqMap.put("B", "B*07:02:01:01");
        anchorSeqMap.put("C", "C*01:02:01:01");
        anchorSeqMap.put("DPA1", "DPA1*01:03:01:01");
        anchorSeqMap.put("DPB1", "DPB1*01:01:01:01");
        anchorSeqMap.put("DQA1", "DQA1*01:01:01:01");
        anchorSeqMap.put("DQB1", "DQB1*05:01:01:01");
        anchorSeqMap.put("DRB", "DRB1*01:01:01");
        return anchorSeqMap;
    }

    private static void writeSeqFiles(Map<String, String> seq, File outputDir, String locusName, boolean doReplace) {
        StringBuilder builder = new StringBuilder();
        File output = new File(outputDir, String.valueOf(locusName) + ".fa");
        for (String name : seq.keySet()) {
            String sequence;
            builder.append(">").append(name).append("\n");
            if (doReplace) {
                sequence = seq.get(name).replaceAll("\\|", "");
                builder.append(sequence.replaceAll("\\.", "")).append("\n");
                continue;
            }
            sequence = seq.get(name).replaceAll("\\|", "");
            builder.append(sequence).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static Map<String, String> padUnknown(Map<String, String> translatedSeq, Map<String, String> pad, Map<String, String> anchorSeqMap, String locusName) {
        LinkedHashMap<String, String> paddedSeq = new LinkedHashMap<String, String>();
        for (String name : translatedSeq.keySet()) {
            String s = translatedSeq.get(name);
            if (s.indexOf("*") >= 0) {
                String padSeq;
                String newseq = "";
                String padSeqName = null;
                padSeqName = ExtractFullNucSeq.findPaddingName(name, pad);
                if (padSeqName == null) {
                    System.out.println(String.valueOf(name) + " ???  no padding info ");
                }
                if ((padSeq = translatedSeq.get(padSeqName)) == null) {
                    padSeq = translatedSeq.get(String.valueOf(padSeqName) + ":01");
                }
                if (padSeq == null) {
                    System.out.println(String.valueOf(name) + "," + padSeqName);
                }
                String anchorSeq = translatedSeq.get(anchorSeqMap.get(locusName));
                int i = 0;
                while (i < s.length()) {
                    char c = s.charAt(i);
                    if (c == '*') {
                        c = padSeq.charAt(i) == '*' ? anchorSeq.charAt(i) : padSeq.charAt(i);
                    }
                    newseq = String.valueOf(newseq) + c;
                    ++i;
                }
                paddedSeq.put(name, newseq);
                continue;
            }
            paddedSeq.put(name, s);
        }
        return paddedSeq;
    }

    private static String findPaddingName(String name, Map<String, String> pad) {
        String[] items = name.split(":");
        String gName = items[0];
        if (!pad.containsKey(gName) && gName.startsWith("DPB1")) {
            gName = "DPB1*allOther";
        }
        return pad.get(gName);
    }

    private static Map<String, String> translateSequences(Map<String, String> seqs) {
        LinkedHashMap<String, String> actualSeq = new LinkedHashMap<String, String>();
        String headerSeq = "";
        String anchorType = "";
        for (String type : seqs.keySet()) {
            String seq = seqs.get(type);
            if (seq.startsWith("-") || seq.startsWith("*")) continue;
            headerSeq = seq;
            anchorType = type;
            break;
        }
        for (String type : seqs.keySet()) {
            if (type.equals(anchorType)) {
                actualSeq.put(type, headerSeq);
                continue;
            }
            String rawSeq = seqs.get(type);
            String translatedSeq = "";
            int i = 0;
            while (i < headerSeq.length()) {
                if (i >= rawSeq.length()) break;
                translatedSeq = rawSeq.charAt(i) == '-' ? String.valueOf(translatedSeq) + headerSeq.charAt(i) : String.valueOf(translatedSeq) + rawSeq.charAt(i);
                ++i;
            }
            actualSeq.put(type, translatedSeq);
        }
        return actualSeq;
    }

    private static void loadAllSequence(File input, String header, Map<String, String> seq) {
        String[] data;
        String[] stringArray = data = FileManager.readTextFile(input).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((header.length() != 1 || line.trim().length() != 0 && line.trim().startsWith(String.valueOf(header) + "*")) && (header.length() != 4 || line.trim().length() != 0 && line.trim().startsWith(String.valueOf(header) + "*")) && (header.length() != 3 || line.trim().length() != 0 && line.trim().startsWith(header)) && (header.length() != 3 || line.trim().length() != 0 && !line.trim().startsWith("DRB2") && !line.trim().startsWith("DRB6") && !line.trim().startsWith("DRB7") && !line.trim().startsWith("DRB8") && !line.trim().startsWith("DRB9"))) {
                String[] info = line.trim().split("\\s+");
                String name = info[0].trim();
                if (!seq.containsKey(name)) {
                    seq.put(name, "");
                }
                String thisSeq = seq.get(name);
                int i = 1;
                while (i < info.length) {
                    thisSeq = String.valueOf(thisSeq) + info[i].trim();
                    ++i;
                }
                seq.put(name, thisSeq);
            }
            ++n2;
        }
    }

    private static Map<String, String> getPadInfo(String[] data) {
        LinkedHashMap<String, String> pad = new LinkedHashMap<String, String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split("\\s+");
            pad.put(items[0].trim(), items[1].trim());
            System.out.println(String.valueOf(items[0].trim()) + " \t " + items[1].trim());
            ++n2;
        }
        return pad;
    }

    private static String createLocusName(String name) {
        return name.replace("_nuc.txt", "").toUpperCase();
    }
}

