/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ExtractKirAllExon;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class ExtractFastaAllExonAllGeneForKir {
    public static void main(String[] args) throws Exception {
        File inputDir = new File(args[0]);
        File padFile = new File(args[1]);
        File outputDir = new File(args[2]);
        File[] files = inputDir.listFiles();
        LinkedHashMap<String, String> actualSeq = new LinkedHashMap<String, String>();
        Map<String, String> pad = ExtractFastaAllExonAllGeneForKir.getPadInfo(FileManager.readTextFile(padFile).split("\n"));
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File input = fileArray[n2];
            if (input.getName().endsWith("-cdna.txt")) {
                String gene = input.getName().replace("-cdna.txt", "");
                System.out.println("Work on gene " + gene);
                LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
                ExtractFastaAllExonAllGeneForKir.loadAllSequence(input, gene, sequences);
                ExtractFastaAllExonAllGeneForKir.translateExons(actualSeq, sequences);
            }
            ++n2;
        }
        ExtractFastaAllExonAllGeneForKir.writeSeqFiles(actualSeq, outputDir, pad);
    }

    private static void writeSeqFiles(Map<String, String> actualSeqs, File outputDir, Map<String, String> pad) {
        String headerSeq = "";
        for (String type : actualSeqs.keySet()) {
            String seq = actualSeqs.get(type);
            if (!seq.startsWith("A") && !seq.startsWith("C") && !seq.startsWith("T") && !seq.startsWith("G")) continue;
            headerSeq = seq;
            break;
        }
        int exonCount = headerSeq.split("\\|").length;
        int exonNumber = 0;
        while (exonNumber < exonCount) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            File exonFa = new File(outputDir, "exon" + (exonNumber + 1) + ".fa");
            System.out.println(String.valueOf(exonNumber) + " writing " + "exon" + (exonNumber + 1) + ".fa");
            ExtractFastaAllExonAllGeneForKir.writeExonFastaFile(actualSeqs, exonFa, pad, exonNumber, map);
            ++exonNumber;
        }
    }

    public static void writeExonFastaFile(Map<String, String> actualSeqs, File exonFa, Map<String, String> pad, int exonNumber, Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        System.out.println("----- contains N in exon" + exonFa.getName());
        for (String name : actualSeqs.keySet()) {
            int correctNumber = exonNumber;
            if (name.startsWith("2DL4") || name.startsWith("2DL5")) {
                if (exonNumber == 3) continue;
                if (exonNumber > 3) {
                    --correctNumber;
                }
            }
            if (name.startsWith("3DL3")) {
                if (exonNumber == 5) continue;
                if (exonNumber > 5) {
                    --correctNumber;
                }
            }
            if (name.startsWith("3DP1") && exonNumber > 4) continue;
            System.out.println(String.valueOf(name) + " " + actualSeqs.get(name).split("\\|").length);
            String s = actualSeqs.get(name).split("\\|")[correctNumber].replaceAll("\\*", "N");
            if (ExtractKirAllExon.allN(s) || ExtractKirAllExon.mostlyN(s)) continue;
            builder.append(">").append(name).append("\n");
            if (s.indexOf("N") >= 0) {
                String padKey = null;
                if (pad.containsKey(name)) {
                    padKey = pad.get(name);
                } else if (pad.containsKey(name.split("\\*")[0])) {
                    padKey = pad.get(name.split("\\*")[0]);
                }
                if (padKey != null) {
                    String newseq = "";
                    System.out.println(String.valueOf(name) + " pad with " + padKey + " " + actualSeqs.containsKey(padKey));
                    String padSeq = actualSeqs.get(padKey).split("\\|")[correctNumber].replaceAll("\\*", "N");
                    if (padSeq.length() != s.length()) {
                        System.out.println(String.valueOf(name) + " pad seq diff length ");
                    }
                    int i = 0;
                    while (i < s.length()) {
                        newseq = String.valueOf(newseq) + (s.charAt(i) == 'N' ? padSeq.charAt(i) : s.charAt(i));
                        ++i;
                    }
                    builder.append(newseq.replaceAll("\\.", "")).append("\n");
                    map.put(name, newseq.replaceAll("\\.", ""));
                    if (newseq.indexOf("N") < 0) continue;
                    System.out.println(name);
                    continue;
                }
                System.out.println(name);
                builder.append(s.replaceAll("\\.", "")).append("\n");
                map.put(name, s.replaceAll("\\.", ""));
                continue;
            }
            builder.append(s).append("\n");
            map.put(name, s);
        }
        FileManager.writeTextFile(exonFa, builder.toString(), true);
    }

    private static void translateExons(Map<String, String> actualSeq, Map<String, String> seqs) {
        String headerSeq = "";
        String anchorType = "";
        for (String type : seqs.keySet()) {
            String seq = seqs.get(type);
            if (!seq.startsWith("A") && !seq.startsWith("C") && !seq.startsWith("T") && !seq.startsWith("G")) continue;
            headerSeq = seq;
            anchorType = type;
            break;
        }
        for (String type : seqs.keySet()) {
            if (type.equals(anchorType)) {
                actualSeq.put(type, headerSeq);
                continue;
            }
            String rawSeq = seqs.get(type);
            String translatedSeq = "";
            int i = 0;
            while (i < headerSeq.length()) {
                translatedSeq = rawSeq.charAt(i) == '-' ? String.valueOf(translatedSeq) + headerSeq.charAt(i) : String.valueOf(translatedSeq) + rawSeq.charAt(i);
                ++i;
            }
            actualSeq.put(type, translatedSeq);
        }
    }

    private static void loadAllSequence(File input, String header, Map<String, String> seq) {
        String[] data;
        String[] stringArray = data = FileManager.readTextFile(input).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0 && line.trim().startsWith(header)) {
                String[] info = line.trim().split("\\s+");
                String name = info[0].trim();
                if (!seq.containsKey(name)) {
                    seq.put(name, "");
                }
                String thisSeq = seq.get(name);
                int i = 1;
                while (i < info.length) {
                    thisSeq = String.valueOf(thisSeq) + info[i].trim();
                    ++i;
                }
                seq.put(name, thisSeq);
            }
            ++n2;
        }
    }

    private static Map<String, String> getPadInfo(String[] data) {
        LinkedHashMap<String, String> pad = new LinkedHashMap<String, String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split("\\s+");
            pad.put(items[0].trim(), items[1].trim());
            ++n2;
        }
        return pad;
    }
}

