/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class ExtractFastaAllExonAllGeneAsOne {
    public static void main(String[] args) throws Exception {
        File inputDir = new File(args[0]);
        File padFile = new File(args[1]);
        File exon67fasta = new File(args[2]);
        File outputFasta = new File(args[3]);
        File[] files = inputDir.listFiles();
        LinkedHashMap<String, String> actualSeq = new LinkedHashMap<String, String>();
        Map<String, String> pad = ExtractFastaAllExonAllGeneAsOne.getPadInfo(FileManager.readTextFile(padFile).split("\n"));
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File input = fileArray[n2];
            if (input.getName().endsWith("-intron6.txt")) {
                String gene = input.getName().replace("-intron6.txt", "");
                System.out.println("Work on gene " + gene);
                LinkedHashMap<String, String> intronSeq = new LinkedHashMap<String, String>();
                ExtractFastaAllExonAllGeneAsOne.loadAllSequence(input, gene, intronSeq);
                ExtractFastaAllExonAllGeneAsOne.translateExons(actualSeq, intronSeq);
            }
            ++n2;
        }
        Map<String, String> ExonSeq = ExtractFastaAllExonAllGeneAsOne.getSequences(exon67fasta);
        Map<String, String> ExonIntronSeq = ExtractFastaAllExonAllGeneAsOne.fillIn(ExonSeq, actualSeq, pad);
        ExtractFastaAllExonAllGeneAsOne.writeSeqFile(ExonIntronSeq, outputFasta);
    }

    private static Map<String, String> fillIn(Map<String, String> exonSeq, Map<String, String> actualSeq, Map<String, String> pad) {
        LinkedHashMap<String, String> ExonIntronSeq = new LinkedHashMap<String, String>();
        for (String name : exonSeq.keySet()) {
            String intronSeq = null;
            if (!actualSeq.containsKey(name)) {
                if (!pad.containsKey(ExtractFastaAllExonAllGeneAsOne.getGroup(name))) {
                    System.out.println("need padding ...... " + name);
                    continue;
                }
                intronSeq = actualSeq.get(pad.get(ExtractFastaAllExonAllGeneAsOne.getGroup(name)));
            } else {
                intronSeq = actualSeq.get(name);
            }
            if (intronSeq == null) {
                System.out.println("intronSeq == null " + name);
            }
            if (intronSeq.indexOf("*") >= 0) {
                System.out.println("intronSeq contain *. " + name);
            }
            int startIndex = exonSeq.get(name).indexOf("XXXXXXXXXX") - 2;
            int endIndex = startIndex + 14;
            String newSeq = String.valueOf(exonSeq.get(name).substring(0, startIndex)) + intronSeq.replaceAll("\\.", "") + exonSeq.get(name).substring(endIndex);
            ExonIntronSeq.put(name, newSeq);
        }
        return ExonIntronSeq;
    }

    private static String getGroup(String name) {
        return name.split(":")[0];
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static void writeSeqFile(Map<String, String> joinedSeqs, File output) {
        StringBuilder builder = new StringBuilder();
        for (String name : joinedSeqs.keySet()) {
            builder.append(">").append(name).append("\n");
            builder.append(joinedSeqs.get(name)).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static void translateExons(Map<String, String> actualSeq, Map<String, String> seqs) {
        String headerSeq = "";
        String anchorType = "";
        for (String type : seqs.keySet()) {
            String seq = seqs.get(type);
            if (!seq.startsWith("A") && !seq.startsWith("C") && !seq.startsWith("T") && !seq.startsWith("G")) continue;
            headerSeq = seq;
            anchorType = type;
            break;
        }
        for (String type : seqs.keySet()) {
            if (type.equals(anchorType)) {
                actualSeq.put(type, headerSeq);
                continue;
            }
            String rawSeq = seqs.get(type);
            String translatedSeq = "";
            int i = 0;
            while (i < headerSeq.length()) {
                translatedSeq = rawSeq.charAt(i) == '-' ? String.valueOf(translatedSeq) + headerSeq.charAt(i) : String.valueOf(translatedSeq) + rawSeq.charAt(i);
                ++i;
            }
            actualSeq.put(type, translatedSeq);
        }
    }

    private static void loadAllSequence(File input, String header, Map<String, String> seq) {
        String[] data;
        String[] stringArray = data = FileManager.readTextFile(input).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!(!header.equals("DRB") ? line.trim().length() == 0 || !line.trim().startsWith(String.valueOf(header) + "*") : line.trim().length() == 0 || !line.trim().startsWith(header))) {
                String[] info = line.trim().split("\\s+");
                String name = info[0].trim();
                if (!seq.containsKey(name)) {
                    seq.put(name, "");
                }
                String thisSeq = seq.get(name);
                int i = 1;
                while (i < info.length) {
                    thisSeq = String.valueOf(thisSeq) + info[i].trim();
                    ++i;
                }
                seq.put(name, thisSeq);
            }
            ++n2;
        }
    }

    private static Map<String, String> getPadInfo(String[] data) {
        LinkedHashMap<String, String> pad = new LinkedHashMap<String, String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split("\\s+");
            pad.put(items[0].trim(), items[1].trim());
            ++n2;
        }
        return pad;
    }
}

