/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class ExtractFasta {
    public static void main(String[] args) throws Exception {
        String[] data;
        File input = new File(args[0]);
        File output = new File(args[1]);
        String header = args[2];
        File padFile = new File(args[3]);
        LinkedHashMap<String, String> seq = new LinkedHashMap<String, String>();
        Map<String, String> pad = ExtractFasta.getPadInfo(FileManager.readTextFile(padFile).split("\n"));
        String[] stringArray = data = FileManager.readTextFile(input).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0 && line.trim().startsWith(header)) {
                String[] info = line.trim().split("\\s+");
                String name = info[0].trim();
                if (!seq.containsKey(name)) {
                    seq.put(name, "");
                }
                String thisSeq = (String)seq.get(name);
                int i = 1;
                while (i < info.length) {
                    thisSeq = String.valueOf(thisSeq) + info[i].trim();
                    ++i;
                }
                seq.put(name, thisSeq);
            }
            ++n2;
        }
        StringBuilder builder = new StringBuilder();
        for (String name : seq.keySet()) {
            builder.append(">").append(name).append("\n");
            String s = ((String)seq.get(name)).replaceAll("\\.", "").replaceAll("\\*", "N").replaceAll("\\|", "");
            if (s.indexOf("N") >= 0) {
                if (pad.containsKey(name)) {
                    String newseq = "";
                    String padSeq = ((String)seq.get(pad.get(name))).replaceAll("\\.", "").replaceAll("\\*", "N").replaceAll("\\|", "");
                    int i = 0;
                    while (i < s.length()) {
                        newseq = String.valueOf(newseq) + (s.charAt(i) == 'N' ? padSeq.charAt(i) : s.charAt(i));
                        ++i;
                    }
                    builder.append(newseq).append("\n");
                    continue;
                }
                System.out.println(String.valueOf(name) + " contains N");
                builder.append(s).append("\n");
                continue;
            }
            builder.append(s).append("\n");
        }
        ExtractFasta.outputAmb(seq);
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static void outputAmb(Map<String, String> seq) {
        LinkedHashMap seqName = new LinkedHashMap();
        for (String name : seq.keySet()) {
            if (!seqName.containsKey(seq.get(name))) {
                seqName.put(seq.get(name), new ArrayList());
            }
            ((List)seqName.get(seq.get(name))).add(name);
        }
        for (String sequence : seqName.keySet()) {
            if (((List)seqName.get(sequence)).size() <= 1) continue;
            System.out.println(ExtractFasta.createOutput((List)seqName.get(sequence)));
        }
    }

    private static String createOutput(List<String> list) {
        String out = String.valueOf(list.get(0)) + "R";
        for (String n : list) {
            out = String.valueOf(out) + "\t" + n;
        }
        return out;
    }

    public static Map<String, String> getPadInfo(String[] data) {
        LinkedHashMap<String, String> pad = new LinkedHashMap<String, String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split("\\s+");
            pad.put(items[0].trim(), items[1].trim());
            ++n2;
        }
        return pad;
    }
}

