/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.Discrepancy;
import fileOperation.MatchStatistics;
import fileOperation.OneMatch;
import fileOperation.ParseFastaByHapType6;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;
import misc.StringUtils;
import misc.SystemCommand;

public class DrawType {
    static String LABEL = "000000";
    static int IMAGE_TO_DRAW = 2;
    static int COVERAGE_CUTOFF = 8;
    private static final int IMAGE_HEIGHT = 1500;
    private static final int IMAGE_SEQUENCE_POSITION = 850;
    private static final int IMAGE_WIDTH = 1000;
    private static final int IMAGE_SEQUENCE_BAR_HEIGHT = 10;
    private static final int IMAGE_REF_SEQUENCE_BAR_HEIGHT = 5;
    private static final int INDEX_SPACE = 16;
    private static final int INDEX_POSITION = 824;
    private static final int LETTER_WIDTH = 8;
    private static final int DEEPTH_HEIGHT = 400;
    private static final int LABEL_POSITION = 1050;
    private static final int AMPLICON_TO_DRAW = 100;
    private static final int AMPLICON_HEIGHT = 800;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File geneFile = new File(args[1]);
        File allHapSeqFile = new File(args[2]);
        String type1 = new String(args[3]);
        String type2 = new String(args[4]);
        String locusInfo = new String(args[5]);
        File outputFile = new File(args[6]);
        Map<String, String> allHapSeq = DrawType.getAllGenes(allHapSeqFile);
        File newFasta = DrawType.getReadFileForTypes(fastaFile, geneFile, allHapSeq, type1, type2, locusInfo);
        File newTargetFile = DrawType.createGeneFile(allHapSeq, type1, type2);
        Map<String, List<OneMatch>> readsByType = DrawType.seqReadsByType(newFasta, newTargetFile, type1, type2);
        for (String type : readsByType.keySet()) {
            System.out.println(String.valueOf(type) + "-----------");
            List<OneMatch> matches = readsByType.get(type);
            for (OneMatch match : matches) {
                System.out.println(String.valueOf(match.getName()) + " " + match.isForwardExist() + " " + match.getForwardScore() + " " + match.isReverseExist() + " " + match.getReverseScore());
            }
        }
        int exonSize = DrawType.getExonSize(newTargetFile);
        BufferedImage bufferedImage = DrawType.initializeBufferedImage(exonSize);
        Graphics2D graphics2D = ParseFastaByHapType6.initializeGraphics2D(bufferedImage);
        DrawType.drawForType(DrawType.getReadsFasta(readsByType.get(type1), fastaFile), DrawType.createGeneFile(allHapSeq, type1, "NA"), exonSize, bufferedImage, graphics2D, outputFile, type1, 0, type2, allHapSeq.get(type2));
        if (!type2.equals("NA")) {
            DrawType.drawForType(DrawType.getReadsFasta(readsByType.get(type2), fastaFile), DrawType.createGeneFile(allHapSeq, type2, "NA"), exonSize, bufferedImage, graphics2D, outputFile, type2, 1, type1, allHapSeq.get(type1));
        }
        ParseFastaByHapType6.writeImageToFile(bufferedImage, outputFile);
    }

    public static BufferedImage initializeBufferedImage(int exonSize) {
        BufferedImage bufferedImage = new BufferedImage(1000, 1500 * IMAGE_TO_DRAW, 9);
        return bufferedImage;
    }

    private static File getReadsFasta(List<OneMatch> matches, File fastaFile) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (OneMatch match : matches) {
            if (match.isForwardExist()) {
                list.add(match.getForwardFullName().substring(0, match.getForwardFullName().length() - 2));
                continue;
            }
            list.add(match.getReverseFullName().substring(0, match.getReverseFullName().length() - 2));
        }
        File newFasta = DrawType.createReadsFile(list, fastaFile);
        return newFasta;
    }

    private static int getExonSize(File newTargetFile) {
        return FileManager.readTextFile(newTargetFile).split("\n")[1].length();
    }

    private static void drawForType(File fastaFile, File hapFile, int exonSize, BufferedImage bufferedImage, Graphics2D graphics2D, File outputFile, String thisType, int imageCount, String otherType, String otherTypeSequence) throws Exception {
        File matchResult = DrawType.runDetailedCrossMatch2(fastaFile, hapFile);
        String[] lines = FileManager.readTextFile(matchResult).split("\n");
        System.out.println("filteredResult...");
        List<Integer> filteredResult = DrawType.filterResult(lines);
        System.out.println("done filteredResult... " + filteredResult.size());
        System.out.println("ParseResult...");
        Map<String, Map<String, OneMatch>> result = DrawType.ParseResult(lines, filteredResult, fastaFile);
        System.out.println("Done ParseResult...");
        HashMap orgnizedTypes = new HashMap();
        HashMap<String, ArrayList<OneMatch>> effectiveMatchesByType = new HashMap<String, ArrayList<OneMatch>>();
        HashMap<String, MatchStatistics> matchStatisticsList = new HashMap<String, MatchStatistics>();
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            ArrayList<OneMatch> effectiveMatches = new ArrayList<OneMatch>();
            int count = 0;
            int pairedCount = 0;
            for (OneMatch match : matches.values()) {
                if (match.isForwardExist() && match.isReverseExist()) {
                    effectiveMatches.add(match);
                    count += 2;
                    ++pairedCount;
                    continue;
                }
                effectiveMatches.add(match);
                ++count;
            }
            if (count <= 0) continue;
            effectiveMatchesByType.put(type, effectiveMatches);
            matchStatisticsList.put(type, DrawType.fillMatchStatistics(effectiveMatches, exonSize));
            ((MatchStatistics)matchStatisticsList.get(type)).setNumPairsSupport(pairedCount);
            ((MatchStatistics)matchStatisticsList.get(type)).setNumReads(count);
            int firmPosCount = ((MatchStatistics)matchStatisticsList.get(type)).getNumPosGoodCoverage();
            if (!orgnizedTypes.containsKey(firmPosCount)) {
                orgnizedTypes.put(firmPosCount, new ArrayList());
            }
            ((List)orgnizedTypes.get(firmPosCount)).add(type);
        }
        System.out.println("draw " + thisType);
        DrawType.drawImage(thisType, (MatchStatistics)matchStatisticsList.get(thisType), (List)effectiveMatchesByType.get(thisType), exonSize, bufferedImage, graphics2D, imageCount, fastaFile, DrawType.getHapSeq(hapFile), otherType, otherTypeSequence);
    }

    private static String getHapSeq(File hapFile) {
        return FileManager.readTextFile(hapFile).split("\n")[1].trim();
    }

    private static MatchStatistics fillMatchStatistics(List<OneMatch> list, int exonSize) {
        MatchStatistics matchStatistics = new MatchStatistics();
        int totalSize = 0;
        int totalCount = 0;
        int pairsWithCompleteCoverage = 0;
        Map<Integer, Integer> posCount = ParseFastaByHapType6.initMap(exonSize);
        HashMap<Integer, Integer> misMatchPosCount = new HashMap<Integer, Integer>();
        for (OneMatch match : list) {
            int fstart = match.getForwardTargetStart();
            int fend = match.getForwardTargetEnd();
            int rstart = match.getReverseTargetStart();
            int rend = match.getReverseTargetEnd();
            if (fstart > match.getReverseTargetStart()) {
                fstart = match.getReverseTargetStart();
                fend = match.getReverseTargetEnd();
                rstart = match.getForwardTargetStart();
                rend = match.getForwardTargetEnd();
            }
            int size = 0;
            if (match.isForwardExist() && match.isReverseExist()) {
                if (fend >= rstart) {
                    size = Math.max(rend, fend) - fstart + 1;
                    ParseFastaByHapType6.addToPosCount(posCount, fstart, Math.max(rend, fend));
                    if (fstart == 1 && rend == exonSize) {
                        ++pairsWithCompleteCoverage;
                    }
                } else {
                    size = fend - fstart + 1 + (rend - rstart + 1);
                    ParseFastaByHapType6.addToPosCount(posCount, fstart, fend);
                    ParseFastaByHapType6.addToPosCount(posCount, rstart, rend);
                }
                ParseFastaByHapType6.addInDiscrepenies(match.getForDiscrepencies(), posCount, misMatchPosCount);
                ParseFastaByHapType6.addInDiscrepenies(match.getRevDiscrepencies(), posCount, misMatchPosCount);
                match.setCoverageSize(size);
                totalSize += size;
                ++totalCount;
                continue;
            }
            int thisSize = 0;
            if (match.isForwardExist()) {
                size = fend - fstart + 1;
                ParseFastaByHapType6.addToPosCount(posCount, fstart, fend);
                ParseFastaByHapType6.addInDiscrepenies(match.getForDiscrepencies(), posCount, misMatchPosCount);
                totalSize += size;
                thisSize += size;
                ++totalCount;
            }
            if (match.isReverseExist()) {
                size = rend - rstart + 1;
                ParseFastaByHapType6.addToPosCount(posCount, rstart, rend);
                ParseFastaByHapType6.addInDiscrepenies(match.getRevDiscrepencies(), posCount, misMatchPosCount);
                totalSize += size;
                thisSize += size;
                ++totalCount;
            }
            match.setCoverageSize(thisSize);
        }
        matchStatistics.setAverageAmpliconSize(totalSize / totalCount);
        ArrayList<Integer> firmPos = new ArrayList<Integer>();
        for (int pos : posCount.keySet()) {
            if (posCount.get(pos) < COVERAGE_CUTOFF) continue;
            firmPos.add(pos);
        }
        ArrayList<Integer> questionPos = new ArrayList<Integer>();
        Iterator iterator = misMatchPosCount.keySet().iterator();
        while (iterator.hasNext()) {
            int pos = (Integer)iterator.next();
            if ((Integer)misMatchPosCount.get(pos) * 3 <= posCount.get(pos)) continue;
            questionPos.add(pos);
        }
        matchStatistics.setMisMatchPosCount(misMatchPosCount);
        matchStatistics.setPosCount(posCount);
        matchStatistics.setQuestionPos(questionPos);
        matchStatistics.setNumPosGoodCoverage(firmPos.size());
        matchStatistics.setNumPairsCompletelyCoverExon(pairsWithCompleteCoverage);
        matchStatistics.setExonSize(exonSize);
        return matchStatistics;
    }

    private static void drawImage(String hap, MatchStatistics matchStatistics, List<OneMatch> list, int exonSize, BufferedImage bufferedImage, Graphics2D graphics2D, int imageCount, File fastaFile, String hapSeq, String otherType, String otherTypeSequence) {
        String label = " Support Reads in Pairs =" + matchStatistics.getNumPairsSupport();
        label = String.valueOf(label) + ", Support Reads =" + matchStatistics.getNumReads();
        DrawType.drawSequence(exonSize, imageCount, bufferedImage, graphics2D, hap);
        DrawType.drawDeepth(matchStatistics.getPosCount(), exonSize, imageCount, bufferedImage, graphics2D, label);
        DrawType.drawAmplicons(list, exonSize, imageCount, bufferedImage, graphics2D, fastaFile, hapSeq);
        if (!otherType.equals("NA")) {
            DrawType.drawOtherType(list, exonSize, imageCount, bufferedImage, graphics2D, hapSeq, otherType, otherTypeSequence);
        }
    }

    private static void drawOtherType(List<OneMatch> alllist, int exonSize, int imageCount, BufferedImage bufferedImage, Graphics2D graphics2D, String hapSeq, String otherType, String otherTypeSequence) {
        int length = exonSize;
        graphics2D.setColor(Color.LIGHT_GRAY);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - imageCount - 1) * 1500;
        float ampFraction = new Float(alllist.size()).floatValue() / new Float(100.0f).floatValue();
        float ampliconHeight = Math.min(1.0f, ampFraction) * new Float(800.0f).floatValue();
        int thisSeqPos = yBase - 824 + Math.round(ampliconHeight);
        System.out.println(String.valueOf(ampFraction) + " thisSeqPos=" + thisSeqPos);
        graphics2D.draw3DRect(0, thisSeqPos, 1000, 5, true);
        graphics2D.fill3DRect(0, thisSeqPos, 1000, 5, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(" " + otherType, 1, thisSeqPos + 5 + 16);
        DrawType.drawMismatchBetweenTypes(thisSeqPos, exonSize, bufferedImage, graphics2D, hapSeq, otherTypeSequence);
    }

    private static void drawMismatchBetweenTypes(int thisSeqPos, int exonSize, BufferedImage bufferedImage, Graphics2D graphics2D, String hapSeq, String otherSeq) {
        LinkedHashMap<Integer, String> misMatches = new LinkedHashMap<Integer, String>();
        int i = 0;
        while (i < hapSeq.length()) {
            if (i >= otherSeq.length()) break;
            if (hapSeq.charAt(i) != 'N' && otherSeq.charAt(i) != 'N' && hapSeq.charAt(i) != otherSeq.charAt(i)) {
                misMatches.put(i + 1, String.valueOf(otherSeq.charAt(i)));
            }
            ++i;
        }
        for (Integer pos : misMatches.keySet()) {
            int x = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(exonSize) * (double)pos.intValue()).floatValue());
            graphics2D.setColor(DrawType.getBaseColor((String)misMatches.get(pos)));
            graphics2D.drawLine(x, thisSeqPos, x, thisSeqPos + 5);
        }
    }

    private static void drawAmplicons(List<OneMatch> alllist, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, File fastaFile, String hapSeq) {
        int length = exonSize;
        int readSize = DrawType.getReadSize(fastaFile);
        Color[] colors = new Color[]{Color.DARK_GRAY, Color.LIGHT_GRAY};
        List<OneMatch> list = DrawType.orgnizeMatches(alllist, exonSize);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1500;
        int index = 1;
        for (OneMatch match : list) {
            int x2;
            int y1;
            int x1;
            graphics2D.setColor(colors[index % 2]);
            if (match.isForwardExist()) {
                x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getForwardTargetStart() - match.getForwardStart() + 1)).floatValue());
                y1 = yBase - 824 + index * 8;
                x2 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getForwardTargetEnd() + readSize - match.getForwardEnd())).floatValue());
                graphics2D.drawLine(x1, y1, x2, y1);
            }
            if (match.isReverseExist()) {
                x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getReverseTargetStart() - readSize + match.getReverseEnd())).floatValue());
                y1 = yBase - 824 + index * 8;
                x2 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getReverseTargetEnd() + match.getReverseStart() - 1)).floatValue());
                graphics2D.drawLine(x1, y1, x2, y1);
            }
            DrawType.drawMismatchPos(yBase, exonSize, bufferedImage, match, graphics2D, index, fastaFile, hapSeq, readSize);
            if (++index > 100) break;
        }
    }

    private static void drawMismatchPos(int yBase, int exonSize, BufferedImage bufferedImage, OneMatch match, Graphics2D graphics2D, int index, File fastaFile, String hapSeq, int readSize) {
        int y1 = yBase - 824 + index * 8;
        if (match.isForwardExist() && match.isReverseExist()) {
            int x1 = match.getForwardStart();
            int x2 = match.getForwardEnd();
            int x3 = match.getReverseStart();
            int x4 = match.getReverseEnd();
            if (x1 == x2 || x3 == x4) {
                return;
            }
            String forwardSeq = DrawType.getSeqFromFile(match.getForwardFullName(), fastaFile);
            String reverseSeq = DrawType.getSeqFromFile(match.getReverseFullName(), fastaFile);
            int t1 = match.getForwardTargetStart();
            int t2 = match.getForwardTargetEnd();
            int t3 = match.getReverseTargetStart();
            int t4 = match.getReverseTargetEnd();
            LinkedHashMap<Integer, String> misMatches = new LinkedHashMap<Integer, String>();
            DrawType.findMismatches(misMatches, forwardSeq, hapSeq, x1, x2, t1, t2, false, readSize, t3, t4);
            DrawType.findMismatches(misMatches, reverseSeq, hapSeq, x3, x4, t3, t4, true, readSize, t1, t2);
            DrawType.addMismatches(misMatches, match.getForDiscrepencies(), false);
            DrawType.addMismatches(misMatches, match.getRevDiscrepencies(), true);
            System.out.println(match.getName());
            for (Integer pos : misMatches.keySet()) {
                System.out.println(pos + " " + (String)misMatches.get(pos));
                int y = yBase - 824 + index * 8;
                int x = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(exonSize) * (double)pos.intValue()).floatValue());
                graphics2D.setColor(DrawType.getBaseColor((String)misMatches.get(pos)));
                graphics2D.drawLine(x, y - 1, x, y + 1);
            }
        }
    }

    private static Color getBaseColor(String base) {
        if (base.equals("A")) {
            return Color.GREEN;
        }
        if (base.equals("T")) {
            return Color.RED;
        }
        if (base.equals("C")) {
            return Color.BLUE;
        }
        if (base.equals("G")) {
            return Color.ORANGE;
        }
        return Color.LIGHT_GRAY;
    }

    private static void addMismatches(Map<Integer, String> misMatches, List<Discrepancy> forDiscrepencies, boolean isRevComp) {
        for (Discrepancy d : forDiscrepencies) {
            if (isRevComp) {
                misMatches.put(d.getTargetPosition(), StringUtils.revCompSeq(d.getQueryBase()));
                continue;
            }
            misMatches.put(d.getTargetPosition(), d.getQueryBase());
        }
    }

    private static void findMismatches(Map<Integer, String> misMatches, String seq, String hapSeq, int x1, int x2, int t1, int t2, boolean isReverseComp, int readSize, int t3, int t4) {
        if (!isReverseComp) {
            char h;
            int targetIndex;
            char s;
            int i = 0;
            while (i < x1 - 1) {
                s = seq.charAt(i);
                targetIndex = t1 - x1 + i;
                if (targetIndex >= 0 && s != (h = hapSeq.charAt(targetIndex)) && h != 'N' && DrawType.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
            i = x2;
            while (i < readSize) {
                s = seq.charAt(i);
                targetIndex = t2 + (i - x2);
                if (targetIndex <= hapSeq.length() - 1 && s != (h = hapSeq.charAt(targetIndex)) && h != 'N' && DrawType.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
        } else {
            char h;
            int targetIndex;
            char s;
            int i = 0;
            while (i < x1 - 1) {
                s = StringUtils.revCompSeq(String.valueOf(seq.charAt(i))).charAt(0);
                targetIndex = t2 + (x1 - i) - 2;
                if (targetIndex <= hapSeq.length() - 1 && s != (h = hapSeq.charAt(targetIndex)) && h != 'N' && DrawType.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
            i = x2;
            while (i < readSize) {
                s = StringUtils.revCompSeq(String.valueOf(seq.charAt(i))).charAt(0);
                targetIndex = t1 - (i - x2) - 2;
                if (targetIndex >= 0 && s != (h = hapSeq.charAt(targetIndex)) && h != 'N' && DrawType.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
        }
    }

    private static boolean outsideOtherStrandsMatchRegion(int targetIndex, int t3, int t4) {
        return targetIndex < t3 - 1 || targetIndex > t4 - 1;
    }

    private static String getSeqFromFile(String hap, File rulesetFile) {
        String cmd = "grep -R -A1 \"" + hap.replace("*", "\\*") + "\" " + rulesetFile.getAbsolutePath();
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, true);
        command.makeItSo();
        String[] log = command.getStandardOut().trim().split("\n");
        int i = 0;
        while (i < log.length) {
            if (log[i].startsWith(">") && log[i].trim().substring(1, log[i].trim().length()).equals(hap)) {
                return log[i + 1].trim();
            }
            ++i;
        }
        return null;
    }

    private static int getReadSize(File fastaFile) {
        return FileManager.readTextFile(fastaFile).split("\n")[1].trim().length();
    }

    private static List<OneMatch> orgnizeMatches(List<OneMatch> list, int exonSize) {
        HashMap sortedMatches = new HashMap();
        ArrayList<OneMatch> sortedList = new ArrayList<OneMatch>();
        int count = 0;
        for (OneMatch match : list) {
            int size = match.getCoverageSize();
            if (!sortedMatches.containsKey(size)) {
                sortedMatches.put(size, new ArrayList());
            }
            ((List)sortedMatches.get(size)).add(match);
            if (++count > 100) break;
        }
        Object[] num = sortedMatches.keySet().toArray();
        Arrays.sort(num);
        int i = num.length - 1;
        while (i >= 0) {
            sortedList.addAll((Collection)sortedMatches.get(num[i]));
            --i;
        }
        return sortedList;
    }

    public static void drawDeepth(Map<Integer, Integer> posCount, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, String output) {
        int length = exonSize;
        int countMax = ParseFastaByHapType6.getCountMax(posCount);
        double depthUnit = 0.0;
        depthUnit = (double)countMax > 50.0 ? new Double(400.0) / new Double((double)countMax * 1.5) : new Double(400.0) / new Double(75.0);
        graphics2D.setColor(Color.LIGHT_GRAY);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1500;
        for (int pos : posCount.keySet()) {
            int x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)pos).floatValue());
            int y1 = yBase - 850 - 10;
            int y2 = Math.round(new Float(depthUnit * (double)posCount.get(pos).intValue()).floatValue());
            graphics2D.drawLine(x1, y1 - y2, x1, y1);
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(" coverage max=" + countMax, 1, yBase - 1050);
        graphics2D.drawString(output, 1, yBase - 1050 + 10);
    }

    public static void drawSequence(int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, String hap) {
        int length = exonSize;
        graphics2D.setColor(Color.LIGHT_GRAY);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1500;
        graphics2D.draw3DRect(0, yBase - 850, 1000, 10, true);
        graphics2D.fill3DRect(0, yBase - 850, 1000, 10, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(1, yBase - 850, 1, bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1500 - 850 + 10);
        graphics2D.drawString("1 " + hap, 1, yBase - 824);
        graphics2D.drawLine(bufferedImage.getWidth() - 1, yBase - 850, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1500 - 850 + 10);
        graphics2D.drawString(new Integer(length).toString(), bufferedImage.getWidth() - new Integer(length).toString().length() * 8, yBase - 824);
        double unit = ParseFastaByHapType6.getUnit(exonSize);
        int num = new Double((double)exonSize / unit).intValue();
        int x = 0;
        String index = null;
        int i = 1;
        while (i <= num) {
            x = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * unit * (double)i).floatValue());
            index = String.valueOf(new Double(unit * (double)i).intValue());
            graphics2D.drawLine(x, yBase - 850, x, yBase - 850 + 10);
            if (i < num || i == num && (double)length - unit * (double)num >= unit / 2.0) {
                graphics2D.drawString(index, x, yBase - 824);
            }
            ++i;
        }
    }

    private static Map<String, List<OneMatch>> seqReadsByType(File fastaFile, File hapFile, String type1, String type2) throws Exception {
        File matchResult = DrawType.runDetailedCrossMatch1(fastaFile, hapFile);
        String[] lines = FileManager.readTextFile(matchResult).split("\n");
        System.out.println("filteredResult...");
        List<Integer> filteredResult = DrawType.filterResult(lines);
        System.out.println("done filteredResult... " + filteredResult.size());
        System.out.println("ParseResult...");
        Map<String, Map<String, OneMatch>> result = DrawType.ParseResult(lines, filteredResult, fastaFile);
        System.out.println("Done ParseResult...");
        return DrawType.assignReadsByType(result, fastaFile, type1, type2);
    }

    private static Map<String, List<OneMatch>> assignReadsByType(Map<String, Map<String, OneMatch>> result, File fastaFile, String type1, String type2) {
        HashMap<String, List<OneMatch>> effectiveMatchesByType = new HashMap<String, List<OneMatch>>();
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            ArrayList<OneMatch> effectiveMatches = new ArrayList<OneMatch>();
            int count = 0;
            int pairCount = 0;
            for (OneMatch match : matches.values()) {
                if (match.isForwardExist() && match.isReverseExist()) {
                    effectiveMatches.add(match);
                    count += 2;
                    ++pairCount;
                    continue;
                }
                if (DrawType.otherTypeHasThisAsPair(match, result.get(type.equals(type1) ? type2 : type1)) || DrawType.otherTypeHasBetterMatch(match, result.get(type.equals(type1) ? type2 : type1))) continue;
                ++count;
                effectiveMatches.add(match);
            }
            effectiveMatchesByType.put(type, effectiveMatches);
            System.out.println(String.valueOf(type) + " all reads count=" + count + " pairs=" + pairCount);
        }
        for (String type : result.keySet()) {
            System.out.println("------------" + type + "------------");
            for (OneMatch match : result.get(type).values()) {
                System.out.println(String.valueOf(match.getName()) + " " + match.isForwardExist() + " " + match.isReverseExist());
            }
        }
        return effectiveMatchesByType;
    }

    private static boolean otherTypeHasBetterMatch(OneMatch match, Map<String, OneMatch> map) {
        if (map == null) {
            return false;
        }
        if (map.containsKey(match.getName())) {
            System.out.println("checking........222 " + match.getName() + " " + map.containsKey(match.getName()) + " " + Math.max(match.getForwardMisMatch(), match.getReverseMisMatch()) + " " + Math.max(map.get(match.getName()).getForwardMisMatch(), map.get(match.getName()).getReverseMisMatch()));
            if (Math.max(match.getForwardMisMatch(), match.getReverseMisMatch()) > Math.max(map.get(match.getName()).getForwardMisMatch(), map.get(match.getName()).getReverseMisMatch())) {
                System.out.println("here;;;;;;;;;;;;;;;;;;:");
                return true;
            }
        }
        return false;
    }

    private static boolean otherTypeHasThisAsPair(OneMatch match, Map<String, OneMatch> map) {
        if (map == null) {
            return false;
        }
        System.out.println("checking........222 " + match.getName() + " " + map.containsKey(match.getName()));
        return map.containsKey(match.getName()) && map.get(match.getName()).isForwardExist() && map.get(match.getName()).isReverseExist();
    }

    private static Map<String, Map<String, OneMatch>> ParseResult(String[] lines, List<Integer> filteredResult, File fastaFile) throws Exception {
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        int lineCount = 0;
        boolean startRecord = false;
        OneMatch aMatch = null;
        String fullName = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ++lineCount;
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                if (filteredResult.contains(lineCount)) {
                    startRecord = true;
                    String[] items = line.trim().split("\\s+");
                    fullName = items[4].trim();
                    aMatch = DrawType.populateAmatch(fastaFile, result, line);
                } else {
                    startRecord = false;
                    aMatch = null;
                    fullName = null;
                }
            } else if (startRecord && line.trim().split("\\s+").length == 5) {
                DrawType.populateDiscrepency(aMatch, line, fullName);
            }
            ++n2;
        }
        return result;
    }

    private static void populateDiscrepency(OneMatch match, String line, String fullName) {
        String[] items = line.trim().split("\\s+");
        if (items[0].charAt(0) != 'S' && items[0].charAt(0) != 'I' && items[0].charAt(0) != 'D') {
            return;
        }
        Discrepancy dis = DrawType.generateDiscrepancy(items);
        if (match.getForwardFullName() != null && match.getForwardFullName().equals(fullName)) {
            match.addForDiscrepencies(dis);
        } else if (match.getReverseFullName() != null && match.getReverseFullName().equals(fullName)) {
            match.addRevDiscrepencies(dis);
        } else {
            System.out.println("error in parsing discrep !!!!!!!!!!!!");
        }
    }

    private static Discrepancy generateDiscrepancy(String[] item) {
        int count = 1;
        if (item[0].trim().length() > 1) {
            count = new Integer(item[0].trim().substring(2));
        }
        String base = item[2].trim().substring(0, item[2].indexOf("("));
        int qual = new Integer(item[2].trim().substring(item[2].indexOf("(") + 1, item[2].indexOf(")")));
        Discrepancy dis = new Discrepancy(item[0].charAt(0), count, new Integer(item[1]), base, qual, new Integer(item[3]), item[4].trim());
        return dis;
    }

    private static OneMatch populateAmatch(File fastaFile, Map<String, Map<String, OneMatch>> result, String line) {
        OneMatch aMatch;
        Map<String, OneMatch> matches;
        String type;
        String[] items = line.trim().split("\\s+");
        String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
        String name = thisRead.substring(0, thisRead.length() - 2);
        String fullName = items[4].trim();
        boolean isRevComp = items[8].trim().equals("C");
        String string = type = isRevComp ? items[9].trim() : items[8].trim();
        if (!result.containsKey(type)) {
            result.put(type, new HashMap());
        }
        if (!(matches = result.get(type)).containsKey(name)) {
            aMatch = new OneMatch();
            aMatch.setName(name);
            matches.put(name, aMatch);
        }
        aMatch = matches.get(name);
        if (isRevComp) {
            aMatch.setReverseExist(true);
            aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
            aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
            aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
            aMatch.setReverseFullName(fullName);
            aMatch.setReverseStart(Integer.valueOf(items[5].trim()));
            aMatch.setReverseEnd(Integer.valueOf(items[6].trim()));
            aMatch.setReverseMisMatch(Double.valueOf(items[1].trim()));
        } else {
            aMatch.setForwardExist(true);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
            aMatch.setForwardFullName(fullName);
            aMatch.setForwardStart(Integer.valueOf(items[5].trim()));
            aMatch.setForwardEnd(Integer.valueOf(items[6].trim()));
            aMatch.setForwardMisMatch(Double.valueOf(items[1].trim()));
        }
        return aMatch;
    }

    private static List<Integer> filterResult(String[] lines) throws Exception {
        ArrayList<Integer> results = new ArrayList<Integer>();
        LinkedHashMap groupedMap = new LinkedHashMap();
        int lineCount = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ++lineCount;
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                String[] items = line.trim().split("\\s+");
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                if (!groupedMap.containsKey(thisRead)) {
                    groupedMap.put(thisRead, new HashMap());
                }
                Integer score = Integer.valueOf(items[0].trim());
                if (!((Map)groupedMap.get(thisRead)).containsKey(score)) {
                    ((Map)groupedMap.get(thisRead)).put(score, new ArrayList());
                }
                ((List)((Map)groupedMap.get(thisRead)).get(score)).add(lineCount);
            }
            ++n2;
        }
        for (String read : groupedMap.keySet()) {
            Map scoreMap = (Map)groupedMap.get(read);
            Object[] num = scoreMap.keySet().toArray();
            Arrays.sort(num);
            results.addAll((Collection)scoreMap.get(num[num.length - 1]));
        }
        return results;
    }

    private static File runDetailedCrossMatch1(File fastaFile, File hapFile) throws Exception {
        File tmpFile = File.createTempFile("out", "txt");
        tmpFile.deleteOnExit();
        String cmd = "/genome/bin/cross_match -masklevel 101 " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath() + " > " + tmpFile.getAbsolutePath();
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        System.out.println("running cross_match...");
        command.makeItSo();
        System.out.println("done cross_match... command.getExitValue() : " + command.getExitValue());
        return tmpFile;
    }

    private static File runDetailedCrossMatch2(File fastaFile, File hapFile) throws Exception {
        File tmpFile = File.createTempFile("out", "txt");
        tmpFile.deleteOnExit();
        String cmd = "/genome/bin/cross_match  -discrep_lists " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath() + " > " + tmpFile.getAbsolutePath();
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        System.out.println("running cross_match..." + cmd);
        command.makeItSo();
        System.out.println("done cross_match... command.getExitValue() : " + command.getExitValue());
        return tmpFile;
    }

    private static File createGeneFile(Map<String, String> allHapSeq, String type1, String type2) throws Exception {
        File tmpFile = File.createTempFile("gene", "fa");
        tmpFile.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(type1).append("\n");
        builder.append(allHapSeq.get(type1)).append("\n");
        if (!type2.equals("NA")) {
            builder.append(">").append(type2).append("\n");
            builder.append(allHapSeq.get(type2)).append("\n");
        }
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        return tmpFile;
    }

    private static File getReadFileForTypes(File fastaFile, File geneFile, Map<String, String> allHapSeq, String type1, String type2, String locusInfo) throws Exception {
        File tempGeneFile = DrawType.createTempGeneFile(geneFile, allHapSeq, type1, type2, locusInfo);
        Map<String, List<String>> resultByType = DrawType.getReadsByGene(fastaFile, tempGeneFile);
        for (String gene : resultByType.keySet()) {
            System.out.println(String.valueOf(gene) + " : " + resultByType.get(gene).size());
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll((Collection)resultByType.get(type1));
        if (!type2.equals("NA")) {
            list.addAll((Collection<String>)resultByType.get(type2));
        }
        File newFasta = DrawType.createReadsFile(list, fastaFile);
        return newFasta;
    }

    private static File createReadsFile(List<String> list, File fastaFile) throws Exception {
        File tmpFile = File.createTempFile("read", "fa");
        tmpFile.deleteOnExit();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith(">" + LABEL)) {
                String name = line.trim().substring(1, line.trim().length() - 2);
                if (list.contains(name)) {
                    builder.append(line);
                    builder.append("\n");
                    builder.append(lines[i + 1]);
                    builder.append("\n");
                }
                ++i;
            }
            ++i;
        }
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        return tmpFile;
    }

    public static Map<String, List<String>> getReadsByGene(File fastaFile, File hapFile) throws Exception {
        String matchResult = DrawType.runCrossMatch(fastaFile, hapFile);
        Map<String, OneMatch> result = DrawType.ParseResult(matchResult);
        Map<String, List<String>> resultByType = DrawType.orgnizeResult(result);
        return resultByType;
    }

    private static Map<String, List<String>> orgnizeResult(Map<String, OneMatch> result) throws Exception {
        HashMap<String, List<String>> resultByType = new HashMap<String, List<String>>();
        for (String name : result.keySet()) {
            String type2;
            String type1;
            OneMatch aMatch = result.get(name);
            String type = null;
            type = aMatch.isForwardExist() && aMatch.isReverseExist() ? ((type1 = aMatch.getForwardType()).equals(type2 = aMatch.getReverseType()) ? type1 : (aMatch.getForwardMisMatch() < aMatch.getReverseMisMatch() ? type1 : type2)) : (aMatch.isForwardExist() ? aMatch.getForwardType() : aMatch.getReverseType());
            if (!resultByType.containsKey(type)) {
                resultByType.put(type, new ArrayList());
            }
            ((List)resultByType.get(type)).add(name);
        }
        return resultByType;
    }

    private static Map<String, OneMatch> ParseResult(String matchResult) {
        String[] lines = matchResult.split("\n");
        HashMap<String, OneMatch> result = new HashMap<String, OneMatch>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                String type;
                OneMatch aMatch;
                String[] items = line.trim().split("\\s+");
                String thisRead = items[4].trim();
                String name = thisRead.substring(0, thisRead.length() - 2);
                if (!result.containsKey(name)) {
                    aMatch = new OneMatch();
                    aMatch.setName(name);
                    result.put(name, aMatch);
                }
                aMatch = (OneMatch)result.get(name);
                boolean isRevComp = items[8].trim().equals("C");
                String string = type = isRevComp ? items[9].trim() : items[8].trim();
                if (isRevComp) {
                    aMatch.setReverseExist(true);
                    aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                    aMatch.setReverseMisMatch(Double.valueOf(items[1].trim()));
                    aMatch.setReverseType(type);
                } else {
                    aMatch.setForwardExist(true);
                    aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
                    aMatch.setForwardMisMatch(Double.valueOf(items[1].trim()));
                    aMatch.setForwardType(type);
                }
            }
            ++n2;
        }
        return result;
    }

    private static String runCrossMatch(File fastaFile, File hapFile) {
        String cmd = "/genome/bin/cross_match " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath();
        String data = OsHelper.excuteCommand(cmd);
        return data;
    }

    private static File createTempGeneFile(File geneFile, Map<String, String> allHapSeq, String type1, String type2, String locusInfo) throws Exception {
        File tmpFile = File.createTempFile("gene", "fa");
        tmpFile.deleteOnExit();
        Map<String, String> genes = DrawType.getAllGenes(geneFile);
        StringBuilder builder = new StringBuilder();
        for (String gene : genes.keySet()) {
            if (gene.equals(locusInfo)) {
                String type1Seq = allHapSeq.get(type1);
                if (type1Seq == null) {
                    System.err.println("Invalid Type name : " + type1 + " please use exact type name in ruleset file!");
                    return null;
                }
                builder.append(">").append(type1).append("\n");
                builder.append(type1Seq).append("\n");
                if (type2.equals("NA")) continue;
                String type2Seq = allHapSeq.get(type2);
                if (type2Seq == null) {
                    System.err.println("Invalid Type name : " + type2 + " please use exact type name in ruleset file or NA for no type!");
                    return null;
                }
                builder.append(">").append(type2).append("\n");
                builder.append(type2Seq).append("\n");
                continue;
            }
            builder.append(">").append(gene).append("\n");
            builder.append(genes.get(gene)).append("\n");
        }
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        return tmpFile;
    }

    public static Map<String, String> getAllGenes(File file) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] data = FileManager.readTextFile(file).split("\n");
        int i = 0;
        while (i < data.length - 1) {
            if (data[i].trim().startsWith(">")) {
                map.put(data[i].split("\\s+")[0].substring(1), data[i + 1].trim());
            }
            ++i;
        }
        return map;
    }
}

