/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public class DrawChart {
    private static final String PNG = "jpg";
    private static final double MIN_NUMBER = 5.0;
    private static final double MAX_NUMBER = 10.0;
    private static final int IMAGE_WIDTH = 1000;
    private static final int IMAGE_HEIGHT = 600;
    private static final int DEEPTH_HEIGHT = 400;
    private static final int IMAGE_SEQUENCE_POSITION = 50;
    private static final int IMAGE_SEQUENCE_BAR_HEIGHT = 10;
    private static final int SNP_MARKER_HEIGHT = 6;
    private static final int INDEX_SPACE = 16;
    private static final int INDEX_POSITION = 24;
    private static final int LETTER_WIDTH = 8;
    private static final int SNP_POINT_WIDTH = 1;
    private static final int IMAGE_UNIT = 100;
    private static final int NORMAL_SEQUENCE_UNIT = 4000;
    private static final int MAX_IMAGE_WIDTH = 65500;
    private static final String ARBO = "Human";
    private static final String CYNO = "CYNO";
    private static final String CHINESE_RHESUS = "Chinese-Rhesus";
    private static final String PIGTAIL_RHESUS = "Pigtail-Rhesus";
    private static final String RHESUS_MACQUE = "Rhesus-Macque";
    private static final int SNP_COUNT_UNIT = 7;
    private static BufferedImage bufferedImage;
    private static Graphics2D graphics2D;
    private static int imageWidth;
    private static boolean useDefault;
    private static double unit;
    private static int num;
    private static int sequenceUnit;

    public static void main(String[] args) throws Exception {
    }

    public static void generateImage(Map<Integer, Integer> posCount, int exonSize, File image) {
        DrawChart.initializeBufferedImage(posCount, exonSize, image);
        DrawChart.initializeGraphics2D(posCount, exonSize, image);
        DrawChart.drawSequence(posCount, exonSize, image);
        DrawChart.drawDeepth(posCount, exonSize, image);
        DrawChart.writeImageToFile(image);
    }

    private static void drawDeepth(Map<Integer, Integer> posCount, int exonSize, File image) {
        int length = exonSize;
        int countMax = DrawChart.getCountMax(posCount);
        System.out.println("---------max=" + countMax);
        graphics2D.setColor(Color.LIGHT_GRAY);
        for (int pos : posCount.keySet()) {
            int x1 = Math.round(new Float(new Double(imageWidth) / new Double(length) * (double)pos).floatValue());
            int y1 = bufferedImage.getHeight() - 50 + 10;
            int y2 = Math.round(new Float(new Double(400.0) / new Double(countMax) * (double)posCount.get(pos).intValue()).floatValue());
            graphics2D.drawLine(x1, y1, x1, y2);
        }
        graphics2D.draw3DRect(0, bufferedImage.getHeight() - 50, bufferedImage.getWidth(), 10, true);
        graphics2D.fill3DRect(0, bufferedImage.getHeight() - 50, bufferedImage.getWidth(), 10, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(1, bufferedImage.getHeight() - 50, 1, bufferedImage.getHeight() - 50 + 10);
        graphics2D.drawString("1", 1, bufferedImage.getHeight() - 24);
        graphics2D.drawLine(bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 50, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 50 + 10);
        graphics2D.drawString(new Integer(length).toString(), bufferedImage.getWidth() - new Integer(length).toString().length() * 8, bufferedImage.getHeight() - 24);
        int x = 0;
        String index = null;
        int i = 1;
        while (i <= num) {
            if (useDefault) {
                x = Math.round(new Float(new Double(imageWidth) / new Double(length) * unit * (double)i).floatValue());
                index = String.valueOf(new Double(unit * (double)i).intValue());
            } else {
                x = 100 * i;
                index = String.valueOf(sequenceUnit * i);
            }
            graphics2D.drawLine(x, bufferedImage.getHeight() - 50, x, bufferedImage.getHeight() - 50 + 10);
            if (i < num || i == num && ((double)length - unit * (double)num >= unit / 2.0 && useDefault || length - sequenceUnit * num >= sequenceUnit / 2 && !useDefault)) {
                graphics2D.drawString(index, x, bufferedImage.getHeight() - 24);
            }
            ++i;
        }
    }

    private static int getCountMax(Map<Integer, Integer> posCount) {
        int max = 0;
        for (Integer count : posCount.values()) {
            if (count <= max) continue;
            max = count;
        }
        return max;
    }

    private static void initializeBufferedImage(Map<Integer, Integer> posCount, int exonSize, File image) {
        imageWidth = 1000;
        unit = 100.0;
        useDefault = true;
        num = 0;
        if (exonSize < 40000) {
            unit = DrawChart.getUnit(exonSize);
            num = new Double((double)exonSize / unit).intValue();
        }
        bufferedImage = new BufferedImage(imageWidth, 600, 9);
    }

    private static void initializeGraphics2D(Map<Integer, Integer> posCount, int exonSize, File image) {
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private static void drawSequence(Map<Integer, Integer> posCount, int exonSize, File image) {
        int length = exonSize;
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.draw3DRect(0, bufferedImage.getHeight() - 50, bufferedImage.getWidth(), 10, true);
        graphics2D.fill3DRect(0, bufferedImage.getHeight() - 50, bufferedImage.getWidth(), 10, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(1, bufferedImage.getHeight() - 50, 1, bufferedImage.getHeight() - 50 + 10);
        graphics2D.drawString("1", 1, bufferedImage.getHeight() - 24);
        graphics2D.drawLine(bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 50, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 50 + 10);
        graphics2D.drawString(new Integer(length).toString(), bufferedImage.getWidth() - new Integer(length).toString().length() * 8, bufferedImage.getHeight() - 24);
        int x = 0;
        String index = null;
        int i = 1;
        while (i <= num) {
            if (useDefault) {
                x = Math.round(new Float(new Double(imageWidth) / new Double(length) * unit * (double)i).floatValue());
                index = String.valueOf(new Double(unit * (double)i).intValue());
            } else {
                x = 100 * i;
                index = String.valueOf(sequenceUnit * i);
            }
            graphics2D.drawLine(x, bufferedImage.getHeight() - 50, x, bufferedImage.getHeight() - 50 + 10);
            if (i < num || i == num && ((double)length - unit * (double)num >= unit / 2.0 && useDefault || length - sequenceUnit * num >= sequenceUnit / 2 && !useDefault)) {
                graphics2D.drawString(index, x, bufferedImage.getHeight() - 24);
            }
            ++i;
        }
    }

    private static void writeImageToFile(File imageFile) {
        FileImageOutputStream fileImageOutputStream = null;
        ImageWriter imageWriter = null;
        try {
            try {
                fileImageOutputStream = new FileImageOutputStream(imageFile);
                imageWriter = ImageIO.getImageWritersByFormatName(PNG).next();
                imageWriter.setOutput(fileImageOutputStream);
                imageWriter.write(bufferedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fileImageOutputStream != null) {
                    try {
                        fileImageOutputStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
            }
        }
        finally {
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static double getUnit(int length) {
        num = length;
        i = 0;
        if (!((double)length <= 5.0)) ** GOTO lbl6
        return 1.0;
lbl-1000:
        // 1 sources

        {
            num = new Double((double)length / Math.pow(10.0, ++i));
lbl6:
            // 2 sources

            ** while (num > 10.0)
        }
lbl7:
        // 1 sources

        if (num > 5.0) {
            return Math.pow(10.0, i);
        }
        j = 1;
        while (num * (double)j * 2.0 < 5.0) {
            ++j;
        }
        return Math.pow(10.0, i) / new Double(j * 2);
    }
}

