/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import misc.FileManager;

public class Demultiplex {
    public static void main(String[] args) throws Exception {
        File indexFile = new File(args[0]);
        File read1File = new File(args[1]);
        File read2File = new File(args[2]);
        File barcodeFile = new File(args[3]);
        File outputDir = new File(args[4]);
        boolean withLimit = new Boolean(args[5]);
        int limit = 100;
        int noMatchCount = 0;
        Map<String, String> barcodeMap = Demultiplex.initBarcodeMap(barcodeFile);
        Map<String, Integer> barcodeCount = Demultiplex.initBarcodeCount(barcodeMap);
        BufferedReader indexReader = new BufferedReader(new FileReader(indexFile));
        BufferedReader read1Reader = new BufferedReader(new FileReader(read1File));
        BufferedReader read2Reader = new BufferedReader(new FileReader(read2File));
        try {
            String line;
            String name = null;
            String sequence = null;
            String qualityChars = null;
            boolean isSeq = false;
            int count = 0;
            int lineCount = 0;
            String header = null;
            while ((line = indexReader.readLine()) != null) {
                if (++lineCount == 1) {
                    header = line.split(":")[0];
                    System.out.println("detect header : " + header);
                }
                if (line.startsWith(header)) {
                    name = line.trim().split("\\s+")[0];
                    isSeq = true;
                } else if (line.startsWith("+") && line.trim().length() == 1) {
                    isSeq = false;
                } else if (isSeq) {
                    sequence = line.trim();
                } else {
                    qualityChars = line.trim();
                }
                if (sequence != null && qualityChars != null) {
                    if (barcodeMap.keySet().contains(sequence)) {
                        Demultiplex.appendToFile(read1Reader, outputDir, barcodeMap.get(sequence));
                        Demultiplex.appendToFile(read2Reader, outputDir, barcodeMap.get(sequence));
                        barcodeCount.put(sequence, barcodeCount.get(sequence) + 1);
                    } else {
                        Demultiplex.jumpLines(read1Reader, 4);
                        Demultiplex.jumpLines(read2Reader, 4);
                        ++noMatchCount;
                    }
                    ++count;
                    sequence = null;
                    qualityChars = null;
                    name = null;
                }
                if (count > limit && withLimit) break;
            }
            System.out.println("processed barcodes " + lineCount / 4);
            System.out.println("noMatch Count " + noMatchCount);
            for (String barcode : barcodeCount.keySet()) {
                System.out.println(String.valueOf(barcodeMap.get(barcode)) + " : " + barcodeCount.get(barcode));
            }
        }
        finally {
            indexReader.close();
            read1Reader.close();
            read2Reader.close();
        }
    }

    private static Map<String, Integer> initBarcodeCount(Map<String, String> barcodeMap) {
        HashMap<String, Integer> barcodeCount = new HashMap<String, Integer>();
        for (String barcode : barcodeMap.keySet()) {
            barcodeCount.put(barcode, 0);
        }
        return barcodeCount;
    }

    private static void appendToFile(BufferedReader readReader, File outputDir, String name) throws Exception {
        File targetFile = new File(outputDir, String.valueOf(name) + ".fq");
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile, true));
        String[] nameLine = readReader.readLine().trim().split("\\s+");
        writer.write(nameLine[0].trim());
        writer.write("\n");
        writer.write(readReader.readLine().trim());
        writer.write("\n");
        writer.write(readReader.readLine().trim());
        writer.write("\n");
        writer.write(readReader.readLine().trim());
        writer.write("\n");
        writer.close();
    }

    private static void jumpLines(BufferedReader readReader, int step) throws Exception {
        int i = 0;
        while (i < step) {
            readReader.readLine();
            ++i;
        }
    }

    private static Map<String, String> initBarcodeMap(File barcodeFile) {
        String[] lines;
        HashMap<String, String> barcodeCount = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(barcodeFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split(",");
            String barcode = items[0].trim();
            String name = items[1].trim();
            barcodeCount.put(Demultiplex.revComp(barcode), name);
            ++n2;
        }
        System.out.println(String.valueOf(barcodeCount.size()) + " total barcodes");
        return barcodeCount;
    }

    private static String revComp(String seq) {
        StringBuilder builder = new StringBuilder();
        int i = seq.length() - 1;
        while (i >= 0) {
            builder.append(Demultiplex.complement(seq.charAt(i)));
            --i;
        }
        return builder.toString();
    }

    public static char complement(char base) {
        if (base == 'a' || base == 'A') {
            return 'T';
        }
        if (base == 't' || base == 'T') {
            return 'A';
        }
        if (base == 'c' || base == 'C') {
            return 'G';
        }
        if (base == 'g' || base == 'G') {
            return 'C';
        }
        if (base == 'n' || base == 'N') {
            return 'N';
        }
        return base;
    }
}

