/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.MatchUnit;
import fileOperation.OneMatch;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;
import misc.StreamReaderThread;

public class CrossMatchforKir {
    static double MIS_MATCH_CUTOFF = 5.0;
    static int EXON_MIN_MATCH_SIZE = 20;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File kirSeqFile = new File(args[1]);
        File kirExonFile = new File(args[2]);
        File outputFile = new File(args[3]);
        CrossMatchforKir.match(fastaFile, kirSeqFile, kirExonFile, outputFile);
    }

    public static void match(File fastaFile, File kirSeqFile, File kirExonFile, File outputFile) throws Exception {
        Map<String, Map<Integer, MatchUnit>> exons = CrossMatchforKir.parseExons(kirExonFile);
        StringBuilder output = new StringBuilder();
        String cmd = "/genome/bin/cross_match " + fastaFile + " " + kirSeqFile;
        System.out.println(cmd);
        String result = OsHelper.excuteCommand(cmd);
        CrossMatchforKir.parseResult(result, exons, output);
        FileManager.writeTextFile(outputFile, output.toString(), true);
    }

    private static Map<String, Map<Integer, MatchUnit>> parseExons(File kirExonFile) {
        String[] data;
        LinkedHashMap<String, Map<Integer, MatchUnit>> exons = new LinkedHashMap<String, Map<Integer, MatchUnit>>();
        String[] stringArray = data = FileManager.readTextFile(kirExonFile).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split("\\s+");
            if (items.length >= 4) {
                String gene = items[0].trim();
                if (!exons.containsKey(gene)) {
                    exons.put(gene, new LinkedHashMap());
                }
                int exonNum = Integer.valueOf(items[1]);
                int exonStart = Integer.valueOf(items[2]);
                int exonEnd = Integer.valueOf(items[3]);
                MatchUnit unit = new MatchUnit(exonStart, exonEnd);
                ((Map)exons.get(gene)).put(new Integer(exonNum), unit);
            }
            ++n2;
        }
        return exons;
    }

    private static void parseResult(String crossmatchout, Map<String, Map<Integer, MatchUnit>> exons, StringBuilder output) {
        String[] result = crossmatchout.split("\n");
        HashMap<String, List<OneMatch>> matches = new HashMap<String, List<OneMatch>>();
        String[] stringArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] data = line.trim().split("\\s+");
            if (data.length >= 12 && data[4].length() >= 30) {
                OneMatch oneMatch;
                String gene = null;
                gene = data[8].trim().length() == 1 && data[8].trim().charAt(0) == 'C' ? CrossMatchforKir.getGene(data[9].trim()) : CrossMatchforKir.getGene(data[8].trim());
                if (!matches.containsKey(gene)) {
                    matches.put(gene, new ArrayList());
                }
                if ((oneMatch = CrossMatchforKir.generateMatch(data)) != null) {
                    ((List)matches.get(gene)).add(oneMatch);
                }
            }
            ++n2;
        }
        CrossMatchforKir.summarilze(matches, exons, output);
    }

    private static void summarilze(Map<String, List<OneMatch>> matches, Map<String, Map<Integer, MatchUnit>> exons, StringBuilder output) {
        for (String gene : exons.keySet()) {
            output.append("****").append(gene).append("\n");
            if (matches.containsKey(gene)) {
                Map<Integer, List<OneMatch>> matchByExon = CrossMatchforKir.sortByExon(matches.get(gene), exons.get(gene));
                CrossMatchforKir.outputByExon(matchByExon, exons.get(gene), output);
                continue;
            }
            output.append("0 matches\n");
        }
    }

    private static void outputByExon(Map<Integer, List<OneMatch>> matchByExon, Map<Integer, MatchUnit> exonMap, StringBuilder output) {
        for (int num : exonMap.keySet()) {
            output.append("exon").append(num);
            if (!matchByExon.containsKey(num)) {
                output.append("\t-").append("\n");
                continue;
            }
            int count = 0;
            int forwardCount = 0;
            double sizeSum = 0.0;
            double sumMisMatch = 0.0;
            for (OneMatch match : matchByExon.get(num)) {
                ++count;
                forwardCount += match.isForwardExist() ? 1 : 0;
                sizeSum += CrossMatchforKir.getSize(match);
                sumMisMatch += CrossMatchforKir.getMisMatch(match);
            }
            output.append("\ttotal matches=").append(count).append(", average size=").append(CrossMatchforKir.formatInt(sizeSum / (double)count)).append(", average mismatch=").append(CrossMatchforKir.formatDouble(sumMisMatch / (double)count)).append(", forwardCount=").append(forwardCount).append(", reverseCount=").append(count - forwardCount).append("\n");
        }
    }

    private static Object formatInt(double d) {
        DecimalFormat df = new DecimalFormat("#");
        return df.format(d);
    }

    private static Object formatDouble(double d) {
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(d);
    }

    private static double getMisMatch(OneMatch match) {
        if (match.isForwardExist()) {
            return match.getForwardMisMatch();
        }
        return match.getReverseMisMatch();
    }

    private static double getSize(OneMatch match) {
        if (match.isForwardExist()) {
            return match.getForwardEnd() - match.getForwardStart();
        }
        return match.getReverseEnd() - match.getReverseStart();
    }

    private static Map<Integer, List<OneMatch>> sortByExon(List<OneMatch> list, Map<Integer, MatchUnit> exonMap) {
        HashMap<Integer, List<OneMatch>> matchByExon = new HashMap<Integer, List<OneMatch>>();
        for (OneMatch oneMatch : list) {
            int start = 0;
            int end = 0;
            if (oneMatch.isForwardExist()) {
                start = oneMatch.getForwardStart();
                end = oneMatch.getForwardEnd();
            } else {
                start = oneMatch.getReverseStart();
                end = oneMatch.getReverseEnd();
            }
            int exonNum = CrossMatchforKir.findExonNum(start, end, exonMap);
            if (exonNum == -1) {
                System.out.println("can locate in exon " + oneMatch.getName());
                continue;
            }
            if (!matchByExon.containsKey(new Integer(exonNum))) {
                matchByExon.put(exonNum, new ArrayList());
            }
            ((List)matchByExon.get(exonNum)).add(oneMatch);
        }
        return matchByExon;
    }

    private static int findExonNum(int start, int end, Map<Integer, MatchUnit> exonMap) {
        for (Integer num : exonMap.keySet()) {
            int eStart = exonMap.get(num).getMatchStart();
            int eEnd = exonMap.get(num).getMatchEnd();
            if (end < eStart || start > eEnd) continue;
            if (start < eStart && end > eEnd) {
                return num;
            }
            if (start > eStart && end < eEnd) {
                return num;
            }
            if (Math.min(end, eEnd) - Math.max(start, eStart) <= EXON_MIN_MATCH_SIZE) continue;
            return num;
        }
        return -1;
    }

    private static OneMatch generateMatch(String[] data) {
        OneMatch oneMatch = new OneMatch();
        oneMatch.setForwardExist(false);
        oneMatch.setReverseExist(false);
        String name = data[4].trim();
        oneMatch.setName(name);
        int score = Integer.valueOf(data[0].trim());
        double mismatch = Double.valueOf(data[1].trim());
        if (mismatch > MIS_MATCH_CUTOFF) {
            return null;
        }
        if (data[8].trim().length() == 1 && data[8].trim().charAt(0) == 'C') {
            oneMatch.setReverseExist(true);
            oneMatch.setReverseMatchSize(score);
            oneMatch.setReverseMisMatch(mismatch);
            oneMatch.setReverseStart(Integer.valueOf(data[12].trim()));
            oneMatch.setReverseEnd(Integer.valueOf(data[11].trim()));
        } else {
            oneMatch.setForwardExist(true);
            oneMatch.setForwardMatchSize(score);
            oneMatch.setForwardMisMatch(mismatch);
            oneMatch.setForwardStart(Integer.valueOf(data[9].trim()));
            oneMatch.setForwardEnd(Integer.valueOf(data[10].trim()));
        }
        return oneMatch;
    }

    private static String getGene(String target) {
        return target.substring(target.length() - 4, target.length());
    }

    public static void runCmd(String cmd, File dir) {
        block6: {
            String data = null;
            InputStream inputStream = null;
            InputStream errorStream = null;
            StringBuffer err = new StringBuffer();
            StringBuffer out = new StringBuffer();
            try {
                Process proc = Runtime.getRuntime().exec(cmd, null, dir);
                inputStream = proc.getInputStream();
                errorStream = proc.getErrorStream();
                StreamReaderThread outThread = new StreamReaderThread(inputStream, out, true);
                StreamReaderThread errThread = new StreamReaderThread(errorStream, err, true);
                outThread.start();
                errThread.start();
                int result = proc.waitFor();
                outThread.join();
                errThread.join();
                data = out.toString();
            }
            catch (IOException ioe) {
                System.err.println("an I/O error occurs" + ioe.toString());
                System.exit(1);
                CrossMatchforKir.closeInputStream(inputStream);
                CrossMatchforKir.closeInputStream(errorStream);
                break block6;
            }
            catch (InterruptedException e) {
                try {
                    System.err.println("Interrupted waiting for process!");
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    CrossMatchforKir.closeInputStream(inputStream);
                    CrossMatchforKir.closeInputStream(errorStream);
                    throw throwable;
                }
                CrossMatchforKir.closeInputStream(inputStream);
                CrossMatchforKir.closeInputStream(errorStream);
                break block6;
            }
            CrossMatchforKir.closeInputStream(inputStream);
            CrossMatchforKir.closeInputStream(errorStream);
        }
    }

    private static void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static File makeDirs(File outputRoot) {
        File phdDir = new File(outputRoot, "phd_dir");
        File assemblyDir = new File(outputRoot, "assembly");
        File chromatDir = new File(outputRoot, "chromat_dir");
        if (!phdDir.isDirectory()) {
            phdDir.mkdirs();
        }
        if (!assemblyDir.isDirectory()) {
            assemblyDir.mkdirs();
        }
        if (!chromatDir.isDirectory()) {
            chromatDir.mkdirs();
        }
        return phdDir;
    }
}

