/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import dataFix.ChromatVO;
import dataFix.RenameCelllineByTable;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;

public class CrossMatchSeq {
    static int SIZE = 25;

    public static void main(String[] args) throws Exception {
        File backBones = new File(args[0]);
        String project = args[1];
        File outputRoot = new File(args[2]);
        File output = new File(args[3]);
        String label = args[4];
        List<ChromatVO> chromats = CrossMatchSeq.getChromatFromDB(project);
        Map<String, String> backboneMap = CrossMatchSeq.getBackboneMap(backBones);
        ArrayList<ChromatVO> lowQualityReads = new ArrayList<ChromatVO>();
        HashMap<String, List<ChromatVO>> matchedReads = new HashMap<String, List<ChromatVO>>();
        ArrayList<ChromatVO> noMatchReads = new ArrayList<ChromatVO>();
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append("ChromatId,").append("Source,").append("Coord,").append("Seq primer,").append("Q20,").append("Q40,").append("Positive,").append("score,").append("possible,\n");
        for (ChromatVO chromatVO : chromats) {
            outputBuilder.append(chromatVO.getId()).append(",").append(chromatVO.getCellLineName()).append(",").append(chromatVO.getCoordinate()).append(",").append(chromatVO.getSequencingPrimerName()).append(",").append(chromatVO.getQ20()).append(",").append(chromatVO.getQ40()).append(",");
            if (chromatVO.getGoodEnd() - chromatVO.getGoodStart() < SIZE) {
                lowQualityReads.add(chromatVO);
                outputBuilder.append("LowQ").append(",").append("-,\n");
                continue;
            }
            CrossMatchSeq.crossMatchChromat(chromatVO, backBones, matchedReads, noMatchReads, outputBuilder, label);
        }
        for (String backbone : matchedReads.keySet()) {
            File amplicon = new File(outputRoot, backbone);
            if (!amplicon.isDirectory()) {
                amplicon.mkdir();
            }
            File chromat_dir = new File(amplicon, "chromat_dir");
            File phd_dir = new File(amplicon, "phd_dir");
            File assembly = new File(amplicon, "assembly");
            if (!chromat_dir.isDirectory()) {
                chromat_dir.mkdir();
                phd_dir.mkdir();
                assembly.mkdir();
            }
            CrossMatchSeq.copyFiles(chromat_dir, (List)matchedReads.get(backbone));
        }
        CrossMatchSeq.copyReads(outputRoot, noMatchReads, "noMatch");
        System.out.println("done for no match reads ");
        CrossMatchSeq.copyReads(outputRoot, lowQualityReads, "lowQuality");
        System.out.println("done for lowQualityReads ");
        System.out.println("lowQualityReads " + lowQualityReads.size());
        System.out.println("noMatchReads " + noMatchReads.size());
        FileManager.writeTextFile(output, outputBuilder.toString(), true);
    }

    private static Map<String, String> getBackboneMap(File backBones) {
        HashMap<String, String> backboneMap = new HashMap<String, String>();
        String[] lines = FileManager.readTextFile(backBones).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].startsWith(">")) {
                backboneMap.put(lines[i].trim().substring(1, lines[i].trim().length()), lines[i + 1].trim());
            }
            ++i;
        }
        System.out.println(String.valueOf(backboneMap.size()) + " backbones total");
        for (String name : backboneMap.keySet()) {
            System.out.println(String.valueOf(name) + " " + ((String)backboneMap.get(name)).length());
        }
        return backboneMap;
    }

    private static void copyReads(File outputRoot, List<ChromatVO> noMatchReads, String name) {
        File amplicon = new File(outputRoot, name);
        if (!amplicon.isDirectory()) {
            amplicon.mkdir();
        }
        File chromat_dir = new File(amplicon, "chromat_dir");
        File phd_dir = new File(amplicon, "phd_dir");
        File assembly = new File(amplicon, "assembly");
        if (!chromat_dir.isDirectory()) {
            chromat_dir.mkdir();
            phd_dir.mkdir();
            assembly.mkdir();
        }
        CrossMatchSeq.copyFiles(chromat_dir, noMatchReads);
    }

    private static void copyFiles(File chromat_dir, List<ChromatVO> list) {
        for (ChromatVO chromatVO : list) {
            FileManager.copyFile(FileManager.getFile(chromatVO.getId(), new File("/home/gemsd/GeMS/GeMSFileSystem/")), new File(chromat_dir, String.valueOf(chromatVO.getCellLineName()) + "_" + chromatVO.getSequencingPrimerName()), true);
        }
    }

    private static void crossMatchChromat(ChromatVO chromatVO, File backBones, Map<String, List<ChromatVO>> matchedReads, List<ChromatVO> noMatchReads, StringBuilder outputBuilder, String label) throws Exception {
        String[] out;
        File tmpFile = File.createTempFile("crossm", "fa");
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(chromatVO.getId()).append("\n");
        builder.append(chromatVO.getSequence().substring(chromatVO.getGoodStart(), chromatVO.getGoodEnd()));
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        String cmd = "/genome/bin/cross_match -minscore 20 " + tmpFile.getAbsolutePath() + " " + backBones;
        String data = OsHelper.excuteCommand(cmd);
        if (data.indexOf("0 matching entries") > 0) {
            outputBuilder.append("NoMatch").append(",").append("-,\n");
            noMatchReads.add(chromatVO);
            return;
        }
        if (data.indexOf("Maximal single base matches") < 0 || data.indexOf("1 matching entries") < 0) {
            outputBuilder.append("??").append(",").append("-,\n");
            System.out.println("unknown " + chromatVO.getId() + " " + chromatVO.getSequence().substring(chromatVO.getGoodStart(), chromatVO.getGoodEnd()));
            return;
        }
        int start = data.indexOf("Maximal single base matches");
        int end = data.indexOf("1 matching entries");
        String[] stringArray = out = data.substring(start, end).split("\n");
        int n = out.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(chromatVO.getId()) > 0) {
                String[] elems;
                System.out.println(line);
                String[] stringArray2 = elems = line.trim().split("\\s+");
                int n3 = elems.length;
                int n4 = 0;
                while (n4 < n3) {
                    String elem = stringArray2[n4];
                    if (elem.trim().indexOf(label) >= 0) {
                        outputBuilder.append(elem.trim()).append(",").append(elems[0].trim()).append(",");
                        if (!matchedReads.containsKey(elem.trim())) {
                            matchedReads.put(elem.trim(), new ArrayList());
                        }
                        matchedReads.get(elem.trim()).add(chromatVO);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        outputBuilder.append("\n");
    }

    private static List<ChromatVO> getChromatFromDB(String project) {
        String destDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(destDBurl, "gems", "Caff1ne");
            PreparedStatement preparedStatement = null;
            String selectSql = "select distinct chromat_id, cell_line_name, seq_primer_name, coordinate, base_count_q20, base_count_default from pcr.chromat_report_mv where project_name = ?";
            preparedStatement = srcDB.prepareStatement(selectSql);
            preparedStatement.setString(1, project);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<ChromatVO> chromats = new ArrayList<ChromatVO>();
            ChromatVO chromatVO = null;
            while (resultSet.next()) {
                chromatVO = new ChromatVO();
                chromatVO.setId(resultSet.getString(1));
                chromatVO.setCellLineName(resultSet.getString(2));
                chromatVO.setSequencingPrimerName(resultSet.getString(3));
                chromatVO.setCoordinate(resultSet.getString(4));
                chromatVO.setQ20(resultSet.getInt(5));
                chromatVO.setQ40(resultSet.getInt(6));
                CrossMatchSeq.addSequence(chromatVO, srcDB);
                chromats.add(chromatVO);
            }
            RenameCelllineByTable.closeResources(null, null, srcDB);
            return chromats;
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
            return null;
        }
    }

    private static void addSequence(ChromatVO chromatVO, Connection srcDB) {
        PreparedStatement preparedStatement = null;
        String selectSql = "select sequence, good_read_start, good_read_end from core.chromat where chromat_id = ?";
        try {
            preparedStatement = srcDB.prepareStatement(selectSql);
            preparedStatement.setString(1, chromatVO.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                chromatVO.setSequence(resultSet.getString(1));
                chromatVO.setGoodStart(resultSet.getInt(2));
                chromatVO.setGoodEnd(resultSet.getInt(3));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

