/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import misc.FileManager;

public class CrossCheckingAmbiguity {
    public static void main(String[] args) throws Exception {
        File[] files;
        File inputDir = new File(args[0]);
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".fa")) {
                System.out.println(file.getName());
                File ambFile = new File(inputDir, String.valueOf(file.getName().substring(0, file.getName().length() - 3)) + "-hap-amb.txt");
                CrossCheckingAmbiguity.checkAmbiguity(file, ambFile);
            }
            ++n2;
        }
    }

    private static void checkAmbiguity(File file, File ambFile) {
        HashMap<String, String> hapNames = new HashMap<String, String>();
        if (ambFile.exists()) {
            CrossCheckingAmbiguity.populateHapAmbNames(hapNames, ambFile);
        }
        CrossCheckingAmbiguity.check(CrossCheckingAmbiguity.organizeFastaByHap(hapNames, file));
    }

    private static void check(Map<String, String> organizeFastaByHap) {
        HashMap<String, String> uniqueSeq = new HashMap<String, String>();
        for (String type : organizeFastaByHap.keySet()) {
            String seq = organizeFastaByHap.get(type);
            if (!uniqueSeq.containsKey(seq)) {
                uniqueSeq.put(seq, type);
                continue;
            }
            System.out.println("!!! " + type + " = " + (String)uniqueSeq.get(seq));
        }
    }

    public static Map<String, String> organizeFastaByHap(Map<String, String> hapAmbNames, File fastaFile) {
        HashMap<String, String> uniqueSeq = new HashMap<String, String>();
        ArrayList<String> existAmbTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (!hapAmbNames.containsKey(name)) {
                    uniqueSeq.put(name, sequence);
                } else {
                    String gname = hapAmbNames.get(name);
                    if (!existAmbTypes.contains(gname)) {
                        uniqueSeq.put(gname, sequence);
                        existAmbTypes.add(gname);
                    }
                }
            }
            ++i;
        }
        return uniqueSeq;
    }

    public static void populateHapAmbNames(Map<String, String> hapNames, File hapAmbFile) {
        String[] lines;
        String[] stringArray = lines = FileManager.readTextFile(hapAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    hapNames.put(items[i].trim(), gname);
                    ++i;
                }
            }
            ++n2;
        }
    }
}

