/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.BatchConvertFastaQdataMiSeq;
import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.MatchUnit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import misc.FileManager;
import misc.SystemCommand;

public class ConvertFastaQdataSelectFixQuality {
    static int BASE = 33;
    static String PREFIX = "M00116";

    public static void main(String[] args) throws Exception {
        File fastaqFile = new File(args[0]);
        File outputRoot = new File(args[1]);
        File names = new File(args[2]);
        File existPhdDir = new File(args[3]);
        File phdDir = ConvertFastaQdataSelectFixQuality.makeDirs(outputRoot);
        List<String> fNames = ConvertFastaQdataSelectFixQuality.getAllNames(names);
        BufferedReader reader = new BufferedReader(new FileReader(fastaqFile));
        try {
            String line;
            String name = null;
            String sequence = null;
            String qualityChars = null;
            boolean isSeq = false;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("@") && fNames.contains(line.trim().substring(1, line.trim().length() - 2))) {
                    name = ConvertFastaQdataMiSeq.generateName(line.trim().substring(1));
                    isSeq = true;
                    System.out.println("find name " + name);
                } else if (line.startsWith("+") && fNames.contains(line.trim().substring(1))) {
                    isSeq = false;
                } else if (isSeq) {
                    sequence = line.trim();
                } else {
                    qualityChars = line.trim();
                }
                if (sequence == null || qualityChars == null) continue;
                if (!ConvertFastaQdataSelectFixQuality.isFileExist(existPhdDir, name)) {
                    System.out.println("write name " + name);
                    ConvertFastaQdataSelectFixQuality.writePhdFile(phdDir, name, sequence, qualityChars);
                }
                sequence = null;
                qualityChars = null;
                name = null;
                isSeq = false;
            }
            BatchConvertFastaQdataMiSeq.runCmd("/genome/bin/phredPhrap ", new File(outputRoot, "assembly"));
        }
        finally {
            reader.close();
        }
    }

    private static MatchUnit setTrimStartAndEnd(String qualityChars, double trimCutoff) {
        MatchUnit unit = new MatchUnit(0, 0);
        unit.setMatchStart(0);
        unit.setMatchEnd(qualityChars.length());
        return unit;
    }

    public static int writePhdFile(File phdDir, String name, String sequence, String qualityChars) throws Exception {
        MatchUnit unit = ConvertFastaQdataSelectFixQuality.setTrimStartAndEnd(qualityChars, 0.025);
        if (unit.getMatchStart() == unit.getMatchEnd()) {
            return 0;
        }
        File tmpFile = File.createTempFile("chromat", "fa");
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(name).append("\n");
        builder.append(sequence.substring(unit.getMatchStart(), unit.getMatchEnd()));
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        SystemCommand command = new SystemCommand("/usr/local/bin/perl /genome/bin/fasta2Phd.perl " + tmpFile.getAbsolutePath(), phdDir, false);
        command.makeItSo();
        File phdFile = new File(phdDir, String.valueOf(tmpFile.getName()) + ".phd.1");
        int beginDNA = 0;
        int endDNA = 0;
        StringBuilder out = new StringBuilder();
        String[] data = FileManager.readTextFile(phdFile).split("\n");
        int i = 0;
        while (i < data.length) {
            if (data[i].indexOf("BEGIN_DNA") >= 0) {
                beginDNA = i;
            }
            if (data[i].indexOf("END_DNA") >= 0) {
                endDNA = i;
            }
            ++i;
        }
        out.append("BEGIN_SEQUENCE " + name);
        i = 1;
        while (i <= beginDNA) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        i = beginDNA + 1;
        while (i < endDNA) {
            String[] info = data[i].trim().split("\\s+");
            if (!info[0].equals(new String("."))) {
                out.append(info[0]).append(" ");
            } else {
                out.append("n").append(" ");
            }
            char quality = qualityChars.substring(unit.getMatchStart(), unit.getMatchEnd()).charAt(i - beginDNA - 1);
            out.append(20).append(" ");
            out.append(info[2]).append("\n");
            ++i;
        }
        i = endDNA;
        while (i < data.length) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        FileManager.writeTextFile(phdFile, out.toString(), true);
        phdFile.renameTo(new File(phdDir, String.valueOf(name) + ".phd.1"));
        FileManager.delete(tmpFile);
        return 1;
    }

    private static boolean isFileExist(File existPhdDir, String name) {
        File phdFile = new File(existPhdDir, String.valueOf(name) + ".phd.1");
        if (phdFile.exists()) {
            System.out.println("exist " + name);
            return true;
        }
        return false;
    }

    private static List<String> getAllNames(File fnames) {
        String[] lines;
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = lines = FileManager.readTextFile(fnames).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] data;
            String line = stringArray[n2];
            String[] stringArray2 = data = line.split("\\s+");
            int n3 = data.length;
            int n4 = 0;
            while (n4 < n3) {
                String item = stringArray2[n4];
                if (item.startsWith(PREFIX)) {
                    names.add(item.trim().substring(0, item.trim().length() - 2));
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return names;
    }

    private static File makeDirs(File outputRoot) {
        File phdDir = new File(outputRoot, "phd_dir");
        File assemblyDir = new File(outputRoot, "assembly");
        File chromatDir = new File(outputRoot, "chromat_dir");
        if (!phdDir.isDirectory()) {
            phdDir.mkdirs();
        }
        if (!assemblyDir.isDirectory()) {
            assemblyDir.mkdirs();
        }
        if (!chromatDir.isDirectory()) {
            chromatDir.mkdirs();
        }
        return phdDir;
    }
}

