/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.BatchConvertFastaQdataMiSeq;
import fileOperation.MatchUnit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import misc.FileManager;
import misc.SystemCommand;

public class ConvertFastaQdataSelectEd {
    static int BASE = 33;
    static String PREFIX = "@M00474:86:000000000";
    static int LIMIT = 60;

    public static void main(String[] args) throws Exception {
        File fastaqFile = new File(args[0]);
        File outputRoot = new File(args[1]);
        File names = new File(args[2]);
        File existPhdDir = new File(args[3]);
        boolean withLimit = new Boolean(args[4]);
        String nameList = FileManager.readTextFile(names);
        ConvertFastaQdataSelectEd.process(fastaqFile, outputRoot, nameList, existPhdDir, withLimit);
    }

    public static void process(File fastaqFile, File outputRoot, String nameList, File existPhdDir, boolean withLimit) throws FileNotFoundException, IOException, Exception {
        File phdDir = ConvertFastaQdataSelectEd.makeDirs(outputRoot);
        List<String> fNames = ConvertFastaQdataSelectEd.getAllNames(nameList);
        BufferedReader reader = new BufferedReader(new FileReader(fastaqFile));
        try {
            String line;
            String name = null;
            String sequence = null;
            String qualityChars = null;
            boolean isSeq = false;
            int count = 0;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("@") && fNames.contains(line.trim().split("\\s+")[0])) {
                    name = ConvertFastaQdataSelectEd.generateName(line.trim().substring(1));
                    isSeq = true;
                    System.out.println("find name " + name);
                } else if (line.startsWith("+") && line.trim().length() == 1) {
                    isSeq = false;
                } else if (isSeq) {
                    sequence = line.trim();
                } else {
                    qualityChars = line.trim();
                }
                if (sequence == null || qualityChars == null) continue;
                if (!ConvertFastaQdataSelectEd.isFileExist(existPhdDir, name)) {
                    System.out.println("write name " + name);
                    ConvertFastaQdataSelectEd.writePhdFile(phdDir, name, sequence, qualityChars);
                    if (++count > LIMIT && withLimit) {
                        System.out.println("reach max number selected ");
                        break;
                    }
                    if (count > 3000 && !withLimit) {
                        System.out.println("reach max number selected ");
                        break;
                    }
                }
                sequence = null;
                qualityChars = null;
                name = null;
                isSeq = false;
            }
            BatchConvertFastaQdataMiSeq.runCmd("/genome/bin/phredPhrap ", new File(outputRoot, "assembly"));
        }
        finally {
            reader.close();
        }
    }

    public static String generateName(String line) {
        String[] items = line.split("\\s+");
        String index = items[1].substring(0, 1);
        String[] items1 = items[0].split(":");
        String name = String.valueOf(items1[items1.length - 3]) + "-" + items1[items1.length - 2] + "-" + items1[items1.length - 1] + "-" + index;
        return name;
    }

    private static MatchUnit setTrimStartAndEnd(String qualityChars, double trimCutoff) {
        MatchUnit unit = new MatchUnit(0, 0);
        unit.setMatchStart(0);
        unit.setMatchEnd(qualityChars.length());
        return unit;
    }

    public static int writePhdFile(File phdDir, String name, String sequence, String qualityChars) throws Exception {
        MatchUnit unit = ConvertFastaQdataSelectEd.setTrimStartAndEnd(qualityChars, 0.025);
        if (unit.getMatchStart() == unit.getMatchEnd()) {
            return 0;
        }
        File tmpFile = File.createTempFile("chromat", "fa");
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(name).append("\n");
        builder.append(sequence.substring(unit.getMatchStart(), unit.getMatchEnd()));
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        SystemCommand command = new SystemCommand("/usr/bin/perl /genome/bin/fasta2Phd.perl " + tmpFile.getAbsolutePath(), phdDir, false);
        command.makeItSo();
        File phdFile = new File(phdDir, String.valueOf(tmpFile.getName()) + ".phd.1");
        int beginDNA = 0;
        int endDNA = 0;
        StringBuilder out = new StringBuilder();
        String[] data = FileManager.readTextFile(phdFile).split("\n");
        int i = 0;
        while (i < data.length) {
            if (data[i].indexOf("BEGIN_DNA") >= 0) {
                beginDNA = i;
            }
            if (data[i].indexOf("END_DNA") >= 0) {
                endDNA = i;
            }
            ++i;
        }
        out.append("BEGIN_SEQUENCE " + name);
        i = 1;
        while (i <= beginDNA) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        i = beginDNA + 1;
        while (i < endDNA) {
            String[] info = data[i].trim().split("\\s+");
            if (!info[0].equals(new String("."))) {
                out.append(info[0]).append(" ");
            } else {
                out.append("n").append(" ");
            }
            char quality = qualityChars.substring(unit.getMatchStart(), unit.getMatchEnd()).charAt(i - beginDNA - 1);
            out.append(quality - BASE).append(" ");
            out.append(info[2]).append("\n");
            ++i;
        }
        i = endDNA;
        while (i < data.length) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        FileManager.writeTextFile(phdFile, out.toString(), true);
        phdFile.renameTo(new File(phdDir, String.valueOf(name) + ".phd.1"));
        FileManager.delete(tmpFile);
        return 1;
    }

    private static boolean isFileExist(File existPhdDir, String name) {
        File phdFile = new File(existPhdDir, String.valueOf(name) + ".phd.1");
        if (phdFile.exists()) {
            System.out.println("exist " + name);
            return true;
        }
        return false;
    }

    private static List<String> getAllNames(String fnames) {
        String[] lines;
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = lines = fnames.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] data;
            String line = stringArray[n2];
            String[] stringArray2 = data = line.split("\\s+");
            int n3 = data.length;
            int n4 = 0;
            while (n4 < n3) {
                String item = stringArray2[n4];
                if (item.startsWith(PREFIX)) {
                    names.add(item.trim());
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        System.out.println("total " + names.size());
        return names;
    }

    private static File makeDirs(File outputRoot) {
        SystemCommand command;
        String[] commandArray;
        String cmd;
        File phdDir = new File(outputRoot, "phd_dir");
        File assemblyDir = new File(outputRoot, "assembly");
        File chromatDir = new File(outputRoot, "chromat_dir");
        phdDir.delete();
        if (!phdDir.isDirectory()) {
            phdDir.mkdirs();
        } else {
            cmd = "rm " + phdDir.getAbsolutePath() + "/*";
            commandArray = new String[]{"bash", "-c", cmd};
            command = new SystemCommand(commandArray, null, true);
            command.makeItSo();
        }
        if (!assemblyDir.isDirectory()) {
            assemblyDir.mkdirs();
        } else {
            cmd = "rm " + assemblyDir.getAbsolutePath() + "/*";
            commandArray = new String[]{"bash", "-c", cmd};
            command = new SystemCommand(commandArray, null, true);
            command.makeItSo();
        }
        if (!chromatDir.isDirectory()) {
            chromatDir.mkdirs();
        }
        return phdDir;
    }
}

