/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.MatchUnit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import misc.FileManager;
import misc.SystemCommand;

public class ConvertFastaQdataMiSeqNoTrim {
    static int BASE = 33;

    public static void main(String[] args) throws Exception {
        File fastaqFile = new File(args[0]);
        File outputRoot = new File(args[1]);
        int limit = new Integer(args[2]);
        ConvertFastaQdataMiSeqNoTrim.convert(fastaqFile, outputRoot, limit);
    }

    public static void convert(File fastaqFile, File outputRoot, int limit) throws FileNotFoundException, IOException, Exception {
        File phdDir = ConvertFastaQdataMiSeqNoTrim.makeDirs(outputRoot);
        BufferedReader reader = new BufferedReader(new FileReader(fastaqFile));
        try {
            String line;
            String name = null;
            String sequence = null;
            String qualityChars = null;
            boolean isSeq = false;
            int count = 0;
            int lineCount = 0;
            while ((line = reader.readLine()) != null) {
                ++lineCount;
                if (line.startsWith("@") && line.trim().length() < 45) {
                    name = ConvertFastaQdataMiSeqNoTrim.generateName(line.trim().substring(1), phdDir);
                    isSeq = true;
                } else if (line.startsWith("+")) {
                    isSeq = false;
                } else if (isSeq) {
                    sequence = line.trim();
                } else {
                    qualityChars = line.trim();
                }
                if (sequence != null && qualityChars != null) {
                    count += ConvertFastaQdataMiSeqNoTrim.writePhdFile(phdDir, name, sequence, qualityChars);
                    sequence = null;
                    qualityChars = null;
                    name = null;
                }
                if (count <= limit) continue;
                System.out.println(lineCount / 4);
                break;
            }
        }
        finally {
            reader.close();
        }
    }

    private static MatchUnit setTrimStartAndEnd(String qualityChars, double trimCutoff) {
        MatchUnit unit = new MatchUnit(0, 0);
        int start = 0;
        int end = 0;
        int tbg = 0;
        double probScore = 0.0;
        double maxScore = 0.0;
        int qualScore = 0;
        int i = 0;
        while (i < qualityChars.length()) {
            int quality = qualityChars.charAt(i) - BASE;
            probScore += trimCutoff - Math.pow(10.0, (double)(-quality) / 10.0);
            qualScore += quality;
            if (probScore >= maxScore) {
                start = tbg;
                end = i;
                maxScore = probScore;
            }
            if (probScore < 0.0) {
                probScore = 0.0;
                qualScore = 0;
                tbg = i + 1;
            }
            ++i;
        }
        if (++end >= qualityChars.length()) {
            end = qualityChars.length() - 1;
        }
        if (end - start + 1 < 15) {
            start = 0;
            end = 0;
        }
        unit.setMatchStart(start);
        unit.setMatchEnd(end);
        return unit;
    }

    public static int writePhdFile(File phdDir, String name, String sequence, String qualityChars) throws Exception {
        MatchUnit unit = new MatchUnit(0, qualityChars.length());
        if (unit.getMatchStart() == unit.getMatchEnd()) {
            return 0;
        }
        File tmpFile = File.createTempFile("chromat", "fa");
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(name).append("\n");
        builder.append(sequence.substring(unit.getMatchStart(), unit.getMatchEnd()));
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        SystemCommand command = new SystemCommand("/usr/bin/perl /genome/bin/fasta2Phd.perl " + tmpFile.getAbsolutePath(), phdDir, false);
        command.makeItSo();
        File phdFile = new File(phdDir, String.valueOf(tmpFile.getName()) + ".phd.1");
        int beginDNA = 0;
        int endDNA = 0;
        StringBuilder out = new StringBuilder();
        String[] data = FileManager.readTextFile(phdFile).split("\n");
        int i = 0;
        while (i < data.length) {
            if (data[i].indexOf("BEGIN_DNA") >= 0) {
                beginDNA = i;
            }
            if (data[i].indexOf("END_DNA") >= 0) {
                endDNA = i;
            }
            ++i;
        }
        out.append("BEGIN_SEQUENCE " + name);
        i = 1;
        while (i <= beginDNA) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        i = beginDNA + 1;
        while (i < endDNA) {
            String[] info = data[i].trim().split("\\s+");
            if (!info[0].equals(new String("."))) {
                out.append(info[0]).append(" ");
            } else {
                out.append("n").append(" ");
            }
            char quality = qualityChars.substring(unit.getMatchStart(), unit.getMatchEnd()).charAt(i - beginDNA - 1);
            out.append(quality - BASE).append(" ");
            out.append(info[2]).append("\n");
            ++i;
        }
        i = endDNA;
        while (i < data.length) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        FileManager.writeTextFile(phdFile, out.toString(), true);
        phdFile.renameTo(new File(phdDir, String.valueOf(name) + ".phd.1"));
        FileManager.delete(tmpFile);
        return 1;
    }

    private static File makeDirs(File outputRoot) {
        File phdDir = new File(outputRoot, "phd_dir");
        File assemblyDir = new File(outputRoot, "assembly");
        File chromatDir = new File(outputRoot, "chromat_dir");
        if (!phdDir.isDirectory()) {
            phdDir.mkdirs();
        } else {
            String cmd = "rm " + phdDir.getAbsolutePath() + "/*";
            String[] commandArray = new String[]{"bash", "-c", cmd};
            SystemCommand command = new SystemCommand(commandArray, null, true);
            command.makeItSo();
        }
        if (!assemblyDir.isDirectory()) {
            assemblyDir.mkdirs();
        }
        if (!chromatDir.isDirectory()) {
            chromatDir.mkdirs();
        }
        return phdDir;
    }

    public static String generateName(String line, File phdDir) {
        String[] items = line.split("/");
        String[] items1 = items[0].split(":");
        String name = String.valueOf(items1[0]) + "-" + items1[items1.length - 2] + "-" + items1[items1.length - 1];
        String index = "";
        if (items.length == 2) {
            index = items[1].trim();
            name = String.valueOf(name) + "-" + index;
        } else {
            File phdFile1 = new File(phdDir, String.valueOf(name) + "-1.phd.1");
            name = !phdFile1.exists() ? String.valueOf(name) + "-1" : String.valueOf(name) + "-2";
        }
        return name;
    }
}

