/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CombineReportsAndAddHapNumber {
    public static void main(String[] args) throws Exception {
        File inputDir = new File(args[0]);
        File PDfile = new File(args[1]);
        File AGfile = new File(args[2]);
        File outputFile = new File(args[3]);
        Object[] files = inputDir.listFiles();
        Arrays.sort(files);
        StringBuilder output = new StringBuilder();
        int counter = 0;
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (!((File)file).getName().endsWith("csv")) {
                System.out.println("not std naming, skip " + ((File)file).getName());
            } else {
                XSSFSheet hipSheet = CombineReportsAndAddHapNumber.getHipSheet(((File)file).getName(), PDfile, AGfile);
                System.out.println(String.valueOf(((File)file).getName()) + "\t" + hipSheet.getSheetName());
                CombineReportsAndAddHapNumber.combine((File)file, hipSheet, output, counter);
                ++counter;
            }
            ++n2;
        }
        FileManager.writeTextFile(outputFile, output.toString(), true);
    }

    private static XSSFSheet getHipSheet(String reportName, File pDfile, File aGfile) throws Exception {
        if (reportName.startsWith("PD")) {
            return CombineReportsAndAddHapNumber.getSheetFromPDfile(pDfile, reportName);
        }
        if (reportName.startsWith("GA")) {
            return CombineReportsAndAddHapNumber.getSheetFromGAfile(aGfile, reportName);
        }
        return null;
    }

    private static XSSFSheet getSheetFromGAfile(File file, String reportName) throws Exception {
        String[] items = reportName.split("_");
        String prefix = items[0];
        String number = items[2];
        if (items[1].startsWith("PL30E")) {
            number = items[1].replace("PL", "");
        }
        FileInputStream ExcelFileToRead = new FileInputStream(file);
        XSSFWorkbook wb = new XSSFWorkbook(ExcelFileToRead);
        int sheetCount = wb.getNumberOfSheets();
        int i = 0;
        while (i < sheetCount) {
            XSSFSheet sheet = wb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            if (sheetName.endsWith(number)) {
                return sheet;
            }
            ++i;
        }
        return null;
    }

    private static XSSFSheet getSheetFromPDfile(File file, String reportName) throws Exception {
        String[] items = reportName.split("_");
        String prefix = items[0];
        String plate = items[1];
        FileInputStream ExcelFileToRead = new FileInputStream(file);
        XSSFWorkbook wb = new XSSFWorkbook(ExcelFileToRead);
        int sheetCount = wb.getNumberOfSheets();
        int i = 0;
        while (i < sheetCount) {
            XSSFSheet sheet = wb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            if (sheetName.startsWith("PD_PL0")) {
                sheetName = sheetName.replace("0", "");
            }
            if (sheetName.equals(String.valueOf(prefix) + "_" + plate)) {
                return sheet;
            }
            ++i;
        }
        return null;
    }

    private static void combine(File file, XSSFSheet hipSheet, StringBuilder output, int counter) throws Exception {
        String[] lines = FileManager.readTextFile(file).split("\n");
        Map<String, String> locationToHipMap = CombineReportsAndAddHapNumber.getHipMap(hipSheet);
        int i = 0;
        while (i < lines.length) {
            if (i == 0) {
                if (counter == 0) {
                    output.append("reportFile,").append("HipSheet,").append("HipNumber,").append(lines[i].trim()).append("\n");
                }
            } else {
                String[] items = lines[i].split(",");
                String sample = items[0].trim();
                String hipNumber = CombineReportsAndAddHapNumber.getHipNumber(sample, locationToHipMap);
                output.append(file.getName()).append(",").append(hipSheet.getSheetName()).append(",").append(hipNumber).append(",").append(lines[i].trim()).append("\n");
            }
            ++i;
        }
    }

    private static String getHipNumber(String sample, Map<String, String> locationToHipMap) {
        int start = sample.indexOf("_S") - 3;
        if (sample.indexOf("-M_S") > 0) {
            start = sample.indexOf("-M_S") - 3;
        }
        String cord = sample.substring(start, start + 3);
        String hip = "";
        if (locationToHipMap.containsKey(cord)) {
            hip = locationToHipMap.get(cord);
        } else {
            System.out.println(String.valueOf(sample) + "\t" + cord + "\t" + hip);
        }
        return hip;
    }

    private static Map<String, String> getHipMap(XSSFSheet hipSheet) {
        Iterator<Row> rows = hipSheet.rowIterator();
        LinkedHashMap<String, String> locationToHipMap = new LinkedHashMap<String, String>();
        while (rows.hasNext()) {
            XSSFRow row = (XSSFRow)rows.next();
            XSSFCell cell = row.getCell(4);
            if (cell.getStringCellValue().trim().length() == 0) continue;
            String[] items = cell.getStringCellValue().trim().split(",");
            if (items.length == 1) {
                items = cell.getStringCellValue().trim().split(":");
            }
            if (items.length < 2) {
                System.out.println(cell.getStringCellValue());
                continue;
            }
            String location = items[1].trim();
            if (location.length() == 2) {
                location = String.valueOf(location.charAt(0)) + "0" + location.charAt(1);
            }
            String hip = row.getCell(0).getStringCellValue().trim();
            locationToHipMap.put(location, hip);
        }
        return locationToHipMap;
    }

    private static String checkExistance(String sampleName, Map<String, Map<String, List<String>>> sampleTypes) {
        String keyName = sampleName.split("-rep")[0];
        for (String name : sampleTypes.keySet()) {
            if (!name.startsWith(keyName)) continue;
            return name;
        }
        String[] key = keyName.split("-");
        if ((keyName = key[key.length - 1]).startsWith("HG") || keyName.startsWith("NA")) {
            for (String name : sampleTypes.keySet()) {
                if (name.indexOf(keyName) < 0) continue;
                return name;
            }
        }
        return null;
    }

    public static Map<String, Map<String, List<String>>> readCSVfile(File file) throws IOException {
        String[] lines = FileManager.readTextFile(file).split("\n");
        LinkedHashMap<String, Map<String, List<String>>> sampleTypes = new LinkedHashMap<String, Map<String, List<String>>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split(",");
            if (items.length >= 2) {
                String sampleName = items[0].trim();
                String locus = items[1].trim();
                String type1 = "";
                String type2 = "";
                if (items.length > 3) {
                    type1 = items[2].trim();
                    type2 = items[3].trim();
                }
                if (sampleName != null && sampleName.length() > 0) {
                    if (!sampleTypes.containsKey(sampleName)) {
                        sampleTypes.put(sampleName, new LinkedHashMap());
                    }
                    if (!((Map)sampleTypes.get(sampleName)).containsKey(locus)) {
                        ((Map)sampleTypes.get(sampleName)).put(locus, new ArrayList());
                    }
                    if (type1 != null) {
                        ((List)((Map)sampleTypes.get(sampleName)).get(locus)).add(type1);
                    }
                    if (type2 != null) {
                        ((List)((Map)sampleTypes.get(sampleName)).get(locus)).add(type2);
                    }
                }
            }
            ++n2;
        }
        return sampleTypes;
    }

    public static Map<String, Map<String, List<String>>> readXLSXFile(File file) throws IOException {
        FileInputStream ExcelFileToRead = new FileInputStream(file);
        XSSFWorkbook wb = new XSSFWorkbook(ExcelFileToRead);
        XSSFWorkbook test2 = new XSSFWorkbook();
        XSSFSheet sheet = wb.getSheetAt(0);
        Iterator<Row> rows = sheet.rowIterator();
        LinkedHashMap<String, Map<String, List<String>>> sampleTypes = new LinkedHashMap<String, Map<String, List<String>>>();
        while (rows.hasNext()) {
            XSSFRow row = (XSSFRow)rows.next();
            Iterator<Cell> cells = row.cellIterator();
            String sampleName = null;
            String locus = null;
            String type1 = "";
            String type2 = "";
            int index = 0;
            while (cells.hasNext()) {
                XSSFCell cell = (XSSFCell)cells.next();
                String content = null;
                if (cell.getCellType() == 1) {
                    content = cell.getStringCellValue().trim();
                } else if (cell.getCellType() == 0) {
                    content = String.valueOf(cell.getNumericCellValue());
                }
                if (content != null && content.equals("Sample ID")) {
                    sampleName = null;
                    break;
                }
                if (index == 0) {
                    sampleName = content;
                } else if (index == 1) {
                    locus = content;
                } else if (index == 2) {
                    type1 = content;
                } else if (index == 3) {
                    type2 = content;
                }
                ++index;
            }
            if (sampleName == null || sampleName.length() <= 0) continue;
            if (!sampleTypes.containsKey(sampleName)) {
                sampleTypes.put(sampleName, new LinkedHashMap());
            }
            if (!((Map)sampleTypes.get(sampleName)).containsKey(locus)) {
                ((Map)sampleTypes.get(sampleName)).put(locus, new ArrayList());
            }
            if (type1 != null) {
                ((List)((Map)sampleTypes.get(sampleName)).get(locus)).add(type1);
            }
            if (type2 == null) continue;
            ((List)((Map)sampleTypes.get(sampleName)).get(locus)).add(type2);
        }
        return sampleTypes;
    }

    private static File getByName(String name, File inputDir) {
        File file;
        File[] files;
        String[] items = name.split("_");
        String prefix = items[0];
        String plate = items[1];
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (file.getName().endsWith("csv") && file.getName().startsWith(prefix) && file.getName().contains("_" + plate + "_")) {
                return file;
            }
            ++n2;
        }
        if (plate.startsWith("PL0")) {
            plate = plate.replace("0", "");
        }
        fileArray = files;
        n = files.length;
        n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (file.getName().endsWith("csv") && file.getName().startsWith(prefix) && file.getName().contains("_" + plate + "_")) {
                return file;
            }
            ++n2;
        }
        return null;
    }
}

