/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import misc.FileManager;

public class CombineFiles {
    static String[] OTHER_GENE = new String[]{"E", "F", "G", "H", "J", "K", "L"};

    public static void main(String[] args) throws Exception {
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        String header = args[2];
        File[] files = inputDir.listFiles();
        String preFix = String.valueOf(header) + "-exon";
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            List<File> otherFiles;
            File file2 = fileArray[n2];
            if (file2.getName().startsWith(preFix) && file2.getName().endsWith(".fa")) {
                otherFiles = CombineFiles.getOtherGeneFile(inputDir, file2.getName());
                file = CombineFiles.mergeFile(file2, otherFiles, outputDir);
            } else if (file2.getName().startsWith(preFix) && file2.getName().endsWith("-hap-amb.txt")) {
                otherFiles = CombineFiles.getOtherGeneAmbFile(inputDir, file2.getName());
                file = CombineFiles.mergeFile(file2, otherFiles, outputDir);
            }
            ++n2;
        }
    }

    private static File mergeFile(File file, List<File> otherFiles, File outputDir) {
        String[] lines;
        StringBuilder builder = new StringBuilder();
        String[] stringArray = lines = FileManager.readTextFile(file).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            builder.append(line.trim()).append("\n");
            ++n2;
        }
        for (File otherFile : otherFiles) {
            builder.append(FileManager.readTextFile(otherFile).trim()).append("\n");
        }
        File out = new File(outputDir, file.getName());
        FileManager.writeTextFile(out, builder.toString(), true);
        return out;
    }

    private static List<File> getOtherGeneFile(File inputDir, String name) {
        ArrayList<File> otherFiles = new ArrayList<File>();
        String exon = name.split("-")[1];
        System.out.println("load " + exon);
        int i = 0;
        while (i < OTHER_GENE.length) {
            File f = new File(inputDir, String.valueOf(OTHER_GENE[i]) + "-" + exon);
            if (f.exists()) {
                otherFiles.add(f);
            } else {
                System.out.println("skip " + exon + " " + OTHER_GENE[i] + "-" + exon);
            }
            ++i;
        }
        return otherFiles;
    }

    private static List<File> getOtherGeneAmbFile(File inputDir, String name) {
        ArrayList<File> otherFiles = new ArrayList<File>();
        String exon = name.split("exon")[1];
        System.out.println("load " + exon);
        int i = 0;
        while (i < OTHER_GENE.length) {
            File f = new File(inputDir, String.valueOf(OTHER_GENE[i]) + "-exon" + exon);
            if (f.exists()) {
                otherFiles.add(f);
            } else {
                System.out.println("skip " + exon + " " + OTHER_GENE[i] + "-exon" + exon);
            }
            ++i;
        }
        return otherFiles;
    }
}

