/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class CheckTypingResult {
    static String DPA1 = "DPA1";
    static String DPB1 = "DPB1";
    static String DQA1 = "DQA1";
    static String DQB1 = "DQB1";
    static String HLAA = "A";
    static String HLAB = "B";
    static String HLAC = "C";
    static String DQBSUDO = "DQBsudo";
    static String DQASUDO = "DQAsudo";
    static String DRB1345 = "DRB1345";
    static String DRB3 = "DRB3";
    static String DRB4 = "DRB4";
    static String DRB5 = "DRB5";
    static String EXON2 = "exon2";
    static String EXON3 = "exon3";
    static String EXON4 = "exon4";
    static String EXON23 = "exon23";
    static String NO_RESULT = "No Result";
    static String HAP_AMB_TXT = "-hap-amb.txt";
    static int MIN_SUPPORT_READS = 20;
    static int FIRM_SUPPORT_READS = 50;
    static String HOMOZYGOUS = "homozygous";
    static int MAJOR_DIFF_COUNT = 2;
    static String NO_PERFECT_RESULT = "No PERFECT MATCH";
    static boolean EXPAND_HAP_AMBGUITY = true;
    static boolean DRB_EXON3_IGNORE_BEGINNING = true;

    public static void main(String[] args) throws Exception {
        File detailedResultFile = new File(args[0]);
        File exonCountFile = new File(args[1]);
        String[] detailedResult = FileManager.readTextFile(detailedResultFile).split("\n");
        Map<String, Integer> allMajorResult = CheckTypingResult.extractForLocusExon(detailedResult, "mamuB-exon3.fa");
        String[] countResult = FileManager.readTextFile(exonCountFile).split("\n");
        Map<String, Integer> allCountResult = CheckTypingResult.extractForExonCount(countResult, 5);
        System.out.println("number mismatch-------------------");
        for (String name : allMajorResult.keySet()) {
            if (!allCountResult.containsKey(name) || allMajorResult.get(name) * 4 >= allCountResult.get(name) || allCountResult.get(name) <= 100) continue;
            System.out.println(String.valueOf(name) + " count=" + allCountResult.get(name) / 2 + "/typed=" + allMajorResult.get(name));
        }
    }

    private static Map<String, Integer> extractForExonCount(String[] countResult, int i) {
        LinkedHashMap<String, Integer> allCountResult = new LinkedHashMap<String, Integer>();
        String[] stringArray = countResult;
        int n = countResult.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.split("\\s+");
            if (items.length > i) {
                String sampleName = items[0].trim();
                int count = Integer.valueOf(items[i].trim().split("\\(")[0]);
                allCountResult.put(sampleName, count);
            }
            ++n2;
        }
        return allCountResult;
    }

    private static Map<String, Integer> extractForLocusExon(String[] detailedResult, String representString) {
        LinkedHashMap<String, Integer> allMajorResult = new LinkedHashMap<String, Integer>();
        int i = 0;
        while (i < detailedResult.length) {
            String line = detailedResult[i];
            if (line.indexOf(representString) > 0) {
                String[] items = line.split("\\s+");
                String sampleName = items[0].trim();
                if (!allMajorResult.containsKey(sampleName)) {
                    allMajorResult.put(sampleName, 0);
                }
                if (line.indexOf("No Result") <= 0) {
                    int count = Integer.valueOf(items[3].trim());
                    int coverage = Integer.valueOf(items[5].trim().split("/")[0]);
                    int length = Integer.valueOf(items[5].trim().split("/")[1]);
                    if (count >= 50 && coverage != length) {
                        System.out.println(line.trim());
                    }
                    if (coverage == length) {
                        allMajorResult.put(sampleName, (Integer)allMajorResult.get(sampleName) + count);
                    }
                }
            }
            ++i;
        }
        return allMajorResult;
    }
}

