/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class CheckRulesetFile {
    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        CheckRulesetFile.checkFasta(fastaFile);
    }

    private static void checkFasta(File fastaFile) {
        Map<String, String> newSeq = CheckRulesetFile.getSequences(fastaFile);
        int size = 0;
        Iterator<String> iterator = newSeq.values().iterator();
        if (iterator.hasNext()) {
            String seq = iterator.next();
            size = seq.length();
        }
        for (String name : newSeq.keySet()) {
            if (newSeq.get(name).length() == size) continue;
            System.out.println(String.valueOf(name) + " " + newSeq.get(name).length());
        }
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }
}

