/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.MatchUnit;
import fileOperation.SequencUnit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import misc.FileManager;
import misc.SystemCommand;

public class CheckFastaQdataMiSeq {
    static int BASE = 33;
    static int PROPER_Q = 25;
    static int NOISE_SIZE = 25;

    public static void main(String[] args) throws Exception {
        File fastaqFile = new File(args[0]);
        File outputRoot = new File(args[1]);
        int limit = new Integer(args[2]);
        File backboneFile = new File(args[3]);
        File phdDir = CheckFastaQdataMiSeq.makeDirs(outputRoot);
        BufferedReader reader = new BufferedReader(new FileReader(fastaqFile));
        int lowQualityCount = 0;
        ArrayList<SequencUnit> parialMatchReads = new ArrayList<SequencUnit>();
        ArrayList<SequencUnit> noMatchReads = new ArrayList<SequencUnit>();
        StringBuilder filteredReads = new StringBuilder();
        try {
            String line;
            String name = null;
            String sequence = null;
            String qualityChars = null;
            boolean isSeq = false;
            int count = 0;
            int lineCount = 0;
            while ((line = reader.readLine()) != null) {
                ++lineCount;
                if (line.startsWith("@") && line.charAt(1) == 'M') {
                    name = CheckFastaQdataMiSeq.generateName(line.trim().substring(1));
                    isSeq = true;
                } else if (line.startsWith("+")) {
                    isSeq = false;
                } else if (isSeq) {
                    sequence = line.trim();
                } else {
                    qualityChars = line.trim();
                }
                if (sequence != null && qualityChars != null) {
                    MatchUnit unit = CheckFastaQdataMiSeq.setTrimStartAndEnd(qualityChars, 0.025);
                    if (unit.getMatchStart() == unit.getMatchEnd() || Math.abs(unit.getMatchEnd() - unit.getMatchStart()) < PROPER_Q) {
                        ++lowQualityCount;
                    } else if (CheckFastaQdataMiSeq.passCheck(name, sequence, backboneFile, unit, parialMatchReads, noMatchReads)) {
                        count += CheckFastaQdataMiSeq.writePhdFile(phdDir, name, sequence, qualityChars, unit);
                    }
                    sequence = null;
                    qualityChars = null;
                    name = null;
                }
                if (count <= limit) continue;
                System.out.println("steped lines " + lineCount + " " + lineCount / 4);
                break;
            }
            System.out.println("low quality count (size < 25 after trimming) : " + lowQualityCount);
            System.out.println("no match Reads (may includ the vector sequence not present in backbone) : " + noMatchReads.size());
            System.out.println("--------------------");
            for (SequencUnit s : noMatchReads) {
                System.out.println(String.valueOf(s.name) + " " + s.getGoodSize() + " " + s.getMatchSize());
            }
            System.out.println("carmaric Reads : " + parialMatchReads.size());
            System.out.println("--------------------");
            for (SequencUnit s : parialMatchReads) {
                System.out.println(String.valueOf(s.name) + " " + s.getGoodSize() + " " + s.getMatchSize());
            }
        }
        finally {
            reader.close();
        }
    }

    private static boolean passCheck(String name, String sequence, File backbone, MatchUnit unit, List<SequencUnit> parialMatchReads, List<SequencUnit> noMatchReads) throws Exception {
        String[] out;
        File tmpFile = File.createTempFile("name", "fa");
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(name).append("\n");
        builder.append(sequence.substring(unit.getMatchStart(), unit.getMatchEnd()));
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        SystemCommand command = new SystemCommand("/genome/bin/cross_match  -minscore 30 " + tmpFile.getAbsolutePath() + " " + backbone, tmpFile.getParentFile(), true);
        command.makeItSo();
        String data = command.getStandardOut();
        SequencUnit seqUnit = new SequencUnit(name, unit.getMatchEnd() - unit.getMatchStart(), 0);
        if (data.indexOf("0 matching entries") > 0) {
            noMatchReads.add(seqUnit);
            return false;
        }
        if (data.indexOf("Maximal single base matches") < 0 || data.indexOf("1 matching entries") < 0) {
            System.out.println("unknown " + name + " " + sequence);
            return false;
        }
        int start = data.indexOf("Maximal single base matches");
        int end = data.indexOf("matching entries");
        String[] stringArray = out = data.substring(start, end).split("\n");
        int n = out.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(name) > 0) {
                String[] items = line.split("\\s+");
                int index = 0;
                int i = 0;
                while (i < items.length) {
                    if (items[i].trim().equals(name)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                int b = Integer.valueOf(items[index + 1]);
                int e = Integer.valueOf(items[index + 2]);
                if (b <= NOISE_SIZE && seqUnit.getGoodSize() - e <= NOISE_SIZE) break;
                seqUnit.setMatchSize(e - b);
                parialMatchReads.add(seqUnit);
                return false;
            }
            ++n2;
        }
        tmpFile.delete();
        return true;
    }

    private static MatchUnit setTrimStartAndEnd(String qualityChars, double trimCutoff) {
        MatchUnit unit = new MatchUnit(0, 0);
        int start = 0;
        int end = 0;
        int tbg = 0;
        double probScore = 0.0;
        double maxScore = 0.0;
        int qualScore = 0;
        int i = 0;
        while (i < qualityChars.length()) {
            int quality = qualityChars.charAt(i) - BASE;
            probScore += trimCutoff - Math.pow(10.0, (double)(-quality) / 10.0);
            qualScore += quality;
            if (probScore >= maxScore) {
                start = tbg;
                end = i;
                maxScore = probScore;
            }
            if (probScore < 0.0) {
                probScore = 0.0;
                qualScore = 0;
                tbg = i + 1;
            }
            ++i;
        }
        if (++end >= qualityChars.length()) {
            end = qualityChars.length() - 1;
        }
        if (end - start + 1 < 15) {
            start = 0;
            end = 0;
        }
        unit.setMatchStart(start);
        unit.setMatchEnd(end);
        return unit;
    }

    public static int writePhdFile(File phdDir, String name, String sequence, String qualityChars, MatchUnit unit) throws Exception {
        File tmpFile = File.createTempFile("chromat", "fa");
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(name).append("\n");
        builder.append(sequence.substring(unit.getMatchStart(), unit.getMatchEnd()));
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        SystemCommand command = new SystemCommand("/usr/local/bin/perl /genome/bin/fasta2Phd.perl " + tmpFile.getAbsolutePath(), phdDir, false);
        command.makeItSo();
        File phdFile = new File(phdDir, String.valueOf(tmpFile.getName()) + ".phd.1");
        int beginDNA = 0;
        int endDNA = 0;
        StringBuilder out = new StringBuilder();
        String[] data = FileManager.readTextFile(phdFile).split("\n");
        int i = 0;
        while (i < data.length) {
            if (data[i].indexOf("BEGIN_DNA") >= 0) {
                beginDNA = i;
            }
            if (data[i].indexOf("END_DNA") >= 0) {
                endDNA = i;
            }
            ++i;
        }
        out.append("BEGIN_SEQUENCE " + name);
        i = 1;
        while (i <= beginDNA) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        i = beginDNA + 1;
        while (i < endDNA) {
            String[] info = data[i].trim().split("\\s+");
            if (!info[0].equals(new String("."))) {
                out.append(info[0]).append(" ");
            } else {
                out.append("n").append(" ");
            }
            char quality = qualityChars.substring(unit.getMatchStart(), unit.getMatchEnd()).charAt(i - beginDNA - 1);
            out.append(quality - BASE).append(" ");
            out.append(info[2]).append("\n");
            ++i;
        }
        i = endDNA;
        while (i < data.length) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        FileManager.writeTextFile(phdFile, out.toString(), true);
        phdFile.renameTo(new File(phdDir, String.valueOf(name) + ".phd.1"));
        FileManager.delete(tmpFile);
        return 1;
    }

    private static File makeDirs(File outputRoot) {
        File phdDir = new File(outputRoot, "phd_dir");
        File assemblyDir = new File(outputRoot, "assembly");
        File chromatDir = new File(outputRoot, "chromat_dir");
        if (!phdDir.isDirectory()) {
            phdDir.mkdirs();
        }
        if (!assemblyDir.isDirectory()) {
            assemblyDir.mkdirs();
        }
        if (!chromatDir.isDirectory()) {
            chromatDir.mkdirs();
        }
        return phdDir;
    }

    private static String generateName(String line) {
        String[] items = line.split("/");
        String index = items[1].trim();
        String[] items1 = items[0].split(":");
        String name = String.valueOf(items1[0]) + "-" + items1[items1.length - 2] + "-" + items1[items1.length - 1] + "-" + index;
        return name;
    }
}

