/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConsensusSeq;
import fileOperation.Position;
import fileOperation.ReadSequence;
import fileOperation.Region;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class CheckConsense {
    private static final int WEAK_REGION_COVERAGE_CUTOFF = 3;

    public static void main(String[] args) throws Exception {
        File assemblyTopDir = new File(args[0]);
        File seqFile = new File(args[1]);
        File logFile = new File(args[2]);
        StringBuilder seqOut = new StringBuilder();
        StringBuilder logOut = new StringBuilder();
        logOut.append("index").append(",").append("Alleles").append(",").append("Flanking").append(",").append("ReportAllele").append("\n");
    }

    public static void parseConsense(File assemblyTopDir, StringBuilder seqOut, StringBuilder logOut, String name) {
        File assemblyDir = new File(assemblyTopDir, "assembly");
        File phdDir = new File(assemblyTopDir, "phd_dir");
        File aceFile = CheckConsense.getLatestAceFile(assemblyDir);
        if (aceFile == null) {
            seqOut.append(">").append(name).append("\n");
            seqOut.append("\n");
            logOut.append("assemblyTopDir.getName()").append(",").append("No Ace File");
            seqOut.append("\n");
        }
        ConsensusSeq consensusSeq = CheckConsense.readAceFile(aceFile, phdDir);
        File problemFile = CheckConsense.getLatestProblemFile(assemblyDir);
        List<String> problemNames = CheckConsense.parseProblemReads(problemFile);
        System.out.println(String.valueOf(assemblyTopDir.getName()) + " " + consensusSeq.getSequence().getPadded().length() + " " + consensusSeq.getReadSequences().size());
        logOut.append(assemblyTopDir.getName()).append(",").append(aceFile.getName()).append(",").append(name);
        logOut.append(",").append("longestContigPaddedSize=").append(consensusSeq.getSequence().getPadded().length()).append("\n");
        CheckConsense.performChecking(consensusSeq, seqOut, logOut, name, problemNames);
    }

    private static List<String> parseProblemReads(File problemFile) {
        String[] lines;
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = lines = FileManager.readTextFile(problemFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith(">")) {
                names.add(line.trim().substring(1));
            }
            ++n2;
        }
        return names;
    }

    private static void performChecking(ConsensusSeq consensusSeq, StringBuilder seqOut, StringBuilder logOut, String name, List<String> problemNames) {
        int i = 0;
        while (i < consensusSeq.getSequence().getPadded().length()) {
            char cChar = consensusSeq.getSequence().getPadded().toUpperCase().charAt(i);
            int consistantCount = 0;
            int coverageCount = 0;
            int inConsistantCount = 0;
            char nodeBase = 'N';
            HashMap<String, Integer> baseCount = new HashMap<String, Integer>();
            for (ReadSequence readSequence : consensusSeq.getReadSequences().values()) {
                if (readSequence.getConsensusStart() - 1 > i || readSequence.getConsensusStart() + readSequence.getPaddedLength() - 2 < i) continue;
                int index = i - readSequence.getConsensusStart() + 1;
                char thisBase = readSequence.getSequence().getPadded().toUpperCase().charAt(index);
                char orgBase = readSequence.getSequence().getPadded().charAt(index);
                int matchcount = CheckConsense.matchedRegion(readSequence.getSequence().getPadded(), index, consensusSeq.getSequence().getPadded(), i);
                if (thisBase != 'X' && matchcount <= 7 || thisBase == 'X' && i > 500 && i < consensusSeq.getSequence().getPadded().length() - 500) continue;
                if (orgBase == thisBase && thisBase != 'X' || thisBase == cChar) {
                    ++coverageCount;
                }
                if (orgBase != thisBase && !CheckConsense.isGoodRegion(readSequence.getSequence().getPadded(), index) && thisBase != 'X') continue;
                CheckConsense.addToMap(String.valueOf(thisBase), baseCount);
                if (thisBase != 'X') {
                    if (thisBase == cChar) {
                        ++consistantCount;
                    } else {
                        ++inConsistantCount;
                    }
                }
                if (!readSequence.isNode()) continue;
                nodeBase = thisBase;
            }
            if (coverageCount >= 3 || nodeBase == 'X') {
                CheckConsense.checkThisPosition(i, cChar, nodeBase, baseCount, consensusSeq);
            } else {
                CheckConsense.logWeakRegion(i, consensusSeq);
            }
            ++i;
        }
        CheckConsense.performFixingLogging(consensusSeq, seqOut, logOut, name);
    }

    private static int matchedRegion(String padded, int index, String cpadded, int cindex) {
        String uper = padded.toUpperCase();
        String cuper = cpadded.toUpperCase();
        int count = 0;
        int i = -5;
        while (i < 6) {
            if (index + i >= 0 && cindex + i >= 0 && index + i < padded.length() && cindex + i < cpadded.length() && uper.charAt(index + i) == cuper.charAt(cindex + i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static boolean isGoodRegion(String padded, int index) {
        String uper = padded.toUpperCase();
        int start = index - 5;
        int end = index + 6;
        if (start < 0) {
            start = 0;
            end = start + 11;
        }
        if (end >= padded.length()) {
            end = padded.length() - 1;
            start = end - 11;
        }
        int count = 0;
        int i = start;
        while (i < end) {
            if (uper.charAt(i) == padded.charAt(i)) {
                ++count;
            }
            ++i;
        }
        return count >= 5;
    }

    private static void performFixingLogging(ConsensusSeq consensusSeq, StringBuilder seqOut, StringBuilder logOut, String name) {
        String newSeq = consensusSeq.getSequence().getPadded().toUpperCase();
        Map<Integer, Position> qPos = consensusSeq.getQuestionPositions();
        for (Integer index : qPos.keySet()) {
            logOut.append(index + 1).append(",").append(CheckConsense.formatAlleles(qPos.get(index)));
            logOut.append(",").append(CheckConsense.getFlankingSeq(consensusSeq.getSequence().getPadded(), index));
            if (qPos.get(index).isChanged()) {
                logOut.append(",").append(qPos.get(index).getMajorBase());
                newSeq = String.valueOf(newSeq.substring(0, index)) + qPos.get(index).getMajorBase() + newSeq.substring(index + 1);
            } else {
                logOut.append(",").append(consensusSeq.getSequence().getPadded().toUpperCase().charAt(index));
            }
            logOut.append("\n");
        }
        logOut.append("WeakRegion").append("\n");
        for (Region region : consensusSeq.getWeakRegion()) {
            String out = String.valueOf(region.getStart() + 1) + "-" + (region.getEnd() + 1);
            logOut.append(out).append(",");
            logOut.append(region.getLeftFlanking()).append(",");
            logOut.append(region.getRightFlanking()).append("\n");
        }
        consensusSeq.getSequence().setUnpadded(newSeq.replaceAll("\\*", "").replaceAll("X", ""));
        seqOut.append(">").append(name).append("\n");
        seqOut.append(consensusSeq.getSequence().getUnpadded()).append("\n");
    }

    private static String getFlankingSeq(String padded, Integer index) {
        String ret = String.valueOf(padded.charAt(index)).toUpperCase();
        String left = padded.substring(Math.max(index - 10, 0), index).toLowerCase();
        String right = padded.substring(index + 1, Math.min(index + 11, padded.length())).toLowerCase();
        return String.valueOf(left) + ret + right;
    }

    private static Object formatAlleles(Position position) {
        String alleles = String.valueOf(position.getMajorBase()) + "=" + position.getMajorBaseCount();
        if (position.getMinorBase() != 'N') {
            alleles = String.valueOf(alleles) + "/";
            alleles = String.valueOf(alleles) + position.getMinorBase() + "=" + position.getMinorBaseCount();
        }
        return alleles;
    }

    private static void logWeakRegion(int i, ConsensusSeq consensusSeq) {
        String right;
        List<Region> regions = consensusSeq.getWeakRegion();
        String padded = consensusSeq.getSequence().getPadded();
        boolean merged = false;
        for (Region region : regions) {
            if (region.getEnd() + 1 != i) continue;
            region.setEnd(region.getEnd() + 1);
            right = padded.substring(i + 1, Math.min(i + 11, padded.length())).toLowerCase();
            region.setRightFlanking(right);
            merged = true;
        }
        if (!merged) {
            Region region;
            region = new Region();
            region.setStart(i);
            region.setEnd(i);
            String left = padded.substring(Math.max(i - 10, 0), i).toLowerCase();
            right = padded.substring(i + 1, Math.min(i + 11, padded.length())).toLowerCase();
            region.setLeftFlanking(left);
            region.setRightFlanking(right);
            regions.add(region);
        }
    }

    private static void checkThisPosition(int index, char cChar, char nodeBase, Map<String, Integer> baseCount, ConsensusSeq consensusSeq) {
        HashMap<Integer, String> baseCountByNumber = new HashMap<Integer, String>();
        for (String base : baseCount.keySet()) {
            baseCountByNumber.put(baseCount.get(base), base);
        }
        Object[] num = baseCountByNumber.keySet().toArray();
        Arrays.sort(num);
        String majorBase = "N";
        String minorBase = "N";
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            if (!((String)baseCountByNumber.get(c)).equals("N") && !((String)baseCountByNumber.get(c)).equals("X")) {
                if (majorBase.equals("N")) {
                    majorBase = (String)baseCountByNumber.get(c);
                } else if (minorBase.equals("N")) {
                    minorBase = (String)baseCountByNumber.get(c);
                }
            }
            if (!majorBase.equals("N") && !minorBase.equals("N")) break;
            --i;
        }
        Position position = new Position();
        position.setIndex(index);
        position.setMajorBase(majorBase.charAt(0));
        if (baseCount.containsKey(majorBase)) {
            position.setMajorBaseCount(baseCount.get(majorBase));
        }
        position.setMinorBase(minorBase.charAt(0));
        if (baseCount.containsKey(minorBase)) {
            position.setMinorBaseCount(baseCount.get(minorBase));
        }
        if (cChar != '*' && cChar != 'A' && cChar != 'C' && cChar != 'T' && cChar != 'G') {
            position.setChanged(false);
            consensusSeq.getQuestionPositions().put(index, position);
            System.out.println(String.valueOf(index) + " 0000000 " + cChar);
            return;
        }
        if (nodeBase == 'N') {
            if (cChar == majorBase.charAt(0)) {
                if (baseCount.get(majorBase) < 3) {
                    position.setChanged(false);
                    consensusSeq.getQuestionPositions().put(index, position);
                    System.out.println(String.valueOf(index) + " 1111111 " + majorBase);
                } else if (Double.valueOf(position.getMajorBaseCount()) < Double.valueOf(position.getMinorBaseCount()) * 1.5) {
                    position.setChanged(false);
                    consensusSeq.getQuestionPositions().put(index, position);
                    System.out.println(String.valueOf(index) + " 2222222 " + majorBase);
                }
            } else if (!majorBase.equals("N") && !minorBase.equals("N")) {
                if (baseCount.get(majorBase) >= 3 && (float)baseCount.get(majorBase).intValue() > (float)baseCount.get(minorBase).intValue() * 1.5f) {
                    position.setChanged(true);
                    consensusSeq.getQuestionPositions().put(index, position);
                    System.out.println(String.valueOf(index) + " 33333333 " + cChar + " -> " + majorBase.charAt(0));
                } else {
                    position.setChanged(false);
                    consensusSeq.getQuestionPositions().put(index, position);
                    System.out.println(String.valueOf(index) + " 444444444 " + majorBase);
                }
            } else if (!majorBase.equals("N")) {
                position.setChanged(true);
                consensusSeq.getQuestionPositions().put(index, position);
                System.out.println(String.valueOf(index) + " 5555555555 " + cChar + " -> " + majorBase.charAt(0));
            } else {
                position.setChanged(false);
                consensusSeq.getQuestionPositions().put(index, position);
                System.out.println(String.valueOf(index) + " 999999 " + majorBase + " ??? " + cChar);
            }
        } else if (nodeBase == cChar) {
            if ((!baseCount.containsKey(String.valueOf(nodeBase)) || baseCount.get(String.valueOf(nodeBase)) < 5) && nodeBase != majorBase.charAt(0) && nodeBase != 'X' && baseCount.containsKey(majorBase) && baseCount.get(majorBase) >= 6) {
                position.setChanged(true);
                consensusSeq.getQuestionPositions().put(index, position);
                System.out.println(String.valueOf(index) + " 666666 " + cChar + " -> " + majorBase.charAt(0));
            }
        } else if (nodeBase == 'X') {
            position.setMinorBase(position.getMajorBase());
            position.setMinorBaseCount(position.getMajorBaseCount());
            position.setMajorBase('X');
            position.setMajorBaseCount(baseCount.get(String.valueOf(nodeBase)));
            position.setChanged(true);
            consensusSeq.getQuestionPositions().put(index, position);
            System.out.println(String.valueOf(index) + " 7777 " + majorBase + " -> " + 'X');
        } else if (nodeBase == majorBase.charAt(0) || baseCount.containsKey(String.valueOf(nodeBase)) && baseCount.get(String.valueOf(nodeBase)) >= 3) {
            position.setChanged(true);
            if (position.getMajorBase() != nodeBase) {
                position.setMinorBase(position.getMajorBase());
                position.setMinorBaseCount(position.getMajorBaseCount());
                position.setMajorBase(nodeBase);
                position.setMajorBaseCount(baseCount.get(String.valueOf(nodeBase)));
            }
            consensusSeq.getQuestionPositions().put(index, position);
            System.out.println(String.valueOf(index) + " 888888 " + cChar + " -> " + nodeBase);
        }
    }

    private static void addToMap(String thisBase, Map<String, Integer> baseCount) {
        if (!baseCount.containsKey(thisBase)) {
            baseCount.put(thisBase, 1);
        } else {
            baseCount.put(thisBase, baseCount.get(thisBase) + 1);
        }
    }

    private static ConsensusSeq readAceFile(File aceFile, File phdDir) {
        String[] items;
        ConsensusSeq consensusSeq = new ConsensusSeq();
        String[] lines = FileManager.readTextFile(aceFile).split("\n");
        int size = 0;
        String contig = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith("CO Contig") && Integer.valueOf((items = line.trim().split("\\s+"))[2]) >= size) {
                size = Integer.valueOf(items[2]);
                contig = items[1].trim();
            }
            ++n2;
        }
        StringBuilder seq = new StringBuilder();
        StringBuilder qualSeq = new StringBuilder();
        boolean inParsingBlock = false;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith("CO " + contig + " ") && !inParsingBlock) {
                System.out.println("> " + contig);
                inParsingBlock = true;
                int j = i + 1;
                while (j < lines.length) {
                    if (lines[j].trim().startsWith("BQ")) {
                        i = j - 1;
                        break;
                    }
                    seq.append(lines[j].trim());
                    ++j;
                }
                consensusSeq.getSequence().setPadded(seq.toString());
            } else if (lines[i].trim().startsWith("BQ") && inParsingBlock) {
                int j = i + 1;
                while (j < lines.length) {
                    if (lines[j].trim().startsWith("AF")) {
                        i = j - 1;
                        break;
                    }
                    qualSeq.append(" ").append(lines[j].trim());
                    ++j;
                }
                consensusSeq.getSequence().setQual(qualSeq.toString().trim().split("\\s+"));
            } else if (lines[i].trim().startsWith("AF") && inParsingBlock) {
                items = lines[i].trim().split("\\s+");
                ReadSequence readSequence = new ReadSequence();
                readSequence.setName(items[1].trim());
                readSequence.setRevComp(items[2].trim().equals("C"));
                readSequence.setConsensusStart(Integer.valueOf(items[3].trim()));
                consensusSeq.getReadSequences().put(readSequence.getName(), readSequence);
                if (readSequence.getName().startsWith("NODE")) {
                    readSequence.setNode(true);
                }
            } else if (lines[i].trim().startsWith("RD") && inParsingBlock) {
                items = lines[i].trim().split("\\s+");
                String name = items[1].trim();
                int length = Integer.valueOf(items[2].trim());
                StringBuilder readSeq = new StringBuilder();
                int j = i + 1;
                while (j < lines.length) {
                    if (lines[j].trim().length() == 0) {
                        i = j - 1;
                        break;
                    }
                    readSeq.append(lines[j].trim());
                    ++j;
                }
                consensusSeq.getReadSequences().get(name).getSequence().setPadded(readSeq.toString());
                consensusSeq.getReadSequences().get(name).setPaddedLength(length);
            } else if (lines[i].startsWith("CO " + contig + " ") && inParsingBlock) break;
            ++i;
        }
        return consensusSeq;
    }

    private static String[] parsePhdFile(File phdFile) {
        int beginDNA = 0;
        int endDNA = 0;
        String[] data = FileManager.readTextFile(phdFile).split("\n");
        ArrayList<String> qualities = new ArrayList<String>();
        int i = 0;
        while (i < data.length) {
            if (data[i].indexOf("BEGIN_DNA") >= 0) {
                beginDNA = i;
            }
            if (data[i].indexOf("END_DNA") >= 0) {
                endDNA = i;
            }
            ++i;
        }
        i = beginDNA + 1;
        while (i < endDNA) {
            String[] info = data[i].trim().split("\\s+");
            qualities.add(info[1].trim());
            ++i;
        }
        String[] qual = new String[qualities.size()];
        return qualities.toArray(qual);
    }

    private static File getLatestProblemFile(File assemblyDir) {
        File[] afns;
        File[] fileArray = afns = assemblyDir.listFiles();
        int n = afns.length;
        int n2 = 0;
        while (n2 < n) {
            File afn = fileArray[n2];
            if (afn.getName().trim().endsWith("fasta.screen.problems")) {
                return afn;
            }
            ++n2;
        }
        return null;
    }

    public static File getLatestAceFile(File assemblyDir) {
        File[] afns = assemblyDir.listFiles();
        int index = 0;
        String name = null;
        File[] fileArray = afns;
        int n = afns.length;
        int n2 = 0;
        while (n2 < n) {
            int thisIndex;
            String[] items;
            File afn = fileArray[n2];
            if (afn.getName().indexOf(".fasta.screen.ace.") > -1 && (items = afn.getName().split("\\."))[items.length - 1].length() <= 2 && (thisIndex = Integer.valueOf(items[items.length - 1]).intValue()) > index) {
                index = thisIndex;
                name = items[0];
            }
            ++n2;
        }
        if (index == 0) {
            return null;
        }
        File lastestAce = new File(assemblyDir, String.valueOf(name) + ".fasta.screen.ace." + index);
        return lastestAce;
    }
}

