/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import misc.FileManager;
import misc.StreamReaderThread;

public class BatchVelvet {
    public static void main(String[] args) throws Exception {
        File[] fastaFiles;
        File fastaFileDir = new File(args[0]);
        File topOutputRoot = new File(args[1]);
        File summaryFile = new File(args[2]);
        File[] fileArray = fastaFiles = fastaFileDir.listFiles();
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File fastaFile = fileArray[n2];
            if (!fastaFile.getName().endsWith("fa")) {
                System.out.println("Skip " + fastaFile.getName());
            } else {
                System.out.println(fastaFile.getName());
                File output = new File(topOutputRoot, BatchVelvet.generateFileName(fastaFile.getName()));
                File tmpDir = new File(topOutputRoot, "temp");
                if (!tmpDir.exists() || !tmpDir.isDirectory()) {
                    BatchVelvet.runCmd("mkdir temp", topOutputRoot);
                }
                BatchVelvet.runCmd("/genome/bin/velveth ./temp/ 29 -fasta -shortPaired " + fastaFile.getAbsolutePath(), topOutputRoot);
                BatchVelvet.runCmd("/genome/bin/velvetg ./temp/ -cov_cutoff 20 -ins_length auto -min_contig_lgth 500", topOutputRoot);
                BatchVelvet.runCmd("mv ./temp/contigs.fa " + output.getAbsolutePath(), topOutputRoot);
                BatchVelvet.runCmd("rm ./temp/*", topOutputRoot);
            }
            ++n2;
        }
        BatchVelvet.generateSummary(topOutputRoot, summaryFile);
    }

    private static void generateSummary(File topOutputRoot, File summaryFile) {
        File[] fastaFiles = topOutputRoot.listFiles();
        StringBuilder builder = new StringBuilder();
        File[] fileArray = fastaFiles;
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File fastaFile = fileArray[n2];
            if (!fastaFile.getName().endsWith("contigs.fa")) {
                System.out.println("Skip " + fastaFile.getName());
            } else {
                builder.append(fastaFile.getName().subSequence(0, fastaFile.getName().length() - 11)).append("\t");
                String[] lines = FileManager.readTextFile(fastaFile).split("\n");
                int nodeCount = 0;
                int coverage = 0;
                String[] stringArray = lines;
                int n3 = lines.length;
                int n4 = 0;
                while (n4 < n3) {
                    String line = stringArray[n4];
                    if (line.startsWith(">")) {
                        ++nodeCount;
                        int size = Integer.valueOf(line.split("_")[3]);
                        coverage += size;
                    }
                    ++n4;
                }
                builder.append(nodeCount).append("\t");
                builder.append(coverage).append("\n");
            }
            ++n2;
        }
        FileManager.writeTextFile(summaryFile, builder.toString(), true);
    }

    public static void runCmd(String cmd, File dir) {
        block6: {
            String data = null;
            InputStream inputStream = null;
            InputStream errorStream = null;
            StringBuffer err = new StringBuffer();
            StringBuffer out = new StringBuffer();
            try {
                Process proc = Runtime.getRuntime().exec(cmd, null, dir);
                inputStream = proc.getInputStream();
                errorStream = proc.getErrorStream();
                StreamReaderThread outThread = new StreamReaderThread(inputStream, out, true);
                StreamReaderThread errThread = new StreamReaderThread(errorStream, err, true);
                outThread.start();
                errThread.start();
                int result = proc.waitFor();
                outThread.join();
                errThread.join();
                data = out.toString();
            }
            catch (IOException ioe) {
                System.err.println("an I/O error occurs" + ioe.toString());
                System.exit(1);
                BatchVelvet.closeInputStream(inputStream);
                BatchVelvet.closeInputStream(errorStream);
                break block6;
            }
            catch (InterruptedException e) {
                try {
                    System.err.println("Interrupted waiting for process!");
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    BatchVelvet.closeInputStream(inputStream);
                    BatchVelvet.closeInputStream(errorStream);
                    throw throwable;
                }
                BatchVelvet.closeInputStream(inputStream);
                BatchVelvet.closeInputStream(errorStream);
                break block6;
            }
            BatchVelvet.closeInputStream(inputStream);
            BatchVelvet.closeInputStream(errorStream);
        }
    }

    private static void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String generateFileName(String name) {
        return String.valueOf(name.split("\\.")[0]) + "_contigs.fa";
    }
}

