/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import misc.StreamReaderThread;
import misc.SystemCommand;

public class BatchSearchForsmid {
    public static void main(String[] args) throws Exception {
        File[] fastaFiles;
        File fastaFileDir = new File(args[0]);
        String seq = new String(args[1]);
        File[] fileArray = fastaFiles = fastaFileDir.listFiles();
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File fastaFile = fileArray[n2];
            if (!fastaFile.getName().endsWith("fa")) {
                System.out.println("Skip " + fastaFile.getName());
            } else {
                String cmd = "grep -o \"" + seq.toUpperCase() + "\" " + fastaFile.getAbsolutePath() + " | wc -l";
                String[] commandArray = new String[]{"bash", "-c", cmd};
                SystemCommand command = new SystemCommand(commandArray, null, true);
                command.makeItSo();
                int count = Integer.valueOf(command.getStandardOut().trim());
                if (count >= 15) {
                    System.out.println("find " + count + " " + fastaFile.getName());
                }
            }
            ++n2;
        }
    }

    public static void runCmd(String cmd, File dir) {
        block6: {
            String data = null;
            InputStream inputStream = null;
            InputStream errorStream = null;
            StringBuffer err = new StringBuffer();
            StringBuffer out = new StringBuffer();
            try {
                Process proc = Runtime.getRuntime().exec(cmd, null, dir);
                inputStream = proc.getInputStream();
                errorStream = proc.getErrorStream();
                StreamReaderThread outThread = new StreamReaderThread(inputStream, out, true);
                StreamReaderThread errThread = new StreamReaderThread(errorStream, err, true);
                outThread.start();
                errThread.start();
                int result = proc.waitFor();
                outThread.join();
                errThread.join();
                data = out.toString();
            }
            catch (IOException ioe) {
                System.err.println("an I/O error occurs" + ioe.toString());
                System.exit(1);
                BatchSearchForsmid.closeInputStream(inputStream);
                BatchSearchForsmid.closeInputStream(errorStream);
                break block6;
            }
            catch (InterruptedException e) {
                try {
                    System.err.println("Interrupted waiting for process!");
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    BatchSearchForsmid.closeInputStream(inputStream);
                    BatchSearchForsmid.closeInputStream(errorStream);
                    throw throwable;
                }
                BatchSearchForsmid.closeInputStream(inputStream);
                BatchSearchForsmid.closeInputStream(errorStream);
                break block6;
            }
            BatchSearchForsmid.closeInputStream(inputStream);
            BatchSearchForsmid.closeInputStream(errorStream);
        }
    }

    private static void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String generateFileName(String name) {
        return String.valueOf(name.split("\\.")[0]) + "_contigs.fa";
    }
}

