/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.CrossMatchforKirAllHap;
import java.io.File;
import java.util.Arrays;

public class BatchCrossmatchKirForAllHaps {
    static int BASE = 33;

    public static void main(String[] args) throws Exception {
        File fastaqFileDir = new File(args[0]);
        File kirSeqFile = new File(args[1]);
        File kirExonFile = new File(args[2]);
        File outputDir = new File(args[3]);
        Object[] fastaFiles = fastaqFileDir.listFiles();
        Arrays.sort(fastaFiles);
        Object[] objectArray = fastaFiles;
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object fastaFile = objectArray[n2];
            if (!((File)fastaFile).getName().endsWith("fa")) {
                System.out.println("Skip " + ((File)fastaFile).getName());
            } else {
                System.out.println(((File)fastaFile).getName());
                File output = new File(outputDir, BatchCrossmatchKirForAllHaps.generateDirName(((File)fastaFile).getName()));
                if (output.exists()) {
                    System.out.println("Skip " + output.getName() + " exist");
                } else {
                    CrossMatchforKirAllHap.match((File)fastaFile, kirSeqFile, kirExonFile, output);
                }
            }
            ++n2;
        }
    }

    private static String generateDirName(String name) {
        return name.split("\\.")[0];
    }
}

