/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.ConvertFastaQdataMiSeqNoTrim;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import misc.StreamReaderThread;

public class BatchConvertFastaQdataMiSeq {
    static int BASE = 33;

    public static void main(String[] args) throws Exception {
        File[] fastaFiles;
        File fastaqFileDir = new File(args[0]);
        File topOutputRoot = new File(args[1]);
        int limit = new Integer(args[2]);
        boolean isTrim = new Boolean(args[3]);
        File[] fileArray = fastaFiles = fastaqFileDir.listFiles();
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File fastaqFile = fileArray[n2];
            if (!fastaqFile.getName().endsWith("fq") || new File(topOutputRoot, BatchConvertFastaQdataMiSeq.generateDirName(fastaqFile.getName())).exists()) {
                System.out.println("Skip " + fastaqFile.getName());
            } else {
                System.out.println(fastaqFile.getName());
                File outputRoot = new File(topOutputRoot, BatchConvertFastaQdataMiSeq.generateDirName(fastaqFile.getName()));
                if (!outputRoot.exists() || !outputRoot.isDirectory()) {
                    if (isTrim) {
                        ConvertFastaQdataMiSeq.convert(fastaqFile, outputRoot, limit);
                    } else {
                        ConvertFastaQdataMiSeqNoTrim.convert(fastaqFile, outputRoot, limit);
                    }
                }
            }
            ++n2;
        }
    }

    public static void runCmd(String cmd, File dir) {
        block6: {
            String data = null;
            InputStream inputStream = null;
            InputStream errorStream = null;
            StringBuffer err = new StringBuffer();
            StringBuffer out = new StringBuffer();
            try {
                Process proc = Runtime.getRuntime().exec(cmd, null, dir);
                inputStream = proc.getInputStream();
                errorStream = proc.getErrorStream();
                StreamReaderThread outThread = new StreamReaderThread(inputStream, out, true);
                StreamReaderThread errThread = new StreamReaderThread(errorStream, err, true);
                outThread.start();
                errThread.start();
                int result = proc.waitFor();
                outThread.join();
                errThread.join();
                data = out.toString();
            }
            catch (IOException ioe) {
                System.err.println("an I/O error occurs" + ioe.toString());
                System.exit(1);
                BatchConvertFastaQdataMiSeq.closeInputStream(inputStream);
                BatchConvertFastaQdataMiSeq.closeInputStream(errorStream);
                break block6;
            }
            catch (InterruptedException e) {
                try {
                    System.err.println("Interrupted waiting for process!");
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    BatchConvertFastaQdataMiSeq.closeInputStream(inputStream);
                    BatchConvertFastaQdataMiSeq.closeInputStream(errorStream);
                    throw throwable;
                }
                BatchConvertFastaQdataMiSeq.closeInputStream(inputStream);
                BatchConvertFastaQdataMiSeq.closeInputStream(errorStream);
                break block6;
            }
            BatchConvertFastaQdataMiSeq.closeInputStream(inputStream);
            BatchConvertFastaQdataMiSeq.closeInputStream(errorStream);
        }
    }

    private static void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String generateDirName(String name) {
        return name.split("\\.")[0];
    }
}

