/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import misc.StreamReaderThread;

public class BatchClustering {
    public static void main(String[] args) throws Exception {
        File[] fastaFiles;
        File fastaFileDir = new File(args[0]);
        File outputDir = new File(args[1]);
        String region = new String(args[2]);
        File[] fileArray = fastaFiles = fastaFileDir.listFiles();
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File fastaFile = fileArray[n2];
            if (!fastaFile.getName().endsWith("fa")) {
                System.out.println("Skip " + fastaFile.getName());
            } else {
                System.out.println(fastaFile.getName());
                File tmpDir = new File(outputDir, fastaFile.getName().substring(0, fastaFile.getName().length() - 3));
                if (!tmpDir.exists() || !tmpDir.isDirectory()) {
                    BatchClustering.runCmd("mkdir " + fastaFile.getName().substring(0, fastaFile.getName().length() - 3), outputDir);
                }
                if (region.equals("c1")) {
                    BatchClustering.runCmd("java -jar /asclepius/groups/GeMS/ruihanTest/dev/PrimerClusteringCLI.jar -c -l 0 -p /asclepius/groups/GeMS/ruihanTest/dev/CI-AmpliconPrimers.csv -a -f " + fastaFile.getAbsolutePath() + " -o " + tmpDir.getAbsolutePath(), outputDir);
                } else {
                    BatchClustering.runCmd("java -jar /asclepius/groups/GeMS/ruihanTest/dev/PrimerClusteringCLI.jar -c -l 0 -p /asclepius/groups/GeMS/ruihanTest/dev/CII-AmpliconPrimers.csv -a -f " + fastaFile.getAbsolutePath() + " -o " + tmpDir.getAbsolutePath(), outputDir);
                }
            }
            ++n2;
        }
    }

    public static void runCmd(String cmd, File dir) {
        block6: {
            String data = null;
            InputStream inputStream = null;
            InputStream errorStream = null;
            StringBuffer err = new StringBuffer();
            StringBuffer out = new StringBuffer();
            try {
                Process proc = Runtime.getRuntime().exec(cmd, null, dir);
                inputStream = proc.getInputStream();
                errorStream = proc.getErrorStream();
                StreamReaderThread outThread = new StreamReaderThread(inputStream, out, true);
                StreamReaderThread errThread = new StreamReaderThread(errorStream, err, true);
                outThread.start();
                errThread.start();
                int result = proc.waitFor();
                outThread.join();
                errThread.join();
                data = out.toString();
            }
            catch (IOException ioe) {
                System.err.println("an I/O error occurs" + ioe.toString());
                System.exit(1);
                BatchClustering.closeInputStream(inputStream);
                BatchClustering.closeInputStream(errorStream);
                break block6;
            }
            catch (InterruptedException e) {
                try {
                    System.err.println("Interrupted waiting for process!");
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    BatchClustering.closeInputStream(inputStream);
                    BatchClustering.closeInputStream(errorStream);
                    throw throwable;
                }
                BatchClustering.closeInputStream(inputStream);
                BatchClustering.closeInputStream(errorStream);
                break block6;
            }
            BatchClustering.closeInputStream(inputStream);
            BatchClustering.closeInputStream(errorStream);
        }
    }

    private static void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

