/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import misc.StreamReaderThread;

public class BatchAmpScreen {
    public static void main(String[] args) throws Exception {
        File[] fastaFiles;
        File fastaFileDir = new File(args[0]);
        File VectorFn = new File(args[1]);
        File[] fileArray = fastaFiles = fastaFileDir.listFiles();
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File fastaFile = fileArray[n2];
            if (!fastaFile.getName().endsWith("fa")) {
                System.out.println("Skip " + fastaFile.getName());
            } else {
                System.out.println(fastaFile.getName());
                File tmpDir = new File(fastaFileDir, "temp");
                if (!tmpDir.exists() || !tmpDir.isDirectory()) {
                    BatchAmpScreen.runCmd("mkdir temp", fastaFileDir);
                }
                BatchAmpScreen.runCmd("/genome/bin/cross_match -minmatch 25 -minscore 50 -screen " + fastaFile.getAbsolutePath() + " " + VectorFn.getAbsolutePath(), fastaFileDir);
                File screenFile = new File(String.valueOf(fastaFile.getAbsolutePath()) + ".screen");
                if (screenFile.exists()) {
                    BatchAmpScreen.runCmd("mv " + screenFile.getAbsolutePath() + " " + fastaFile.getAbsolutePath(), fastaFileDir);
                }
            }
            ++n2;
        }
    }

    public static void runCmd(String cmd, File dir) {
        block6: {
            String data = null;
            InputStream inputStream = null;
            InputStream errorStream = null;
            StringBuffer err = new StringBuffer();
            StringBuffer out = new StringBuffer();
            try {
                Process proc = Runtime.getRuntime().exec(cmd, null, dir);
                inputStream = proc.getInputStream();
                errorStream = proc.getErrorStream();
                StreamReaderThread outThread = new StreamReaderThread(inputStream, out, true);
                StreamReaderThread errThread = new StreamReaderThread(errorStream, err, true);
                outThread.start();
                errThread.start();
                int result = proc.waitFor();
                outThread.join();
                errThread.join();
                data = out.toString();
            }
            catch (IOException ioe) {
                System.err.println("an I/O error occurs" + ioe.toString());
                System.exit(1);
                BatchAmpScreen.closeInputStream(inputStream);
                BatchAmpScreen.closeInputStream(errorStream);
                break block6;
            }
            catch (InterruptedException e) {
                try {
                    System.err.println("Interrupted waiting for process!");
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    BatchAmpScreen.closeInputStream(inputStream);
                    BatchAmpScreen.closeInputStream(errorStream);
                    throw throwable;
                }
                BatchAmpScreen.closeInputStream(inputStream);
                BatchAmpScreen.closeInputStream(errorStream);
                break block6;
            }
            BatchAmpScreen.closeInputStream(inputStream);
            BatchAmpScreen.closeInputStream(errorStream);
        }
    }

    private static void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String generateFileName(String name) {
        return String.valueOf(name.split("\\.")[0]) + "_contigs.fa";
    }
}

