/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.Random;
import misc.FileManager;
import misc.SystemCommand;
import primerDesign.GetBackbone;

public class AssemblySimulation {
    public static void main(String[] args) throws Exception {
        File backBoneFile = new File(args[0]);
        File workdir = new File(args[1]);
        int backboneStart = new Integer(args[2]);
        int backboneSize = new Integer(args[3]);
        int chromatUnit = new Integer(args[4]);
        int coverage = new Integer(args[5]);
        String backbone = GetBackbone.getSequenceFromFasta(backBoneFile).substring(backboneStart, backboneStart + backboneSize);
        int chromatsCount = backboneSize * coverage / chromatUnit;
        System.out.println("chromatsCount=" + chromatsCount);
        File phdDir = AssemblySimulation.createDirs(workdir);
        Random generator = new Random();
        SystemCommand command = null;
        int i = 0;
        while (i < chromatsCount) {
            int randomIndex = generator.nextInt(backboneSize);
            String sequence = backbone.substring(randomIndex, Math.min(randomIndex + chromatUnit, backboneSize));
            File tmpFile = File.createTempFile("chromat", "fa");
            StringBuilder builder = new StringBuilder();
            builder.append(">").append(i).append("\n");
            builder.append(sequence);
            FileManager.writeTextFile(tmpFile, builder.toString(), true);
            command = new SystemCommand("/usr/local/bin/perl /genome/bin/fasta2Phd.perl " + tmpFile.getAbsolutePath(), phdDir, false);
            command.makeItSo();
            ++i;
        }
        File tmpFile = File.createTempFile("backbone", "fa");
        StringBuilder builder = new StringBuilder();
        builder.append(">").append("backbone").append("\n");
        builder.append(backbone);
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        command = new SystemCommand("/usr/local/bin/perl /genome/bin/fasta2Phd.perl " + tmpFile.getAbsolutePath(), phdDir, false);
        command.makeItSo();
    }

    private static File createDirs(File workdir) {
        System.out.println("createDirs");
        File phdDir = new File(workdir, "phd_dir");
        System.out.println(String.valueOf(phdDir.exists()) + " " + phdDir.isDirectory() + " " + phdDir.getAbsolutePath());
        File chromatDir = new File(workdir, "chromat_dir");
        File assembly = new File(workdir, "assembly");
        if (!phdDir.exists() || !phdDir.isDirectory()) {
            System.out.println("createPHDDirs");
            phdDir.mkdirs();
        }
        if (!chromatDir.exists() || !chromatDir.isDirectory()) {
            chromatDir.mkdirs();
        }
        if (!assembly.exists() || !assembly.isDirectory()) {
            assembly.mkdirs();
        }
        return phdDir;
    }
}

