/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class AlleleFrequency {
    static String DRB_NP = "DRB*NP";

    public static void main(String[] args) throws Exception {
        File[] files;
        File inputDir = new File(args[0]);
        File outputFile = new File(args[1]);
        HashMap<String, Map<String, List<String>>> sampleTypes = new HashMap<String, Map<String, List<String>>>();
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("csv")) {
                AlleleFrequency.parseReportFile(file, sampleTypes);
            }
            ++n2;
        }
        String out = AlleleFrequency.calculateFrequency(sampleTypes);
        FileManager.writeTextFile(outputFile, out, true);
    }

    private static String calculateFrequency(Map<String, Map<String, List<String>>> sampleTypes) {
        System.out.println("Number of population : " + sampleTypes.size());
        LinkedHashMap<String, Integer> locusCount = new LinkedHashMap<String, Integer>();
        LinkedHashMap locusTypeCount = new LinkedHashMap();
        for (String sample : sampleTypes.keySet()) {
            Map<String, List<String>> locusTypes = sampleTypes.get(sample);
            for (String locus : locusTypes.keySet()) {
                if (!locusCount.containsKey(locus)) {
                    locusCount.put(locus, 0);
                }
                if (!locusTypeCount.containsKey(locus)) {
                    locusTypeCount.put(locus, new HashMap());
                }
                locusCount.put(locus, (Integer)locusCount.get(locus) + 1);
                for (String type : locusTypes.get(locus)) {
                    if (!((Map)locusTypeCount.get(locus)).containsKey(type)) {
                        ((Map)locusTypeCount.get(locus)).put(type, 0);
                    }
                    ((Map)locusTypeCount.get(locus)).put(type, (Integer)((Map)locusTypeCount.get(locus)).get(type) + 1);
                }
            }
        }
        StringBuilder out = new StringBuilder();
        out.append("type").append("\t").append("occurenceCount").append("\t").append("reportSampleSize").append("\t").append("%frequency").append("\n");
        for (String locus : locusTypeCount.keySet()) {
            System.out.println(locus);
            int sampleCountForLocus = (Integer)locusCount.get(locus);
            Map typeCounts = (Map)locusTypeCount.get(locus);
            for (String type : typeCounts.keySet()) {
                out.append(type).append("\t").append(typeCounts.get(type)).append("\t").append(sampleCountForLocus).append("\t").append(AlleleFrequency.format(sampleCountForLocus, typeCounts, type)).append("\n");
            }
        }
        return out.toString();
    }

    private static String format(int sampleCountForLocus, Map<String, Integer> typeCounts, String type) {
        DecimalFormat df2 = new DecimalFormat("#.###");
        double num = 100.0 * (double)typeCounts.get(type).intValue() / (1.0 * (double)sampleCountForLocus);
        return df2.format(num);
    }

    private static void parseReportFile(File file, Map<String, Map<String, List<String>>> sampleTypes) {
        String[] lines = FileManager.readTextFile(file).split("\n");
        int i = 1;
        while (i < lines.length) {
            String[] items = lines[i].split(",");
            if (items.length >= 5) {
                String sample = String.valueOf(items[0].trim()) + "-" + items[1].trim();
                String locus = items[2].trim();
                String type1 = items[3].trim();
                String type2 = items[4].trim();
                if (locus.startsWith("DRB345")) {
                    if (type1.equals("DRB345*Not_Present")) {
                        type1 = DRB_NP;
                    }
                    if (type2.equals("DRB345*Not_Present")) {
                        type2 = DRB_NP;
                    }
                }
                if (sample.length() > 0 && locus.length() > 0 && type1.length() > 0 && type2.length() > 0) {
                    if (!sampleTypes.containsKey(sample)) {
                        sampleTypes.put(sample, new LinkedHashMap());
                    }
                    if (!sampleTypes.get(sample).containsKey(locus)) {
                        sampleTypes.get(sample).put(locus, new ArrayList());
                        if (locus.length() > 6) {
                            System.out.println("check : " + sample);
                        }
                    }
                    sampleTypes.get(sample).get(locus).add(type1);
                    if (!type1.equals(type2)) {
                        sampleTypes.get(sample).get(locus).add(type2);
                    }
                    if (sampleTypes.get(sample).get(locus).size() > 2) {
                        System.out.println("duplicate : " + sample);
                    }
                }
            }
            ++i;
        }
    }
}

