/*
 * Decompiled with CFR 0.152.
 */
package externalSnpCallerTool;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import misc.FileManager;

public class SortChromats {
    private static final String HLA_A = "HLA-A";
    private static final String HLA_B = "HLA-B-Single";
    private static final String HLA_C = "HLA-C";
    private static final String BID = "916d";
    private static final String CID = "916e";

    public static void main(String[] args) {
        File inDir = new File(args[0]);
        File outDir = new File(args[1]);
        Map<String, String> primerAmpMap = SortChromats.initHlaMap();
        File[] inFiles = inDir.listFiles();
        File destDir = null;
        String name = null;
        String primer = null;
        String id = null;
        String amplicon = null;
        File[] fileArray = inFiles;
        int n = inFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            name = file.getName();
            if (name.indexOf("_") >= 0) {
                primer = name.split("_")[1];
                id = name.split("_")[2];
                amplicon = primerAmpMap.get(primer);
                if (amplicon == null) {
                    System.out.println(name);
                } else {
                    if (amplicon.equalsIgnoreCase(HLA_B) && id.startsWith(CID)) {
                        amplicon = HLA_C;
                    }
                    if (!(destDir = new File(new File(outDir, amplicon), "chromat_dir")).exists()) {
                        destDir.mkdirs();
                    }
                    FileManager.copyFile(file, new File(destDir, name), true);
                    file.deleteOnExit();
                }
            }
            ++n2;
        }
    }

    private static Map<String, String> initHlaMap() {
        HashMap<String, String> primerAmpMap = new HashMap<String, String>();
        primerAmpMap.put("5AIn1-99", HLA_A);
        primerAmpMap.put("3AIn3-41", HLA_A);
        primerAmpMap.put("ASEQ3", HLA_A);
        primerAmpMap.put("ASEQ5", HLA_A);
        primerAmpMap.put("M13F", HLA_B);
        primerAmpMap.put("M13R", HLA_B);
        primerAmpMap.put("BINR2R", HLA_B);
        primerAmpMap.put("HLABSEQF1B", HLA_B);
        primerAmpMap.put("M13F", HLA_C);
        primerAmpMap.put("M13R", HLA_C);
        primerAmpMap.put("HLABSEQR123", HLA_C);
        primerAmpMap.put("CF1CSEQ", HLA_C);
        return primerAmpMap;
    }
}

