/*
 * Decompiled with CFR 0.152.
 */
package externalSnpCallerTool;

import java.io.File;

public class RenameChromatsRuthy {
    private static final String HLA_A = "HLA-A";
    private static final String HLA_B = "HLA-B";
    private static final String HLA_C = "HLA-C";
    private static final String[] list = new String[]{"HLA-A", "HLA-B", "HLA-C"};
    private static final String CHROMAT_DIR = "chromat_dir";

    public static void main(String[] args) {
        File[] files;
        File inDir = new File(args[0]);
        File outDir = new File(args[1]);
        File[] fileArray = files = inDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            String newName = RenameChromatsRuthy.formatName(name);
            System.out.println(String.valueOf(name) + " -> " + newName);
            file.renameTo(new File(outDir, newName));
            ++n2;
        }
    }

    private static String formatName(String name) {
        String[] items = name.substring(0, name.length() - 4).split("_");
        String cellLine = null;
        String primer = null;
        if (name.startsWith("BLANK")) {
            cellLine = items[0];
            primer = "primer";
        } else {
            cellLine = items[1];
            if (cellLine.toUpperCase().startsWith("DUCAP")) {
                cellLine = "DUCAP";
            } else if (cellLine.toUpperCase().startsWith("LNCAP")) {
                cellLine = "LNCAP";
            } else if (cellLine.toUpperCase().startsWith("PC3")) {
                cellLine = "PC3";
            } else if (cellLine.toUpperCase().startsWith("VCAP")) {
                cellLine = "VCAP";
            }
            primer = items[0];
        }
        if (items.length >= 3 && items[2].trim().length() > 0) {
            return String.valueOf(cellLine.trim()) + "_" + primer.trim() + "_" + items[2].trim();
        }
        return String.valueOf(cellLine.trim()) + "_" + primer.trim();
    }
}

