/*
 * Decompiled with CFR 0.152.
 */
package dbFileSystems;

import dbFileSystems.FlankingSeq;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;
import misc.StringUtils;

public class MapSnps {
    static int SIZE = 10;

    public static void main(String[] args) throws Exception {
        File geneSnpsFn = new File(args[0]);
        File ampliconSnpFn = new File(args[1]);
        String[] lines = FileManager.readTextFile(geneSnpsFn).split("\n");
        System.out.println("total snp record seaching " + lines.length);
        Map<Integer, FlankingSeq> snpInfo = MapSnps.getSnpInfo(ampliconSnpFn);
        MapSnps.mapSnps(lines, snpInfo);
    }

    private static void mapSnps(String[] lines, Map<Integer, FlankingSeq> snpInfo) {
        for (Integer pos : snpInfo.keySet()) {
            String flank5 = snpInfo.get(pos).getSeq5End();
            flank5 = flank5.substring(flank5.length() - SIZE, flank5.length());
            String flank5rev = StringUtils.revCompSeq(flank5);
            String flank3 = snpInfo.get(pos).getSeq3End();
            flank3 = flank3.substring(0, SIZE);
            String flank3rev = StringUtils.revCompSeq(flank3);
            String rs = "";
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.trim().length() != 0) {
                    String[] items = line.trim().split("\t");
                    String record5end = items[2].trim();
                    record5end = record5end.substring(record5end.length() - SIZE, record5end.length());
                    String record3end = items[4].trim();
                    record3end = record3end.substring(0, SIZE);
                    if (line.indexOf(flank5) > 0 && line.indexOf(flank3) > 0) {
                        if (record5end.equals(flank5) && record3end.equals(flank3)) {
                            rs = items[0].trim();
                            break;
                        }
                    } else if (line.indexOf(flank5rev) > 0 && line.indexOf(flank3rev) > 0 && record5end.equals(flank3rev) && record3end.equals(flank5rev)) {
                        rs = items[0].trim();
                        break;
                    }
                }
                ++n2;
            }
            System.out.println(pos + "\t" + rs);
        }
    }

    private static Map<Integer, FlankingSeq> getSnpInfo(File ampliconSnpFn) {
        LinkedHashMap<Integer, FlankingSeq> snpInfo = new LinkedHashMap<Integer, FlankingSeq>();
        String[] lines = FileManager.readTextFile(ampliconSnpFn).split("\n");
        String[] header = lines[0].trim().split(",");
        String[] flanking5 = lines[1].trim().split(",");
        String[] flanking3 = lines[2].trim().split(",");
        if (header.length <= 1) {
            return snpInfo;
        }
        int i = 1;
        while (i < header.length) {
            if (header[i].trim().length() == 0) break;
            FlankingSeq af = new FlankingSeq();
            af.setSeq5End(flanking5[i].trim());
            af.setSeq3End(flanking3[i].trim());
            snpInfo.put(Integer.valueOf(header[i]), af);
            ++i;
        }
        return snpInfo;
    }
}

