/*
 * Decompiled with CFR 0.152.
 */
package dbFileSystems;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import misc.FileManager;

public class GetRecentProject {
    public static void main(String[] args) {
        int numOfDays = new Integer(args[0]);
        File outputFile = new File(args[1]);
        Calendar cleanUpGracePeriod1 = Calendar.getInstance();
        cleanUpGracePeriod1.add(5, numOfDays * -1);
        StringBuilder output = new StringBuilder();
        String query = "select distinct project_name from pcr.chromat_report_mv where creation_date > ?";
        try {
            String sourceDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
            Class.forName("org.postgresql.Driver");
            Connection db = DriverManager.getConnection(sourceDBurl, "gems", "Caff1ne");
            PreparedStatement preparedStatement = db.prepareStatement(query);
            preparedStatement.setTimestamp(1, new Timestamp(cleanUpGracePeriod1.getTimeInMillis()));
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                output.append(resultSet.getString("project_name")).append("\n");
            }
            GetRecentProject.closeResources(resultSet, preparedStatement, db);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        System.out.println(output.toString());
        FileManager.writeTextFile(outputFile, output.toString(), true);
        System.out.println("write project_name to " + outputFile.getAbsolutePath());
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

