/*
 * Decompiled with CFR 0.152.
 */
package dbFileSystems;

import guid.IdentifierFactory;
import importChromat.ImportExternalChromats;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class FixRuleSet {
    public static final String INSERT_MATCH = "insert into genotype.match (match_id, genotype, type_set_id, not_match, position, match_type, deletion_count) VALUES (?, ?, ?, ?, ?, ?, ?)";

    public static void main(String[] args) {
        File inFiles = new File(args[0]);
        String sourceDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        String[] typeSetIds = FileManager.readFile(inFiles).split("\n");
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(sourceDBurl, "gems", "Caff1ne");
            FixRuleSet.startProcess(typeSetIds, srcDB);
            FixRuleSet.closeResources(null, null, srcDB);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void startProcess(String[] typeSetIds, Connection srcDB) {
        LinkedHashMap<Integer, String> matches = new LinkedHashMap<Integer, String>();
        matches.put(112, "GG");
        matches.put(113, "AA");
        matches.put(118, "GG");
        matches.put(123, "AA");
        matches.put(124, "CC");
        matches.put(125, "AA");
        String[] stringArray = typeSetIds;
        int n = typeSetIds.length;
        int n2 = 0;
        while (n2 < n) {
            String typeSetId = stringArray[n2];
            System.out.println("processing " + typeSetId);
            FixRuleSet.insertMatches(typeSetId, matches, srcDB);
            ++n2;
        }
    }

    private static void insertMatches(String typeSetId, Map<Integer, String> matches, Connection srcDB) {
        for (Integer pos : matches.keySet()) {
            String matchId = IdentifierFactory.createUniqueIdentifier().getId();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = srcDB.prepareStatement(INSERT_MATCH);
                preparedStatement.setString(1, matchId);
                preparedStatement.setString(2, matches.get(pos));
                preparedStatement.setString(3, typeSetId.trim());
                preparedStatement.setBoolean(4, false);
                preparedStatement.setInt(5, pos);
                preparedStatement.setString(6, "SUBSTITUTION");
                preparedStatement.setInt(7, 0);
                preparedStatement.executeUpdate();
                ImportExternalChromats.closeResources(null, preparedStatement, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Map<String, Map<String, String>> getGenotypingDate(Map<String, String> genotypeResultIds, Connection db) {
        HashMap<String, Map<String, String>> genotypes = new HashMap<String, Map<String, String>>();
        String query = "select cell_line_id, modified_date, group_name from genotype.result_diploid_cell_line where result_id = ?";
        try {
            for (String resultId : genotypeResultIds.values()) {
                PreparedStatement preparedStatement = db.prepareStatement(query);
                preparedStatement.setString(1, resultId);
                ResultSet resultSet = preparedStatement.executeQuery();
                Object genotype = null;
                while (resultSet.next()) {
                    String cellLineId = resultSet.getString("cell_line_id");
                    String modifiedDate = resultSet.getString("modified_date").substring(0, 10);
                    String groupName = resultSet.getString("group_name");
                    if (!genotypes.containsKey(groupName)) {
                        genotypes.put(groupName, new HashMap());
                    }
                    ((Map)genotypes.get(groupName)).put(cellLineId, modifiedDate);
                }
                FixRuleSet.closeResources(resultSet, preparedStatement, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        return genotypes;
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

